function Building(n, x, y, g, a, d) {
	this.name = n;
	this.x = x;
	this.y = y;
	this.game = g;
	this.active = typeof a !== 'undefined' ? a : true; // default buildings are active (have event listeners)
	this.disabled = typeof d !== 'undefined' ? d : true; // default buildings are disabled (cannot enter unless activated)
	this.bitmap = null;
	this.image = null;
};

Building.current = null;

Building.prototype.getBuildingData = function() {
	if (window.buildingdata)
		return window.buildingdata[this.name];
	return null;
}

Building.prototype.init = function(image) {
	this.bitmap = new createjs.Bitmap(image);
	this.bitmap.x = this.x;
	this.bitmap.y = this.y;
	this.image = image;
	this.bitmap.cache(0, 0, this.bitmap.image.width, this.bitmap.image.height);

	if (this.bitmap != null && this.active) {
		var building = this;

		var b = this.bitmap;
		var g = this.game;
		var name = this.name;

		var container = this.game.map.container;
		this.bitmap.cursor = "pointer";

		// ELEMENT WYŁĄCZONEGO SPRZEDAWANIA BIUR
		//var hoverTimer = null;
		var dontHide = false;

		var budTiooltip = null;

		this.bitmap.addEventListener("click", function() {
			if (budTiooltip && $('#' + budTiooltip.attr('aria-describedby')).length)
				budTiooltip.tooltip('close');
			budTiooltip = null;
			// ELEMENT WYŁĄCZONEGO SPRZEDAWANIA BIUR
			//	$('.popupX').remove();
			//	window.clearTimeout(hoverTimer);
			if (!$(".ui-dialog-content").is(':visible') && window.isLoggedIn && building.disabled == false && (window.userdata["tura_aktywna"] || window.userdata["tura"] < 0)) {
				var budDat = building.getBuildingData();
				var bid = budDat["id"];
				if (bid == null) bid = 0;
				var rodzaj = budDat["rodzajBudynku"];
				if (rodzaj == "biuro") {
					$('#gameTooltip1').css({
						top: '-500px',
						left: '-500px'
					});

					// przy kliknieciu ponownie sprawdzamy czy ktoś inny nie wynajął
					$.get(window.links.studentAjaxGetOfficesData, function(resoff) {
						if (resoff != 0 && resoff != null) {
							var res = jQuery.parseJSON(resoff);
							window.userdata["biura"] = res['biura'];
							window.biurodata = jQuery.parseJSON(window.userdata['biura']);

							var biura = $.parseJSON(window.userdata.biura);
							if (biura[bid].idFirmy == window.userdata.id_firmy) {
								//wejdź do biura gracza
								createjs.Tween.get(container).to({
									x: -(b.x - 50) * 5,
									y: -b.y * 5,
									scaleX: 5,
									scaleY: 5,
									alpha: 0
								}, 1000).call(function() {
									window.location.hash = '#biuroGracza';
								});
							} else //if (parseInt(window.userdata.ilosc_biur) <= 0)
							{
								//nie masz biura -> możesz je wynająć
								if (parseInt(window.userdata["ilosc_biur"]) <= 0) {
									$("#dialog-biuro").load(window.links.studentAjaxBiuroDialog, {
										budynekId: bid
									}, function(b) {
										activateBiuro(bid);
									});
								} else {
									/*
																		$("#dialog-info").load(window.links.studentAjaxInfoDialog, { }, function() {
									                                                                        	activateInfo(parseInt(window.userdata["tura"]), 166,undefined,"Nie możesz wynająć większej ilości biur na tym etapie gry!","Posiadasz już jedno biuro!");
									                                                                	});
									*/
								}
							}
						}
					});
				} else if (rodzaj == "kontrahent") {
					//wejdź do biura kontrahenta
					Building.current = building;
					$("#gameTooltip1").css({
						top: "-500px",
						left: "-500px"
					});
					var tween = createjs.Tween.get(container).to({
						x: -(b.x - 50) * 5,
						y: -b.y * 5,
						scaleX: 5,
						scaleY: 5,
						alpha: 0
					}, 1000).call(function() {
						window.location.hash = "#biuroZlecenia1";
						//window.location.hash="#kontrahent-"+name;
					});
				} else {
					$(".gameTooltip").each(function() {
						var tname = $(this).attr('aria-describedby');
						var child = $("#" + tname);
						if (child.length > 0) {
							$(this).tooltip('close');
							$(this).attr("title", "");
						}
						$(this).attr("canvasX", "-500");
						$(this).attr("canvasY", "-500");
						$(this).prop("canvasX", "-500");
						$(this).prop("canvasY", "-500");
						$(this).css({
							top: "-500px",
							left: "-500px"
						});
					});
					var tween = createjs.Tween.get(container).to({
						x: -(b.x - 50) * 5,
						y: -b.y * 5,
						scaleX: 5,
						scaleY: 5,
						alpha: 0
					}, 1000).call(function() {
						window.location.hash = "#" + name;
					});
				}
			} else {
				g.map.bitmap.dispatchEvent("click");
			}
		});

		this.bitmap.addEventListener("mousedown", function(evt) {
			evt.addEventListener("mousemove", function(e) {
				e.target = g.map.bitmap;
				g.map.bitmap.dispatchEvent(e);
			})
			evt.target = g.map.bitmap;
			g.map.bitmap.dispatchEvent(evt);
		});

		this.bitmap.addEventListener("mouseover", function() {
			if (!$(".ui-dialog-content").is(':visible') && window.isLoggedIn) // BUDYNKOM WYLACZONYM TEZ MAJA SIE POKAZYWAC TOOLTIPY: && building.disabled == false)
				budTiooltip = building.showTooltip("#gameTooltip1", false, building);
			var budDat = building.getBuildingData();
			if (budDat == null)
				return;
			var bid = budDat["id"];
			if (bid == null) bid = 0;
			var rodzaj = budDat["rodzajBudynku"];
			if (rodzaj != "biuro")
				return;

			// WYŁĄCZAMY SPRZEDAWANIE BIUR BO NIE DZIAŁA JAK NALEŻY
			/*
			var biura = $.parseJSON(window.userdata.biura);
			if (biura[bid].idFirmy != window.userdata.id_firmy)
				return;
			hoverTimer = window.setTimeout(function(){
				var popup = $('<div class="popupX" style="z-index:0;display:none;position:fixed;left:0;right:0;width:51px;height:51px">' +
					'<div class="barbutton2" original-title="Sprzedaj biuro" title="Sprzedaj biuro" style="font-size:36px;display:block;line-height:51px;text-align:center">$</div></div>');
				popup.tipsy();
				var p = b.localToGlobal(0,0);
				$('#canvasHolder').append(popup);
				popup.css({
					left: p.x+50 + 'px',
					top: p.y+50 + 'px',
				});
				popup.fadeIn();
				popup.hover(function(){
					dontHide = true;
				},function(){
					dontHide = false;
					popup.fadeOut(400, function(){$(this).remove();});
				});
				popup.click(function(){
					popup.fadeOut(400, function(){$(this).remove();});
					console.log('sprzedaj biuro w ' + bid);
					$("#dialog-biuro").load(window.links.studentAjaxBiuroDialog, { budynekId: bid }, function() {
						activateBiuro(bid, 'sellBiuro');
					});
				});
			}, 1000);
			*/
		});

		this.bitmap.addEventListener("mouseout", function() {
			if (budTiooltip && $('#' + budTiooltip.attr('aria-describedby')).length)
				budTiooltip.tooltip('close');
			budTiooltip = null;
			// WYŁĄCZAMY SPRZEDAWANIE BIUR BO NIE DZIAŁA JAK NALEŻY
			/*
			window.clearTimeout(hoverTimer);
			if (!dontHide)
				$('.popupX').fadeOut(400, function(){
						$(this).remove();
					});
			*/
			if (!$(".ui-dialog-content").is(':visible') && window.isLoggedIn) {
				$(".gameTooltip").css( //, .ui-tooltip
					{
						top: "-500px",
						left: "-500px"
					});
			}
		});
	}
};

Building.prototype.showTooltip = function(whichTooltip, stick, object) {
	var this2 = typeof object !== 'undefined' ? object : this;
	var bitmap = this2.bitmap;
	var name = this2.name;

	var tooltipObj = $('<div class="gameTooltip sticker interiorTooltip" title="" style="top:-500px;left:-500px"></div>');
	tooltipObj.appendTo($('#canvasHolder'));

	var container = this.game.map.container;

	var width = this2.image.width;
	var height = this2.image.height;

	var x = bitmap.x;
	var y = bitmap.y;

	tooltipObj.tooltip({
		disabled: true,
		position: {
			using: function() {
				var nx = x - ($(this).outerWidth(true) - width) / 2;
				var ny = y - $(this).outerHeight(true);
				var dy = ny + container.y - 16 >= 0;
				$(this).attr("canvasY", dy ? ny - 16 : y + height + 16);
				$(this).attr("canvasX", nx);
				$(this).addClass("sticker");
				$('<div>').addClass('tooltip-arrow').addClass(dy ? 'middle' : 'top')
					.addClass('center').appendTo(this);
			}
		},
		show: {
			effect: 'slideDown',
			duration: 100
		},
		hide: {
			effect: 'slideUp',
			duration: 100
		},
		close: function(event) {
			$(event.target).remove();
		}
	});

	var logo = null;

	if (typeof window.buildingdata !== 'undefined') {
		var bid = window.buildingdata[name]["id"];
		if (bid == null) bid = 0;
		var opis = window.buildingdata[name]["opis"];
		if (opis == null) opis = "";
		var adres = window.buildingdata[name]["adres"];
		if (adres == null) adres = "";
		var ilogo = window.buildingdata[name]["urlLogo"];
		if (ilogo == null) ilogo = "";
		var rodzaj = window.buildingdata[name]["rodzajBudynku"];

		if (rodzaj == "bank") {
			var bankOpis = window.bankdata[name]["opis"];
			var bankZalozenie = window.bankdata[name]["oplataZalozenie"];
			var bankMiesieczna = window.bankdata[name]["oplataMiesieczna"];
			var bankPrzelew = window.bankdata[name]["oplataPrzelew"];
			var bankOprocentowanie = window.bankdata[name]["oprocentowanie"];
			tooltipObj.tooltip("option", "content", "<img src='" + window.links.baseUrl + "/images/" + ilogo + "' style='height: 100px;'/><br/>" + bankOpis + "<br/><span style='text-decoration:underline'>cennik usług:</span><br/>założenie konta: " + bankZalozenie + " zł<br/>" + "prowadzenie konta: " + bankMiesieczna + " zł/m<br/>opłata za przelew: " + bankPrzelew + " zł<br/>oprocentowanie: " + bankOprocentowanie + "%<br/>" + adres);
			logo = ilogo;
		} else if (rodzaj == "biuro") {
			var biuroPowierzchnia = window.biurodata[bid]["powierzchnia"];
			if (biuroPowierzchnia == null) biuroPowierzchnia = "";
			var biuroMaxPracownikow = window.biurodata[bid]["maxPracownikow"];
			if (biuroMaxPracownikow == null) biuroMaxPracownikow = "";
			var biuroCenaWynajem = window.biurodata[bid]["cenaWynajem"];
			if (biuroCenaWynajem == null) biuroCenaWynajem = "";
			var biuroCenaMedia = window.biurodata[bid]["cenaMedia"];
			if (biuroCenaMedia == null) biuroCenaMedia = "";
			var biuroIdFirmy = window.biurodata[bid]["idFirmy"];
			if (biuroIdFirmy == null) biuroIdFirmy = "";
			var biuroNazwaFirmy = window.biurodata[bid]["nazwaFirmy"];
			if (biuroNazwaFirmy == null) biuroNazwaFirmy = "";
			var biuroLogoFirmy = window.biurodata[bid]["urlLogo"];
			if (biuroLogoFirmy == null) biuroLogoFirmy = "";
			if (!biuroIdFirmy) {
				tooltipObj.tooltip("option", "content", "<span style='text-decoration:underline'>Biuro do wynajęcia:</span><br/>" + adres + "<br/><br/>" + "powierzchnia: " + biuroPowierzchnia + " m<sup>2</sup><br/>maksimum pracowników: " + biuroMaxPracownikow + "<br/>cena wynajmu: " + biuroCenaWynajem + " zł<br/>opłaty za media: " + biuroCenaMedia + " zł"
					//+"<br/>"+this.name //+opis+
				);
			} else {
				if (!biuroLogoFirmy) {
					if (biuroNazwaFirmy.length <= 1) biuroNazwaFirmy = "nieznana firma"
					tooltipObj.tooltip("option", "content", "Biuro " + adres + "<br/>wynajęte przez: " + biuroNazwaFirmy); //+" "+this.name); // +opis+
				} else {
					tooltipObj.tooltip("option", "content", "Biuro " + adres + "<br/>wynajęte przez: " + biuroNazwaFirmy + "<br/><img src='" + window.links.baseUrl + "/" + biuroLogoFirmy + "' style='height:100px;max-width:250px'/>"); //+this.name);
					logo = biuroLogoFirmy;
				}
			}
		} else if (rodzaj == "kontrahent") {
			if (bid) {
				var kontrahentNazwa = window.kontrahentdata[bid]["nazwa"];
				if (kontrahentNazwa == null) kontrahentNazwa = "";
				var kontrahentUrlLoga = window.kontrahentdata[bid]["urlLoga"];
				if (kontrahentUrlLoga == null) kontrahentUrlLoga = "";
				var kontrahentAdres = window.kontrahentdata[bid]["adres"];
				if (kontrahentAdres == null) kontrahentAdres = "";
				var kontrahentTyp = window.kontrahentdata[bid]["typ"];
				if (kontrahentTyp == null) kontrahentTyp = "";
				var kontrahentDziedzina = window.kontrahentdata[bid]["dziedzina"];
				if (kontrahentDziedzina == null) kontrahentDziedzina = "";
				if (kontrahentNazwa.length > 1 && kontrahentTyp == 1) {
					if (!kontrahentUrlLoga) {
						tooltipObj.tooltip("option", "content", "<strong>" + kontrahentNazwa + "</strong><img style='margin-left:5px;margin-top:5px' align='right' alt='" + kontrahentDziedzina +
							"' title='" + kontrahentDziedzina + "' src='" + window.links.baseUrl + '/images/gui/' + kontrahentDziedzina.toLowerCase() +
							".png' /><br/>" + adres + "<br/>"); //+this.name);
					} else {
						tooltipObj.tooltip("option", "content", "<img src='" + kontrahentUrlLoga + "' style='max-height:150px;max-width:250px;'/>" +
							"<br/><div><strong>" + kontrahentNazwa + "</strong><img style='margin-left:5px;margin-top:5px' align='right' alt='" + kontrahentDziedzina +
							"' title='" + kontrahentDziedzina + "' src='" + window.links.baseUrl + '/images/gui/' + kontrahentDziedzina.toLowerCase() +
							".png' /><br/>" + adres + "</div>"); //+this.name);
					}
				} else tooltipObj.tooltip("option", "content", "Kontrahent");
			}
		} else {
			if (!ilogo) {
				tooltipObj.tooltip("option", "content", opis + "<br/>" + adres + "<br/>"); //+this.name);
			} else {
				tooltipObj.tooltip("option", "content", "<img src='" + window.links.baseUrl + "/images/" + ilogo + "' style='height:100px;max-width: 250px;'/><br/>" + opis + "<br/>" + adres + "</br>"); //+this.name);// height 100px
			}
		}
	} else tooltipObj.tooltip("option", "content", "Pusty budynek " + name);

	tooltipObj.click(function() {
		bitmap.dispatchEvent("click");
	});

	tooltipObj.tooltip("open");

	var tname = tooltipObj.attr('aria-describedby');
	var child = $("#" + tname);
	if (child.length)
		child.css({
			left: '-500px',
			top: '-500px'
		});

	adjustDialoguePosition();

	return tooltipObj;
}

Building.prototype.highlight = function(whichTooltip, colorFilter) {
	if (colorFilter != undefined) {
		this.bitmap.filters = [new createjs.ColorFilter(1, 1, 1, 1, 0, 0, 100, 0)];
		this.bitmap.updateCache();
		//this.bitmap.cache(0,0,this.bitmap.image.width, this.bitmap.image.height);
		//this.bitmap.filters[0].applyFilter();
		//this.image = this.bitmap.image;
	} else
		this.showTooltip(whichTooltip, true);
}


Building.prototype.clearFilters = function() {
	this.bitmap.filters = [];
	this.bitmap.updateCache();
}


Building.prototype.setDisabled = function(d) {
	this.disabled = d;
}

function Car(n, sx, sy, speed, active) {
	this.name = n;
	this.sx = sx;
	this.sy = sy;
	this.bitmap = null;
	this.carSpeed = typeof speed !== 'undefined' ? speed : 10;
	this.active = typeof active !== 'undefined' ? active : false;
	this.length = Math.sqrt(sx * sx + sy * sy);
	this.distanceToSource = Number.MAX_VALUE;
	this.distanceToCrossing = Number.MAX_VALUE;
	this.isWaiting = false;
	this.isOnCrossroad = false;
	this.currentCrossroadId = null;
	this.turnSignal = "";
	this.turning = "";
	this.waitingStartTime = 0;

	//te pola służą do skorygowania pozycji pojazdu
	this.northEastOffset = {
		x: 0,
		y: 0
	};
	this.southWestOffset = {
		x: 0,
		y: 0
	};
	this.northWestOffset = {
		x: 0,
		y: 0
	};
	this.southEastOffset = {
		x: 0,
		y: 0
	};

	//17x10
	switch (n) {
		case 'trolejbus':
			this.southWestOffset.y = (-1) * this.sy;

			this.southEastOffset.x = (-1) * this.sx;
			this.southEastOffset.y = (-1) * this.sy - 3;

			this.northWestOffset.y = -22;

			this.northEastOffset.x = -this.sx;
			this.northEastOffset.y = -22;

			this.length -= 15;
			break;
		case 'smart':
		case 'smart2':
		case 'smart3':
		case 'smart4':
			this.southWestOffset.y = (-1) * this.sy;

			this.southEastOffset.x = (-1) * this.sx;
			this.southEastOffset.y = (-1) * this.sy;

			this.northWestOffset.y = -8;

			this.northEastOffset.x = -this.sx;
			this.northEastOffset.y = -8;

			this.length -= 5;
			break;
		case 'star':
		case 'star2':
		case 'star3':
		case 'star4':
			this.southWestOffset.y = (-1) * this.sy;

			this.southEastOffset.x = (-1) * this.sx;
			this.southEastOffset.y = (-1) * this.sy;

			this.northWestOffset.y = -10;

			this.northEastOffset.x = -this.sx;
			this.northEastOffset.y = -10;

			//this.length-=5;
			break;
		case 'porsche':
		case 'porsche2':
		case 'porsche3':
		case 'porsche4':
			this.southWestOffset.y = (-1) * this.sy;

			this.southEastOffset.x = (-1) * this.sx;
			this.southEastOffset.y = (-1) * this.sy;

			this.northWestOffset.y = -5;

			this.northEastOffset.x = -this.sx;
			this.northEastOffset.y = -5;

			this.length -= 5;
			break;
		case 'chevrolet':
		case 'chevrolet2':
		case 'chevrolet3':
		case 'chevrolet4':
			this.southWestOffset.y = (-1) * this.sy;

			this.southEastOffset.x = (-1) * this.sx;
			this.southEastOffset.y = (-1) * this.sy;

			this.northWestOffset.y = -2;

			this.northEastOffset.x = -this.sx;
			this.northEastOffset.y = -2;

			this.length -= 5;
			break;
	}

	this.northEastOffset.x += 3;
	this.northEastOffset.y += 5;

	this.southEastOffset.x += -9;
	this.southEastOffset.y += 3;

	this.northWestOffset.x += 20;
	//this.northWestOffset.y += 4;

	this.southWestOffset.x += -6;
	this.southWestOffset.y += -4;
}

Car.prototype.init = function(image) {
	var img = image;

	if (img != null) {
		var carSprite = new createjs.SpriteSheet({
			images: [img],
			frames: {
				width: this.sx,
				height: this.sy
			},
			animations: {
				northEast: [0],
				northWest: [1],
				southEast: [2],
				southWest: [3]
			}
		});

		this.bitmap = new createjs.BitmapAnimation(carSprite);
	}
}

//position without offsets
Car.prototype.getOriginalPosition = function() {
	var position = {
		x: 0,
		y: 0
	};

	switch (this.bitmap.currentAnimation) {
		case 'southWest':
			position.x = this.bitmap.x - this.southWestOffset.x;
			position.y = this.bitmap.y - this.southWestOffset.y;
			break;
		case 'southEast':
			position.x = this.bitmap.x - this.southEastOffset.x;
			position.y = this.bitmap.y - this.southEastOffset.y;
			break;
		case 'northWest':
			position.x = this.bitmap.x - this.northWestOffset.x;
			position.y = this.bitmap.y - this.northWestOffset.y;
			break;
		case 'northEast':
			position.x = this.bitmap.x - this.northEastOffset.x;
			position.y = this.bitmap.y - this.northEastOffset.y;
			break;
	}

	return position;
}

//position without offsets
Car.prototype.setPosition = function(position) {
	switch (this.bitmap.currentAnimation) {
		case 'southWest':
			this.bitmap.x = position.x - this.southWestOffset.x;
			this.bitmap.y = position.y - this.southWestOffset.y;
			break;
		case 'southEast':
			this.bitmap.x = position.x - this.southEastOffset.x;
			this.bitmap.y = position.y - this.southEastOffset.y;
			break;
		case 'northWest':
			this.bitmap.x = position.x - this.northWestOffset.x;
			this.bitmap.y = position.y - this.northWestOffset.y;
			break;
		case 'northEast':
			this.bitmap.x = position.x - this.northEastOffset.x;
			this.bitmap.y = position.y - this.northEastOffset.y;
			break;
	}
}

Car.prototype.getOriginalRearPosition = function() {
	var frontPosition = this.getOriginalPosition();
	var position = {
		x: 0,
		y: 0
	};
	return frontPosition;
	switch (this.bitmap.currentAnimation) {
		case 'southWest':
			position.x = frontPosition.x + this.sx;
			position.y = frontPosition.y - this.sy;
			break;
		case 'southEast':
			position.x = frontPosition.x - this.sx;
			position.y = frontPosition.y - this.sy;
			break;
		case 'northWest':
			position.x = frontPosition.x + this.sx;
			position.y = frontPosition.y + this.sy;
			break;
		case 'northEast':
			position.x = frontPosition.x - this.sx;
			position.y = frontPosition.y + this.sy;
			break;
	}

	return position;
}

Car.prototype.translate = function(translationVector) {
	if (this.isWaiting)
		return;
	this.bitmap.x += translationVector.items[0];
	this.bitmap.y += translationVector.items[1];
}

Car.prototype.chooseRandomDirection = function() {
	var possibleDirections = [];

	if (this.bitmap.currentAnimation != "northEast" && window.game.map.traffic.crossroads[this.currentCrossroadId].westSouth != null)
		possibleDirections.push("southWest");

	if (this.bitmap.currentAnimation != "northWest" && window.game.map.traffic.crossroads[this.currentCrossroadId].eastSouth != null)
		possibleDirections.push("southEast");

	if (this.bitmap.currentAnimation != "southEast" && window.game.map.traffic.crossroads[this.currentCrossroadId].westNorth != null)
		possibleDirections.push("northWest");

	if (this.bitmap.currentAnimation != "southWest" && window.game.map.traffic.crossroads[this.currentCrossroadId].eastNorth != null)
		possibleDirections.push("northEast");

	this.turnSignal = possibleDirections[Math.floor((Math.random() * possibleDirections.length))];

	this.turning = this.getTurning();
}

Car.prototype.changeDirection = function() {
	var possibleDirections = [];

	if (this.turnSignal != "southWest" && this.bitmap.currentAnimation != "northEast" && window.game.map.traffic.crossroads[this.currentCrossroadId].westSouth != null)
		possibleDirections.push("southWest");

	if (this.turnSignal != "southEast" && this.bitmap.currentAnimation != "northWest" && window.game.map.traffic.crossroads[this.currentCrossroadId].eastSouth != null)
		possibleDirections.push("southEast");

	if (this.turnSignal != "northWest" && this.bitmap.currentAnimation != "southEast" && window.game.map.traffic.crossroads[this.currentCrossroadId].westNorth != null)
		possibleDirections.push("northWest");

	if (this.turnSignal != "northEast" && this.bitmap.currentAnimation != "southWest" && window.game.map.traffic.crossroads[this.currentCrossroadId].eastNorth != null)
		possibleDirections.push("northEast");

	this.turnSignal = possibleDirections[Math.floor((Math.random() * possibleDirections.length))];
	//console.log(possibleDirections);
	this.turning = this.getTurning();
}

Car.prototype.getTurning = function() {
	if (this.bitmap.currentAnimation == this.turnSignal)
		return "straight";
	else if (this.bitmap.currentAnimation == "southWest" && this.turnSignal == "northWest" || this.bitmap.currentAnimation == "southEast" && this.turnSignal == "southWest" || this.bitmap.currentAnimation == "northEast" && this.turnSignal == "southEast" || this.bitmap.currentAnimation == "northWest" && this.turnSignal == "northEast")
		return "right";
	else if (this.bitmap.currentAnimation == "northWest" && this.turnSignal == "southWest" || this.bitmap.currentAnimation == "southWest" && this.turnSignal == "southEast" || this.bitmap.currentAnimation == "southEast" && this.turnSignal == "northEast" || this.bitmap.currentAnimation == "northEast" && this.turnSignal == "northWest")
		return "left";

	return "";
}

function Dialogue(interior, x, y, direction) {
	var dir = typeof direction !== 'undefined' ? direction : "left"; // left or right

	this.x = x;
	this.y = y;
	this.interior = interior;
	this.direction = dir;
	this.workerAlias = null;
	this._hold = false;
	this._gotoRoot = false;

	var p = interior.bitmap.localToGlobal(x, y);

	$("#dialogue").css({
		left: p.x,
		top: p.y,
		width: "350px",
		/*300*/
		height: "550px",
		/*450*/
		backgroundColor: "background-color:rgba(255,255,255,0.7)",
		display: "none"
	});

	if (this.x != undefined)
		$("#dialogue").attr("canvasX", p.x);
	if (this.y != undefined)
		$("#dialogue").attr("canvasY", p.y);
	this.x = p.x;
	this.y = p.y;
};

Dialogue.current = null;

Dialogue.prototype.setWorkerAlias = function(alias) {
	this.workerAlias = alias;
}

Dialogue.prototype.continueDialog = function() {
	this._hold = false;
}

Dialogue.prototype.gotoRoot = function() {
	if (this._hold) {
		this._gotoRoot = true;
		this._hold = false;
	} else {
		this._gotoRoot = false;
		var root = $('#conversationStatements [hash="' + this.interior.name + '"]');
		this.officialStatement(root.attr("dialogueId"));
	}
}

Dialogue.prototype.isStopped = function() {
	return this._hold;
}

Dialogue.prototype.enable = function() {
	//ustaw current dialog
	Dialogue.current = this;
	this._hold = false;

	var dia = this;
	var INTERIOR = this.interior;
	$.get(window.links.studentAjaxGetDialogue, {
			hash: INTERIOR.name
		})
		.done(function(data) {
			$("#dialogue").css({
				left: dia.x,
				top: dia.y,
			});

			if (dia.x != undefined)
				$("#dialogue").attr("canvasX", dia.x);
			if (dia.y != undefined)
				$("#dialogue").attr("canvasY", dia.y);

			if (dia.direction == "right") {
				$("#dialogue").removeClass("dialogue-arrow-left");
				$("#dialogue").addClass("dialogue-arrow-right");
			} else // if left or error
			{
				$("#dialogue").removeClass("dialogue-arrow-right");
				$("#dialogue").addClass("dialogue-arrow-left");
			}
			// ---------------------------------------------

			var conversation = jQuery.parseJSON(data);

			$("#conversationStatements").html("");
			$("#chat").html("");
			$("#questions").html("");

			for (var i = 0; i < conversation.length; i++) {
				var conversationDiv = $('<div></div>');
				conversationDiv.attr("dialogueId", conversation[i].id);
				conversationDiv.attr("dialogueParentId", conversation[i].idRodzica);
				conversationDiv.attr("userStatement", conversation[i].wypowiedzGracza);
				conversationDiv.attr("officialStatement", conversation[i].wypowiedzUrzednika);
				conversationDiv.attr("hash", conversation[i].hash);
				conversationDiv.attr("action", conversation[i].akcja);
				conversationDiv.attr("jumpTo", conversation[i].skoczDoWypowiedziZId);
				conversationDiv.attr("condition", conversation[i].condition);
				if (conversation[i].condition === null)
					$("#conversationStatements").append(conversationDiv);
				else {
					var result = $(document).triggerHandler(conversation[i].condition + '.przedsiebiorcaDialogueEvents');
					//	console.log(conversation[i].condition+" : "+result);
					if (result === undefined) {
						// if current action has allowedInterior == conversation[i].condition then don't show that answer
						//if(conversation[i].condition in window.userdata.allowedInteriors)

						if (typeof window.userdata.allowedInteriors[conversation[i].condition] !== 'undefined')
							result = false; // return false;
						else
							result = true; // return true;

						/* INFO ***
							console.warn('dialog #' + conversation[i].id + ' (' + INTERIOR.name
							+ ') condition handler ' + conversation[i].condition + '.przedsiebiorcaDialogueEvents returned null '
							+ '(missing return statement, handler not attached, handler returned undefined value)');
						** INFO **/
					}

					// else
					if (result) {
						$('#conversationStatements').append(conversationDiv);
					} else {
						// do not append this answer
						//conversationDiv.remove();
						//conversationDiv.append("<del>"+conversationDiv+"</del>");
					}
				}
			}
			$("#dialogue").fadeIn();
			dia.officialStatement();
		});
}

String.prototype.c = function() {
	return this.replace(/\[(.*?)\/(.*?)\]/g, window.userdata['plec'] == 'm' ? '$1' : '$2');
};

Dialogue.strc = function(str) {
	if (typeof str === 'string' || str instanceof String)
		return str.c();
	else
		return '';
}

//function officialStatement(questionId)
Dialogue.prototype.officialStatement = function(questionId) {
	var INTERIOR = this.interior;

	function processMessage(message) {
		var match = message.match(/\{([^\}]{1,})\}/gi);
		for (var i in match) {
			var x = match[i];
			var key = x.substring(1, x.length - 1);
			var result = $(document).triggerHandler('getDialogueParam.przedsiebiorcaDialogueEvents', key);
			if (result !== undefined)
				message = message.replace(x, result);
			else
				console.warn('parametrer handler in dialog (' + INTERIOR.name + ') - getDialogueParam.' + 'przedsiebiorcaDialogueEvents(' + key + ') returned null ' + '(missing return statement, handler not attached, handler returned undefined value)');
		}
		return message;
	}

	if ($("#chat").children().length == 0) {
		// podmiana plci
		//var str = root.attr("officialStatement");
		var str = $("#conversationStatements").html();
		str = Dialogue.strc(str);
		$("#conversationStatements").html(str);

		//getting root
		//var root = $('#conversationStatements [hash="urzadPracy_urzednik2"]');
		//var root = $('#conversationStatements [hash="urzadPracy_rozmowa2"]');
		//var root = $('#conversationStatements [hash="intUPr2"]');
		var root = $('#conversationStatements [hash="' + this.interior.name + '"]');
		var workerAlias = this.workerAlias;
		if (workerAlias === undefined || workerAlias === null)
			workerAlias = 'Pracownik';
		$("#chat").append("<p><b>" + workerAlias + ":</b> <span></span></p>");
		$("#chat p:last span").uniqueId();

		var text = processMessage(root.attr("officialStatement"));
		$("#chat p:last span").writeText(text, showQuestions);

		$("#questions").css("display", "none");

		$("#questions").html("<ul></ul>");

		$('#conversationStatements [dialogueParentId="' + root.attr("dialogueId") + '"]').each(function() {
			var userText = processMessage($(this).attr("userStatement"));
			$("#questions ul").append('<li><span class="question" dialogueId="' + $(this).attr("dialogueId") + '" >' + userText + '</span></li>');
		});
	} else {
		var node = $('#conversationStatements [dialogueId="' + questionId + '"]');

		//handle actions first
		var actionHash = node.attr("action");
		if (actionHash !== undefined && actionHash.length) {
			if (actionHash.indexOf('js:') === 0) {
				//action is javascript event handler name
				var eventHandlerName = actionHash.substring(3);
				$(document).trigger(eventHandlerName + '.przedsiebiorcaDialogueEvents');
			} else if (actionHash.indexOf('js(hold):') === 0) {
				var eventHandlerName = actionHash.substring(9);
				$(document).trigger(eventHandlerName + '.przedsiebiorcaDialogueEvents');
				this._hold = true;
			} else {
				//action in hash
				window.location.hash = actionHash;
				return;
			}
		}

		$("#questions").css("display", "none");
		$("#questions").html("<ul></ul>");
		/*
		$('#chat').animate({
			scrollTop: $("#chat p:last").offset().top
		}, 2000);
		*/

		var DLG = this;

		function say() {
			if (DLG._hold) {
				setTimeout(say, 0);
				return;
			}

			if (node.attr("jumpTo") != undefined && node.attr("jumpTo").length) {
				DLG.officialStatement(node.attr("jumpTo"));
				return;
			}

			if (DLG._gotoRoot) {
				DLG._gotoRoot = false;
				var root = $('#conversationStatements [hash="' + DLG.interior.name + '"]');
				DLG.officialStatement(root.attr("dialogueId"));
				return;
			}

			if (node.attr("officialStatement") != undefined) {
				var text = processMessage(node.attr("officialStatement"));
				var workerAlias = DLG.workerAlias;
				if (workerAlias === undefined || workerAlias === null)
					workerAlias = 'Pracownik';
				$("#chat").append("<p><b>" + workerAlias + ":</b> <span></span></p>");
				$("#chat p:last span").uniqueId();
				$("#chat p:last span").writeText(text, showQuestions, scrollToLastCharacter);
			} else {
				showQuestions();
			}

			$('#conversationStatements [dialogueParentId="' + node.attr("dialogueId") + '"]').each(function() {
				var userText = processMessage($(this).attr("userStatement"));
				$("#questions ul").append('<li><span class="question" dialogueId="' + $(this).attr("dialogueId") + '" >' + userText + '</span></li>');
			});
		}
		if (DLG._hold)
			setTimeout(say, 0);
		else
			say();
	}
}

window.prevCharPosition = 0;

function scrollToLastCharacter() {
	$('#chat').animate({
		scrollTop: $('#chat')[0].scrollHeight
	}, 2000);
}

function showQuestions() {
	$('#chat').clearQueue().finish();
	$("#questions").fadeIn();
	$('#chat').animate({
		scrollTop: $('#chat')[0].scrollHeight
	}, 2000);
}

$(document).on("click", "#questions span", function(event) {
	if (!Dialogue.current.isStopped()) {
		$("#chat").append('<p><b>Ja:</b> ' + $(this).text() + '</p>');
		Dialogue.current.officialStatement($(this).attr("dialogueId"));
	}
});

$(document).on('wniosek.przedsiebiorcaDialogueEvents', function() {

	if (window.userdata["tura"] == "3") {
		// sprawdz czy dotacja zaakceptowana
		function checkForm(handler) {
			$.get(window.links.studentAjaxGetUserData, {
				"formid": "1"
			}, function(re) {
				handler(re);
			});
		}

		checkForm(function(output) {
			return output;
		});
	} else return;
});

$(document).on('konto.przedsiebiorcaDialogueEvents', function() {
	if (window.userdata["tura"] == "4" && window.userdata["tura_aktywna"] && (!window.userdata["stan_konta"] || window.userdata["stan_konta"] <= 0)) {
		$.get(window.links.studentAjaxGetCompanyBank, function(res) {
			if (res >= 1 && res <= 4) {
				return true;
			}
		});

	}
	return false;
});

function Game() {
	this.canvas = null;
	this.stage = null;

	this.preloader = null; // preloader class
	this.container = null; // pointer to currently active container (map or interior)
	this.manifest = []; // list of asset names to load

	this.map = null; // object representing main city map, includes cars and buildings
	this.interiors = []; // an array of Interior objects (banks, offices, institutions etc)
	this.currentInterior = -1; // id of currently active interior

	this.mousePos = {
		x: 300,
		y: 300
	}; // this is for smooth scrolling, set to 300
	this.mouseOldPos = {
		x: 300,
		y: 300
	}; // instead of 0 to avoid scrolling on startup

	this.scrollable = false;
	this.tooltipElement = [];

	this._enableMapMovement = true;
}

Game.prototype.getCurrentInterior = function() {
	if (this.currentInterior !== -1)
		return this.interiors[this.currentInterior];
	else
		return null;
}

Game.prototype.getInterior = function(name) {
	return this.interiors[name];
}

Game.prototype.refreshScene = function() {
	stage.update();

	// HACK: wnętrze komputera po pobraniu widoku nie odswieza się dopoki nie
	// ruszy się myszką. Wysłanie zdarzenia powoduje przerysowanie sceny
	// Trzeba to zrobić jakos lepiej
	e = $.Event('mousemove');
	e.pageX = this.mousePos.x;
	e.pageY = this.mousePos.y;
	$(document).trigger(e);
}

Game.prototype.debugEnableAllBuildings = function(enable) {
	var e = typeof enable !== 'undefined' ? !enable : false;
	for (var i in this.map.buildings)
		this.map.buildings[i].setDisabled(e); // false
}

Game.prototype.enableAllowedBuildings = function() {
	if (window.userdata && window.userdata.allowedInteriors) {
		for (var bId in this.map.buildings) {
			var building = this.map.buildings[bId];
			if (window.userdata.allowedInteriors[bId] !== undefined)
				building.setDisabled(false);
			else if (building.interiorGroup)
				building.setDisabled(window.userdata.allowedInteriors[building.interiorGroup] === undefined);
			else {
				var budDat = building.getBuildingData();
				if (budDat && budDat.rodzajBudynku)
					building.setDisabled(window.userdata.allowedInteriors[budDat.rodzajBudynku] === undefined);
				else
					building.setDisabled(true);
			}
		}
	}
}

Game.prototype.init = function(canvasElementId) {
	if (this.stage === null) {
		// basic settings
		$("#loader").fadeIn(1000);

		this.stage = new createjs.Stage(canvasElementId);
		this.stage.enableMouseOver(5); //10);
		this.stage.mouseMoveOutside = true;
		this.canvas = this.stage.canvas;
		createjs.Touch.enable(this.stage);

		// preloader
		this.manifest = [
			// brakujace obrazki
			{
				src: window.links.baseUrl + "/images/chrome_logo.png"
			}, {
				src: window.links.baseUrl + "/images/favicon.ico"
			}, {
				src: window.links.baseUrl + "/images/green-check-green.png"
			}, {
				src: window.links.baseUrl + "/images/ajax-loader.gif"
			}, {
				src: window.links.baseUrl + "/images/loader.gif"
			},

			// avatary pracownikow
			{
				src: window.links.baseUrl + "/images/avatars/biologia/4.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/1.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/2.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/3.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/4.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/5.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/6.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/7.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/8.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/9.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/2.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/3.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/5.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/6.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/7.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/8.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/9.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/12.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/16.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/21.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/fizyka/5.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/fizyka/6.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/fizyka/7.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/fizyka/8.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/fizyka/9.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/1.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/2.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/3.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/4.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/5.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/6.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/7.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/8.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/9.png"
			},

			// stopka
			{
				src: window.links.baseUrl + "/images/footer/logo1.png"
			}, {
				src: window.links.baseUrl + "/images/footer/logo3.png"
			}, {
				src: window.links.baseUrl + "/images/footer/logo4.png"
			}, {
				src: window.links.baseUrl + "/images/footer/logo5.png"
			}, {
				src: window.links.baseUrl + "/images/footer/logo-pokl.png"
			}, {
				src: window.links.baseUrl + "/images/footer/logo-ue.png"
			},

			// formularze

			{
				src: window.links.baseUrl + "/images/form-backgrounds/certificate/1.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form1/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form1/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form1/003.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form2/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form2/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form2/003.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form2/004.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form3/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form3/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form3/003.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form3/004.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form3/005.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form3/006.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form4/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form4/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form4/003.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form4/004.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form5/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form5/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form6/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form7/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form7/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form8/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form8/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form8/003.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form9/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form9/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form10/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form10/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form11/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form11/002.jpg"
			},

			// maps
			{
				src: window.links.baseUrl + "/images/maps/city1.jpg",
				id: "cityImg"
			},

			// cars
			{
				src: window.links.baseUrl + "/images/cars/trolejbus.png",
				id: "trolejbus"
			}, {
				src: window.links.baseUrl + "/images/cars/chevrolet.png",
				id: "chevrolet"
			}, {
				src: window.links.baseUrl + "/images/cars/chevrolet2.png",
				id: "chevrolet2"
			}, {
				src: window.links.baseUrl + "/images/cars/chevrolet3.png",
				id: "chevrolet3"
			}, {
				src: window.links.baseUrl + "/images/cars/chevrolet4.png",
				id: "chevrolet4"
			}, {
				src: window.links.baseUrl + "/images/cars/porsche.png",
				id: "porsche"
			}, {
				src: window.links.baseUrl + "/images/cars/porsche2.png",
				id: "porsche2"
			}, {
				src: window.links.baseUrl + "/images/cars/porsche3.png",
				id: "porsche3"
			}, {
				src: window.links.baseUrl + "/images/cars/porsche4.png",
				id: "porsche4"
			}, {
				src: window.links.baseUrl + "/images/cars/smart.png",
				id: "smart"
			}, {
				src: window.links.baseUrl + "/images/cars/smart2.png",
				id: "smart2"
			}, {
				src: window.links.baseUrl + "/images/cars/smart3.png",
				id: "smart3"
			}, {
				src: window.links.baseUrl + "/images/cars/smart4.png",
				id: "smart4"
			}, {
				src: window.links.baseUrl + "/images/cars/star.png",
				id: "star"
			}, {
				src: window.links.baseUrl + "/images/cars/star2.png",
				id: "star2"
			}, {
				src: window.links.baseUrl + "/images/cars/star3.png",
				id: "star3"
			}, {
				src: window.links.baseUrl + "/images/cars/star4.png",
				id: "star4"
			},

			// humans
			{
				src: window.links.baseUrl + "/images/cars/pedestrian.png",
				id: "pedestrian1"
			}, {
				src: window.links.baseUrl + "/images/cars/pedestrian2.png",
				id: "pedestrian2"
			}, {
				src: window.links.baseUrl + "/images/cars/pedestrian3.png",
				id: "pedestrian3"
			}, {
				src: window.links.baseUrl + "/images/cars/pedestrian4.png",
				id: "pedestrian4"
			}, {
				src: window.links.baseUrl + "/images/cars/pedestrian5.png",
				id: "pedestrian5"
			}, {
				src: window.links.baseUrl + "/images/cars/pedestrian6.png",
				id: "pedestrian6"
			},

			// other moving sprites
			{
				src: window.links.baseUrl + "/images/cars/chmura1.png",
				id: "chmura1"
			}, {
				src: window.links.baseUrl + "/images/cars/chmura2.png",
				id: "chmura2"
			}, {
				src: window.links.baseUrl + "/images/cars/chmura3.png",
				id: "chmura3"
			}, {
				src: window.links.baseUrl + "/images/cars/chmura4.png",
				id: "chmura4"
			}, {
				src: window.links.baseUrl + "/images/cars/samolot.png",
				id: "samolot"
			}, {
				src: window.links.baseUrl + "/images/cars/lodka.png",
				id: "lodka"
			},

			// buildings ----------
			// -- agencje reklamowe
			{
				src: window.links.baseUrl + "/images/buildings/agencjeReklamowe/agencjaReklamowa1.png",
				id: "agencjaReklamowa1"
			}, {
				src: window.links.baseUrl + "/images/buildings/agencjeReklamowe/agencjaReklamowa2.png",
				id: "agencjaReklamowa2"
			}, {
				src: window.links.baseUrl + "/images/buildings/agencjeReklamowe/agencjaReklamowa3.png",
				id: "agencjaReklamowa3"
			},
			// -- banki
			{
				src: window.links.baseUrl + "/images/buildings/banki/bank1.png",
				id: "bank1"
			}, {
				src: window.links.baseUrl + "/images/buildings/banki/bank2.png",
				id: "bank2"
			}, {
				src: window.links.baseUrl + "/images/buildings/banki/bank3.png",
				id: "bank3"
			}, {
				src: window.links.baseUrl + "/images/buildings/banki/bank4.png",
				id: "bank4"
			},
			// -- centra szkoleniwe
			{
				src: window.links.baseUrl + "/images/buildings/centraSzkoleniowe/centrumSzkoleniowe1.png",
				id: "centrumSzkoleniowe1"
			}, {
				src: window.links.baseUrl + "/images/buildings/centraSzkoleniowe/centrumSzkoleniowe2.png",
				id: "centrumSzkoleniowe2"
			}, {
				src: window.links.baseUrl + "/images/buildings/centraSzkoleniowe/centrumSzkoleniowe3.png",
				id: "centrumSzkoleniowe3"
			}, {
				src: window.links.baseUrl + "/images/buildings/centraSzkoleniowe/centrumSzkoleniowe4.png",
				id: "centrumSzkoleniowe4"
			},
			// -- urzedy skarbowe
			{
				src: window.links.baseUrl + "/images/buildings/urzedySkarbowe/urzadSkarbowy1.png",
				id: "urzadSkarbowy1"
			}, {
				src: window.links.baseUrl + "/images/buildings/urzedySkarbowe/urzadSkarbowy2.png",
				id: "urzadSkarbowy2"
			}, {
				src: window.links.baseUrl + "/images/buildings/urzedySkarbowe/urzadSkarbowy3.png",
				id: "urzadSkarbowy3"
			},
			// -- pozostale urzedy
			{
				src: window.links.baseUrl + "/images/buildings/agencjaPosrednictwaPracy.png",
				id: "agencjaPosrednictwaPracy"
			}, {
				src: window.links.baseUrl + "/images/buildings/urzadMiasta.png",
				id: "urzadMiasta"
			}, {
				src: window.links.baseUrl + "/images/buildings/urzadPracy.png",
				id: "urzadPracy"
			}, {
				src: window.links.baseUrl + "/images/buildings/urzadStatystyczny.png",
				id: "urzadStatystyczny"
			}, {
				src: window.links.baseUrl + "/images/buildings/zus.png",
				id: "zus"
			},

			// -- statyczne budynki
			{
				src: window.links.baseUrl + "/images/buildings/statyczne/most.png",
				id: "most"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/zaing.png",
				id: "zaing"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/zamek.png",
				id: "zamek"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/domek1.png",
				id: "domek1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/domek2.png",
				id: "domek2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/domek3.png",
				id: "domek3"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/hangar.png",
				id: "hangar"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/kosciol1.png",
				id: "kosciol1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/kosciol2.png",
				id: "kosciol2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/skala-down.png",
				id: "skala-down"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/skala-down-left.png",
				id: "skala-down-left"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/skala-right.png",
				id: "skala-right"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/skala-up.png",
				id: "skala-up"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/politechnika1.png",
				id: "politechnika1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/politechnika2.png",
				id: "politechnika2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/lotnisko.png",
				id: "lotnisko"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drogowskaz.png",
				id: "drogowskaz"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/latarnia_left.png",
				id: "latarniaL"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/latarnia_right.png",
				id: "latarniaR"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pn-mid.png",
				id: "drzewka-pn-mid"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pn.png",
				id: "drzewka-pn"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pn-wsch-1.png",
				id: "drzewka-pn-wsch-1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pn-wsch-2.png",
				id: "drzewka-pn-wsch-2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pn-wsch-3.png",
				id: "drzewka-pn-wsch-3"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pn-wsch-4.png",
				id: "drzewka-pn-wsch-4"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pn-zach.png",
				id: "drzewka-pn-zach"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-podsaskim.png",
				id: "drzewka-podsaskim"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-saski1.png",
				id: "drzewka-saski1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-saski2.png",
				id: "drzewka-saski2"
			},

			{
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zus.png",
				id: "drzewka-zus"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach.png",
				id: "drzewka-zach"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach2.png",
				id: "drzewka-zach2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach3.png",
				id: "drzewka-zach3"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach4.png",
				id: "drzewka-zach4"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach5.png",
				id: "drzewka-zach5"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach6.png",
				id: "drzewka-zach6"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach7.png",
				id: "drzewka-zach7"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach-mid1.png",
				id: "drzewka-zach-mid1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach-mid2.png",
				id: "drzewka-zach-mid2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach-mid3.png",
				id: "drzewka-zach-mid3"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-center1.png",
				id: "drzewka-center1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-center2.png",
				id: "drzewka-center2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-most1.png",
				id: "drzewka-most1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-most2.png",
				id: "drzewka-most2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-most3.png",
				id: "drzewka-most3"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-most4.png",
				id: "drzewka-most4"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-most5.png",
				id: "drzewka-most5"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-side-autostrada.png",
				id: "drzewka-side-autostrada"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-autostrada1.png",
				id: "drzewka-autostrada1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-autostrada2.png",
				id: "drzewka-autostrada2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-autostrada3.png",
				id: "drzewka-autostrada3"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-autostrada4.png",
				id: "drzewka-autostrada4"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-autostrada5.png",
				id: "drzewka-autostrada5"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-autostrada6.png",
				id: "drzewka-autostrada6"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-autostrada7.png",
				id: "drzewka-autostrada7"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd1.png",
				id: "drzewka-pd1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd2.png",
				id: "drzewka-pd2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd3.png",
				id: "drzewka-pd3"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd4.png",
				id: "drzewka-pd4"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd5.png",
				id: "drzewka-pd5"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd6.png",
				id: "drzewka-pd6"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd7.png",
				id: "drzewka-pd7"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd8.png",
				id: "drzewka-pd8"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd9.png",
				id: "drzewka-pd9"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd10.png",
				id: "drzewka-pd10"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd11.png",
				id: "drzewka-pd11"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd12.png",
				id: "drzewka-pd12"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd13.png",
				id: "drzewka-pd13"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd14.png",
				id: "drzewka-pd14"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-ing.png",
				id: "drzewka-ing"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/przystanek.png",
				id: "przystanek"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/kosz.png",
				id: "kosz"
			},

			// -- biura
			{
				src: window.links.baseUrl + "/images/buildings/biura/biuro1.png",
				id: "biuro1"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro2.png",
				id: "biuro2"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro3.png",
				id: "biuro3"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro4.png",
				id: "biuro4"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro5.png",
				id: "biuro5"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro6.png",
				id: "biuro6"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro7.png",
				id: "biuro7"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro8.png",
				id: "biuro8"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro9.png",
				id: "biuro9"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro10.png",
				id: "biuro10"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro11.png",
				id: "biuro11"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro12.png",
				id: "biuro12"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro13.png",
				id: "biuro13"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro14.png",
				id: "biuro14"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro15.png",
				id: "biuro15"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro15b.png",
				id: "biuro15b"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro16.png",
				id: "biuro16"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro17.png",
				id: "biuro17"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro18.png",
				id: "biuro18"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro19.png",
				id: "biuro19"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro20.png",
				id: "biuro20"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro21.png",
				id: "biuro21"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro22.png",
				id: "biuro22"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro23.png",
				id: "biuro23"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro24.png",
				id: "biuro24"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro25.png",
				id: "biuro25"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro26.png",
				id: "biuro26"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro27.png",
				id: "biuro27"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro28.png",
				id: "biuro28"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro28b.png",
				id: "biuro28b"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro29.png",
				id: "biuro29"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro30.png",
				id: "biuro30"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro31.png",
				id: "biuro31"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro32.png",
				id: "biuro32"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro33.png",
				id: "biuro33"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro34.png",
				id: "biuro34"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro35.png",
				id: "biuro35"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro36.png",
				id: "biuro36"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro37.png",
				id: "biuro37"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro38.png",
				id: "biuro38"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro39.png",
				id: "biuro39"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro40.png",
				id: "biuro40"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro41.png",
				id: "biuro41"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro42.png",
				id: "biuro42"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro43.png",
				id: "biuro43"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro44.png",
				id: "biuro44"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro45.png",
				id: "biuro45"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro46.png",
				id: "biuro46"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro47.png",
				id: "biuro47"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro48.png",
				id: "biuro48"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro49.png",
				id: "biuro49"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro50.png",
				id: "biuro50"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro51.png",
				id: "biuro51"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro52.png",
				id: "biuro52"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro53.png",
				id: "biuro53"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro54.png",
				id: "biuro54"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro55.png",
				id: "biuro55"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro56.png",
				id: "biuro56"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro57.png",
				id: "biuro57"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro58.png",
				id: "biuro58"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro59.png",
				id: "biuro59"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro60.png",
				id: "biuro60"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/elpro.png",
				id: "biuroElpro"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/pyramid.png",
				id: "biuroPyramid"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/metropolian.png",
				id: "metropolian"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/ing.png",
				id: "ing"
			},

			// interiors ----------
			// -- agencje reklamowe
			{
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/agencjaReklamowa1.jpg",
				id: "intAR1"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/agencjaReklamowa1_rozmowa.jpg",
				id: "intAR1r"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/agencjaReklamowa2.jpg",
				id: "intAR2"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/agencjaReklamowa2_rozmowa.jpg",
				id: "intAR2r"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/agencjaReklamowa3.jpg",
				id: "intAR3"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/agencjaReklamowa3_rozmowa.jpg",
				id: "intAR3r"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/active/ar1a.png",
				id: "ar1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/active/ar2a.png",
				id: "ar2aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/active/ar3a.png",
				id: "ar3aImg"
			},
			// -- banki
			{
				src: window.links.baseUrl + "/images/interiors/banki/bank1.jpg",
				id: "intBank1"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank1_rozmowa1.jpg",
				id: "intBank1r1"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank1_rozmowa2.jpg",
				id: "intBank1r2"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank2.jpg",
				id: "intBank2"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank2_rozmowa1.jpg",
				id: "intBank2r1"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank2_rozmowa2.jpg",
				id: "intBank2r2"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank3.jpg",
				id: "intBank3"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank3_rozmowa1.jpg",
				id: "intBank3r1"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank3_rozmowa2.jpg",
				id: "intBank3r2"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank4.jpg",
				id: "intBank4"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank4_2.jpg",
				id: "intBank4_2"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank4_rozmowa1.jpg",
				id: "intBank4r1"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank4_rozmowa2.jpg",
				id: "intBank4r2"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b1a.png",
				id: "b1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b4a.png",
				id: "b4aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b2r1a.png",
				id: "b2r1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b2r2a.png",
				id: "b2r2aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b3r1a.png",
				id: "b3r1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b3r2a.png",
				id: "b3r2aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b4r1a.png",
				id: "b4r1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b4r2a.png",
				id: "b4r2aImg"
			},

			// -- centra szkoleniowe
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe1.jpg",
				id: "intCS1"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe1_biurko.jpg",
				id: "intCS1b"
			},
			//{src: window.links.baseUrl+"/images/interiors/centraSzkoleniowe/centrumSzkoleniowe1_egzamin.jpg", id:"intCS1e"},
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe1_szkoleniowa.jpg",
				id: "intCS1e"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe1_rozmowa.jpg",
				id: "intCS1r"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe1_tablica.jpg",
				id: "intCS1s"
			}, //szkolenie
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe2.jpg",
				id: "intCS2"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe2_biurko.jpg",
				id: "intCS2b"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe2_szkoleniowa.jpg",
				id: "intCS2e"
			}, // egzamin.jpg , szkoleniowa.jpg
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe2_tablica.jpg",
				id: "intCS2s"
			}, //szkolenie
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe3.jpg",
				id: "intCS3"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe3_biurko.jpg",
				id: "intCS3b"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe3_szkolenie.jpg",
				id: "intCS3e"
			}, // egzamin
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe3_rozmowa.jpg",
				id: "intCS3r"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe3_biurko.jpg",
				id: "intCS3s"
			}, //szkolenie
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe4.jpg",
				id: "intCS4"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe4_biurko.jpg",
				id: "intCS4b"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe4_egzamin.jpg",
				id: "intCS4e"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe4_rozmowa.jpg",
				id: "intCS4r"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe4_tablica.jpg",
				id: "intCS4s"
			}, //szkolenie
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/active/cs1a.png",
				id: "cs1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/active/cs3a.png",
				id: "cs3aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/active/cs4a.png",
				id: "cs4aImg"
			},
			// -- urzedy skarbowe
			{
				src: window.links.baseUrl + "/images/interiors/urzedySkarbowe/urzadSkarbowy.jpg",
				id: "intUS"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzedySkarbowe/urzadSkarbowy_rozmowa1.jpg",
				id: "intUSr1"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzedySkarbowe/urzadSkarbowy_rozmowa2.jpg",
				id: "intUSr2"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzedySkarbowe/urzadSkarbowy_stolik.jpg",
				id: "intUSs"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzedySkarbowe/active/usr1a.png",
				id: "usr1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzedySkarbowe/active/usr2a.png",
				id: "usr2aImg"
			},
			// -- urzad pracy
			{
				src: window.links.baseUrl + "/images/interiors/urzadPracy/urzadPracy.jpg",
				id: "intUP"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/urzadPracy_rozmowa1.jpg",
				id: "intUPr1"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/urzadPracy_rozmowa2.jpg",
				id: "intUPr2"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/urzadPracy_stolik.jpg",
				id: "intUPs"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/urzadPracy_terminal.jpg",
				id: "intUPt"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/active/upta.png",
				id: "uptaImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/active/upn1a.png",
				id: "upn1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/active/upn2a.png",
				id: "upn2aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/active/uptp1a.png",
				id: "uptp1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/active/uptp2a.png",
				id: "uptp2aImg"
			},
			// -- agencja posrednictwa pracy
			{
				src: window.links.baseUrl + "/images/interiors/agencjaPP/agencjaPP.jpg",
				id: "intAPP"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjaPP/agencjaPP_rozmowa1.jpg",
				id: "intAPPr1"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjaPP/agencjaPP_rozmowa2.jpg",
				id: "intAPPr2"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjaPP/active/appr1a.png",
				id: "appr1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjaPP/active/appr2a.png",
				id: "appr2aImg"
			},
			// -- zus
			{
				src: window.links.baseUrl + "/images/interiors/zus/zus.jpg",
				id: "intZ"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/zus_rozmowa1.jpg",
				id: "intZr1"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/zus_rozmowa2.jpg",
				id: "intZr2"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/zus_stolik.jpg",
				id: "intZs"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/zus_terminal.jpg",
				id: "intZt"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/active/zustp1a.png",
				id: "zustp1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/active/zustp2a.png",
				id: "zustp2aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/active/zusta.png",
				id: "zustaImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/active/zusn1a.png",
				id: "zusn1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/active/zusn2a.png",
				id: "zusn2aImg"
			},
			// -- biura
			{
				src: window.links.baseUrl + "/images/interiors/biura/treeSprite.png",
				id: "treeSprite"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/biuro.png",
				id: "biuroGracza"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/biuroTlo.jpg",
				id: "biuroTlo"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/biuroZlecenia1.jpg",
				id: "biuroZlecenia1"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/biuroZlecenia1_rozmowa.jpg",
				id: "biuroZlecenia1r"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/biuroZlecenia2.jpg",
				id: "biuroZlecenia2"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/biuroZlecenia2_rozmowa.jpg",
				id: "biuroZlecenia2r"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/komputer.png",
				id: "komputerSprite"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/komputerScreen.jpg",
				id: "komputerScreen"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/active/bz1ra.png",
				id: "bz1raImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/active/bz2ra.png",
				id: "bz2raImg"
			},

			{
				src: window.links.baseUrl + "/images/interiors/biura/browser_close.jpg"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/browser_close_hover.jpg"
			},
			// -- pozostale wnetrza
			{
				src: window.links.baseUrl + "/images/interiors/biurko.jpg",
				id: "biurko"
			}, {
				src: window.links.baseUrl + "/images/interiors/komputer.jpg",
				id: "komputer"
			}, {
				src: window.links.baseUrl + "/images/interiors/terminal.jpg",
				id: "terminal"
			},
			// elementy wnetrz
			{
				src: window.links.baseUrl + "/images/interiors/blank.png",
				id: "blankImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/strzalka.png",
				id: "strzalkaImg"
			},

			// also preload some gui elements
			{
				src: window.links.baseUrl + "/images/gui/symbol-punkty.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-bank.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-biuro.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-finanse.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-firma.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-hide-minimap.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-info.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-komputer.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-kontrahenci.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-marketing.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-pliki.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-pracownicy.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-punkty.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-show-minimap.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-skrzynka.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-stat.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-statystyki.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-szkolenia.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-ue.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-urzadpracy.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-urzadskarbowy.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-wyjscie.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-zlecenia.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-zus.png"
			}, {
				src: window.links.baseUrl + "/images/gui/update.png"
			}, {
				src: window.links.baseUrl + "/images/maps/minimap1.jpg"
			}, {
				src: window.links.baseUrl + "/images/gui/biologia.png"
			}, {
				src: window.links.baseUrl + "/images/gui/biologia_small.png"
			}, {
				src: window.links.baseUrl + "/images/gui/biologia_small_grey.png"
			}, {
				src: window.links.baseUrl + "/images/gui/chemia.png"
			}, {
				src: window.links.baseUrl + "/images/gui/chemia_small.png"
			}, {
				src: window.links.baseUrl + "/images/gui/chemia_small_grey.png"
			}, {
				src: window.links.baseUrl + "/images/gui/matematyka.png"
			}, {
				src: window.links.baseUrl + "/images/gui/matematyka_small.png"
			}, {
				src: window.links.baseUrl + "/images/gui/matematyka_small_grey.png"
			}, {
				src: window.links.baseUrl + "/images/gui/fizyka.png"
			}, {
				src: window.links.baseUrl + "/images/gui/fizyka_small.png"
			}, {
				src: window.links.baseUrl + "/images/gui/fizyka_small_grey.png"
			}, {
				src: window.links.baseUrl + "/images/gui/bottom_bar.png"
			}, {
				src: window.links.baseUrl + "/images/gui/info_bar.png"
			}, {
				src: window.links.baseUrl + "/images/gui/button_bg.png"
			}, {
				src: window.links.baseUrl + "/images/gui/clock_bar.png"
			}, {
				src: window.links.baseUrl + "/images/gui/empty-avatar.png"
			}, {
				src: window.links.baseUrl + "/images/gui/fire-button.png"
			}, {
				src: window.links.baseUrl + "/images/gui/info-icon.png"
			}, {
				src: window.links.baseUrl + "/images/gui/info-icon-sm.png"
			}, {
				src: window.links.baseUrl + "/images/gui/lesson_bar.png"
			}, {
				src: window.links.baseUrl + "/images/gui/loadingbar.png"
			}, {
				src: window.links.baseUrl + "/images/gui/loading.png"
			}, {
				src: window.links.baseUrl + "/images/gui/loading_bg.jpg"
			}, {
				src: window.links.baseUrl + "/images/gui/logo.png"
			}, {
				src: window.links.baseUrl + "/images/gui/logo-tlo.png"
			}, {
				src: window.links.baseUrl + "/images/gui/money-icon.png"
			}, {
				src: window.links.baseUrl + "/images/gui/panel-gorny.png"
			}, {
				src: window.links.baseUrl + "/images/gui/pasek.png"
			}, {
				src: window.links.baseUrl + "/images/gui/pointer.png"
			}, {
				src: window.links.baseUrl + "/images/gui/przycisk.png"
			}, {
				src: window.links.baseUrl + "/images/gui/sidebar_bg.png"
			}, {
				src: window.links.baseUrl + "/images/gui/sidebar_header.png"
			}, {
				src: window.links.baseUrl + "/images/gui/sidebar_hider.png"
			}, {
				src: window.links.baseUrl + "/images/gui/sidebar_leftborder.png"
			}, {
				src: window.links.baseUrl + "/images/gui/sidebar-expanded.png"
			}, {
				src: window.links.baseUrl + "/images/gui/sidebar-zwiniety.png"
			},

			// loga
			{
				src: window.links.baseUrl + "/images/loga/loga_agencjeReklamowe/agencjaReklamowa1.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_agencjeReklamowe/agencjaReklamowa2.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_agencjeReklamowe/agencjaReklamowa3.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_banki/bank1.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_banki/bank2.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_banki/bank3.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_banki/bank4.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_centraSzkoleniowe/centrumSzkoleniowe1.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_centraSzkoleniowe/centrumSzkoleniowe2.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_centraSzkoleniowe/centrumSzkoleniowe3.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_centraSzkoleniowe/centrumSzkoleniowe4.png"
			},

			// loga do kupienia
			{
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo1.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo2.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo3.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo4.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo5.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo6.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo7.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo8.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo9.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo10.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo1.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo2.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo3.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo4.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo5.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo6.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo7.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo8.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo9.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo10.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo1.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo2.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo3.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo4.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo5.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo6.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo7.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo8.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo9.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo10.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo1.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo2.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo3.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo4.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo5.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo6.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo7.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo8.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo9.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo10.png"
			},

			// other gui icons
			{
				src: window.links.baseUrl + "/images/gui/refresh.png"
			}, {
				src: window.links.baseUrl + "/images/gui/flag_en.gif"
			}, {
				src: window.links.baseUrl + "/images/gui/flag_pl.gif"
			}
		];

		this.preloader = new createjs.LoadQueue();

		// registering events
		var gameObject = this;
		var tickHandler = this.tick;
		var resizeHandler = this.resize;
		var keyboardHandler = this.keyboard;
		var progressHandler = this.loadProgress;
		var loadHandler = this.loadComplete;
		var hashHandler = this.parseUrl;
		createjs.Ticker.addEventListener("tick", function(event) {
			tickHandler.call(gameObject, event);
		});
		// createjs.Ticker.setFPS(20); // default is 20
		window.addEventListener("resize", function(event) {
			resizeHandler.call(gameObject, event);
		}, false);

		var pre = this.preloader;

		pre.addEventListener("progress", function(event) {
			progressHandler.call(gameObject, event);
		});
		pre.addEventListener("complete", function(event) {
			loadHandler.call(gameObject, event);
		});
		// pre.addEventListener("error", function(event)    { pre.loadFile({ src: event.item.src, id: event.item.id }); });

		document.addEventListener("keydown", function(event) {
			keyboardHandler.call(gameObject, event);
		});
		this.canvas.addEventListener("mousemove", function(event) {
			gameObject.mouseOldPos = {
				x: gameObject.mousePos.x,
				y: gameObject.mousePos.y
			};
			gameObject.mousePos = {
				x: event.pageX,
				y: event.pageY
			};
		});
		document.addEventListener("mouseout", function(event) {
			gameObject.mousePos = {
				x: 300,
				y: 300
			};
			gameObject.mouseOldPos = {
				x: 300,
				y: 300
			};
		});
		window.addEventListener("hashchange", function() {
			hashHandler.call(gameObject);
		});

		// create tooltip DOM element on canvas to capture clicks
		//var tooltip = document.getElementById("gameTooltip");
		//this.tooltipElement = new createjs.DOMElement(tooltip);
		var tooltip = this.tooltipElement;
		$(".gameTooltip").each(function() {
			var element = new createjs.DOMElement(this);
			tooltip.push(element);
		});

		// final setup
		this.resize();
		window.stage = this.stage;

		// load all assets
		this.preloader.loadManifest(this.manifest);

		//add global focus events to block map movements
		var thisGame = this;
		jQuery(document).on('focusin', function() {
			thisGame._enableMapMovement = false;
		});
		jQuery(document).on('focusout', function() {
			thisGame._enableMapMovement = true;
		});
	}
};

Game.prototype.resize = function() {
	var context = this.canvas.getContext("2d");
	var screenImage = context.getImageData(0, 0, this.canvas.width, this.canvas.height);

	this.canvas.width = window.innerWidth;
	this.canvas.height = window.innerHeight; //-70;

	this.scaleInterior();
	if (this.currentInterior != -1) {
		this.interiors[this.currentInterior].container.x = 0;
		this.interiors[this.currentInterior].container.y = 0;
	}

	context.putImageData(screenImage, 0, 0);
};

Game.prototype.tick = function(event) {
	if (this.map)
		this.map.traffic.handleTraffic();
	this.scrollTick();

	this.stage.update(event);
};

Game.prototype.scrollTick = function() {
	// smooth scrolling of containers
	if (this.scrollable == true && this.container != null && this.map != null && this.mousePos != this.mouseOldPos) {
		var c = this.container;
		var i, w, h;
		if (this.currentInterior == -1) {
			i = this.map.getImage();
			w = i.width - this.canvas.width;
			h = i.height - this.canvas.height;
		} else {
			i = this.interiors[this.currentInterior].image;
			s = this.getScaleInterior();
			w = (i.width * s) - this.canvas.width;
			h = (i.height * s) - this.canvas.height;
		}

		var mp = this.mousePos;
		var distanceFromBorder = 200;
		var maxScrollingSpeed = 30;

		if (mp.x < distanceFromBorder) {
			var change = 100 / mp.x;
			if (change > maxScrollingSpeed || change <= 0) change = maxScrollingSpeed;
			c.x += change;
			if (c.x > 0) c.x = 0;
		}
		if (this.currentInterior == -1 && mp.y - 27 < distanceFromBorder) // -27 is header size
		{
			var change = 100 / (mp.y - 27);
			if (change > maxScrollingSpeed || change <= 0) change = maxScrollingSpeed;
			c.y += change;
			if (c.y > 0) c.y = 0;
		}
		if (mp.x > this.canvas.width - distanceFromBorder) {
			var change = 100 / (this.canvas.width - mp.x);
			if (change > maxScrollingSpeed || change <= 0) change = maxScrollingSpeed;
			c.x -= change;
			if (c.x < -w) c.x = -w;
		}
		if (this.currentInterior == -1 && mp.y > this.canvas.height - distanceFromBorder) {
			var change = 100 / (this.canvas.height - mp.y);
			if (change > maxScrollingSpeed || change <= 0) change = maxScrollingSpeed;
			c.y -= change;
			if (c.y < -h) c.y = -h;
		}
		if (this.currentInterior == -1) this.updateMinimap();
	}
};

Game.prototype.loadProgress = function(event) {
	var size = this.preloader.progress * 620;
	$("#loadingbar").css("width", this.preloader.progress * 620 + "px");
}

Game.prototype.loadComplete = function(event) {
	var gameObject = this;
	var interior;
	var resname;
	var res;

	// create map
	this.map = new Map(gameObject);
	var image = this.preloader.getResult("cityImg");
	this.map.init(image);

	// humans, pedestrians
	resname = "pedestrian1";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian2";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian3";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian4";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian5";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian6";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);

	resname = "pedestrian1";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian1";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian2";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian3";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian4";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian5";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian6";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);

	resname = "pedestrian1";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian2";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian3";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian4";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian5";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian6";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian1";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian2";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian3";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian4";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian5";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian6";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian6";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	/*
		resname = "pedestrian1"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian2"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian3"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian4"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian5"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian6"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian1"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian2"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian3"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian4"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
	*/
	// add cars
	var rc = this.map.traffic.roadCount;
	var carnum = 17;

	for (i = 0; i < this.map.traffic.roads.length; i++) {
		if (i % carnum == 0) {
			resname = "trolejbus";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 61, 57);
		}
		if (i % carnum == 1) {
			resname = "trolejbus";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 61, 57);
		}
		if (i % carnum == 2) {
			resname = "trolejbus";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 61, 57);
		}
		if (i % carnum == 3) {
			resname = "trolejbus";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 61, 57);
		}
		if (i % carnum == 4) {
			resname = "chevrolet";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 38, 26);
		}
		if (i % carnum == 5) {
			resname = "chevrolet2";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 38, 26);
		}
		if (i % carnum == 6) {
			resname = "chevrolet3";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 38, 26);
		}
		if (i % carnum == 7) {
			resname = "chevrolet4";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 38, 26);
		}
		if (i % carnum == 8) {
			resname = "porsche";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 37, 29);
		}
		if (i % carnum == 9) {
			resname = "porsche2";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 37, 29);
		}
		if (i % carnum == 10) {
			resname = "porsche3";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 37, 29);
		}
		if (i % carnum == 11) {
			resname = "porsche4";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 37, 29);
		}
		if (i % carnum == 12) {
			resname = "smart";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 23, 23);
		}
		if (i % carnum == 13) {
			resname = "smart2";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 23, 23);
		}
		if (i % carnum == 14) {
			resname = "smart3";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 23, 23);
		}
		if (i % carnum == 15) {
			resname = "smart4";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 23, 23);
		}
		if (i % carnum == 16) {
			resname = "star";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 45, 37);
		}
		if (i % carnum == 17) {
			resname = "star2";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 45, 37);
		}
		if (i % carnum == 18) {
			resname = "star3";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 45, 37);
		}
		if (i % carnum == 19) {
			resname = "star4";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 45, 37);
		}
	}

	this.map.traffic.showLines();

	resname = "lodka";
	res = this.preloader.getResult(resname);
	this.map.addCloud(resname, res, 34, 50, 100); // 42 52 // it's a boat actually, just pretending to be a cloud
	resname = "lodka";
	res = this.preloader.getResult(resname);
	this.map.addCloud(resname + "-2", res, 34, 50, 100);
	resname = "samolot";
	res = this.preloader.getResult(resname);
	this.map.addCloud(resname, res, 100, 70, 10); // it's a plane actually, just pretending to be a cloud

	// latarnie polnocny-zachod
	resname = "latarniaL";
	res = this.preloader.getResult(resname);
	for (i = 0; i < 11; i++)
		this.map.addBuilding(resname, res, -42 + (i * 73), 995 - (i * 42), false);
	for (i = 11; i < 23; i++)
		this.map.addBuilding(resname, res, -70 + (i * 73), 1011 - (i * 42), false);

	// latarnie poludnie
	for (i = 0; i < 17; i++)
		this.map.addBuilding(resname, res, 1337 + (i * 73), 2061 - (i * 42), false);
	for (i = 17; i < 28; i++)
		this.map.addBuilding(resname, res, 1345 + (i * 73), 2053 - (i * 42), false);
	for (i = 28; i < 36; i++)
		this.map.addBuilding(resname, res, 1400 + (i * 73), 2010 - (i * 42), false);

	// latarnie wschod
	resname = "latarniaR";
	res = this.preloader.getResult(resname);
	for (i = 0; i < 10; i++)
		this.map.addBuilding(resname, res, 1794 + (i * 73), -45 + (i * 42), false);
	for (i = 10; i < 14; i++)
		this.map.addBuilding(resname, res, 1850 + (i * 73), -12 + (i * 42), false);
	for (i = 14; i < 20; i++)
		this.map.addBuilding(resname, res, 1908 + (i * 73), 22 + (i * 42), false);
	for (i = 20; i < 27; i++)
		this.map.addBuilding(resname, res, 2000 + (i * 73), 78 + (i * 42), false);

	// biura przed aktywnymi budynkami
	resname = "biuro33";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 932, 780);
	resname = "biuro34";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1170, 890);

	// static before buildings
	resname = "drzewka-zach";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 0, 1050, false);
	resname = "drzewka-zach2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 604, 1382, false);
	resname = "drzewka-zach3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 728, 1300, false);
	resname = "drzewka-zach4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 887, 1278, false);
	resname = "drzewka-zach5";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 967, 1333, false);
	resname = "drzewka-zach6";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1084, 1402, false);
	resname = "drzewka-zach7";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1149, 1433, false);
	resname = "drzewka-zach-mid1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 425, 846, false);
	resname = "drzewka-zach-mid2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 586, 742, false);
	resname = "drzewka-zach-mid3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 691, 662, false);
	resname = "drzewka-center1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1498, 1268, false);
	resname = "drzewka-center2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1616, 1188, false);
	resname = "drzewka-side-autostrada";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2497, 507, false);
	resname = "drzewka-most1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1925, 1056, false);
	resname = "drzewka-most2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2007, 1109, false);
	resname = "drzewka-most3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2056, 1123, false);
	resname = "drzewka-most4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2053, 1237, false);
	resname = "drzewka-most5";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2389, 1319, false);
	resname = "drzewka-autostrada1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2626, 529, false);
	resname = "drzewka-autostrada2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2780, 624, false);
	resname = "drzewka-autostrada3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3081, 791, false);
	resname = "drzewka-autostrada4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3217, 862, false);
	resname = "drzewka-autostrada5";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3538, 1060, false);
	resname = "drzewka-autostrada6";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2582, 1091, false);
	resname = "drzewka-autostrada7";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3690, 1155, false);
	resname = "drzewka-pd1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1542, 1066, false);
	resname = "drzewka-pd2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1671, 2019, false);
	resname = "drzewka-pd3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1767, 1959, false);
	resname = "drzewka-pd4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1911, 1813, false);
	resname = "drzewka-pd5";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2115, 1714, false);
	resname = "drzewka-pd6";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2259, 1621, false);
	resname = "drzewka-pd7";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2397, 1597, false);
	resname = "drzewka-pd8";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2457, 1538, false);
	resname = "drzewka-pd9";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2548, 1466, false);
	resname = "drzewka-pd10";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2711, 1417, false);
	resname = "drzewka-pd11";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2800, 1339, false);
	resname = "drzewka-pd12";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2953, 1210, false);
	resname = "drzewka-pd13";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3155, 1112, false);
	resname = "drzewka-pd14";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3295, 1019, false);
	resname = "drzewka-ing";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 649, 1123, false);
	resname = "drzewka-ing";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1488, 1205, false);

	// add active buildings
	resname = "agencjaReklamowa1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 625, 965);
	resname = "agencjaReklamowa2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1420, 390);
	resname = "agencjaReklamowa3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 500, 500);

	resname = "bank1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 848, 766); //2718,555); //1900,1400);
	resname = "bank2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2080, 710);
	resname = "bank3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2360, 368); //2075, 705);
	resname = "bank4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1525, 456); // 1540,435 1510, 450

	resname = "centrumSzkoleniowe1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1665, 789);
	resname = "centrumSzkoleniowe2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 333, 538);
	resname = "centrumSzkoleniowe3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2700, 1340); // 1790,1364  //2922,499);
	resname = "centrumSzkoleniowe4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2900, 495);

	resname = "urzadSkarbowy1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1883, 639);
	resname = "urzadSkarbowy2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2575, 262);
	resname = "urzadSkarbowy3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2027, 943);

	resname = "urzadStatystyczny";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2113, 291, true, true); // not clickable, only hover
	resname = "urzadPracy";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2535, 461);
	resname = "zus";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 979, 916);

	// static one
	resname = "zaing";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 689, 1054, false);

	// biura za aktywnymi
	resname = "metropolian";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 649, 1062);
	resname = "ing";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 895, 1085);

	resname = "biuro37";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 72, 477);
	resname = "biuro28b";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 176, 520);
	resname = "biuro5";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 510, 535); // 605 512
	resname = "biuro27";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 15, 610);
	resname = "biuro26";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 120, 695);
	resname = "biuro18";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 659, 651);
	resname = "biuro13";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 881, 659);
	resname = "biuro14";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 264, 952);
	resname = "biuro57";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 300, 994);
	resname = "biuro32";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 492, 1088);
	resname = "biuro44";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 598, 1139, false); // deactivated
	resname = "biuro23";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 175, 1047);
	resname = "biuro13";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 331, 1165);
	resname = "biuro11";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 484, 1146, false); // deactivated
	resname = "biuro22";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 408, 1184, false); // deactivated
	resname = "biuro20";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 309, 1268, false); // deactivated
	resname = "biuro18";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 376, 1344, false); // deactivated
	resname = "biuro10";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 547, 1225);

	resname = "biuro29";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1130, 1210);
	resname = "biuro28b";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 932, 1177);
	resname = "biuro28";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1030, 1206, false); // deactivated
	resname = "biuro28";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1128, 1270);
	resname = "biuro31";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1233, 1267, false); // deactivated
	resname = "biuro29";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1148, 1310);
	resname = "biuro28";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-3", res, 1211, 1319, false); // deactivated

	resname = "biuro42";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1390, 978);
	resname = "biuro28";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-4", res, 1317, 1003);
	resname = "biuro15b";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1142, 1034, false); // deactivated
	resname = "biuro58";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1382, 1022, false); // deactivated
	resname = "biuro15";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1450, 1048, false); // deactivated

	resname = "biuro21";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1320, 1094, false); // deactivated
	resname = "biuro12";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1383, 1199, false); // deactivated
	resname = "biuro51";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1126, 674);
	resname = "biuro46";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1138, 709);

	resname = "biuro10";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1059, 404);
	resname = "biuro16";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1230, 324);
	resname = "biuro14";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1340, 402);
	resname = "biuro20";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1222, 386);
	resname = "biuro25";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1346, 481);
	resname = "biuro24";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1271, 558, false); // deactivated

	resname = "biuro34";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1641, 564);
	resname = "biuro48";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1510, 698);
	resname = "biuro8";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1450, 708);
	resname = "biuro1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1390, 730);

	resname = "biuro7";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1525, 884);
	resname = "biuro2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1662, 975);
	resname = "biuro43";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1848, 1119);
	resname = "biuro48";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1888, 1067);

	resname = "biuro6";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1900, 868);
	resname = "biuro55";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2182, 895);
	resname = "biuro42";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2190, 980);
	resname = "biuro42";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-3", res, 2270, 866, false); // deactivated

	resname = "biuro54";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2872, 660);
	resname = "biuro51";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2955, 683);
	resname = "biuro50";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2809, 700);
	resname = "biuro52";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2742, 737);
	resname = "biuro50";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2675, 776);
	resname = "biuro53";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2638, 812);

	resname = "biuro1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2460, 550, false); // deactivated);

	resname = "biuro54";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2390, 531);
	resname = "biuro53";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2361, 567);
	resname = "biuro53";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-3", res, 2422, 600);

	resname = "kosciol2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2286, 550, false); // non active

	resname = "biuro51";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-3", res, 2268, 621, false); // deactivated
	resname = "biuro51";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-4", res, 2329, 654, false); // deactivated

	resname = "biuro50";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-3", res, 2465, 635);
	resname = "biuro50";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-4", res, 2397, 674);

	resname = "biuro49";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2221, 650, false); // deactivated
	resname = "biuro53";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-4", res, 2174, 675, false); // deactivated
	resname = "biuro52";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2267, 697, false); // 2265,699 // 2257,705 // 2260,700 // deactivated
	resname = "biuro45";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2270, 724);

	resname = "biuro49";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2718, 554);
	resname = "biuro56";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2559, 612, false); // deactivated
	resname = "biuro60";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2723, 350);
	resname = "biuro9";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2756, 397);

	resname = "biuro4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2270, 398);
	resname = "biuro47";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2144, 517);

	// osiedla polnocne
	resname = "biuro39";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1609, 16);
	resname = "biuro19";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1668, 26);
	resname = "biuro21";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1753, 15, false); // deactivated
	resname = "biuro18";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-3", res, 1831, 67, false); // deactivated
	resname = "biuro23";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1923, 114, false); // deactivated
	resname = "biuro24";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2078, 134, false); // deactivated
	resname = "biuro12";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1993, 223);

	// osiedla polodniowe
	resname = "biuro26";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2969, 1239, false); // deactivated
	resname = "biuro39";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2923, 1469, false); // deactivated
	resname = "biuro39";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-3", res, 2656, 1513, false); // deactivated
	resname = "biuro59";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2656, 1571);
	resname = "biuro25";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2769, 1540, false); // deactivated
	resname = "biuro39";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-4", res, 2022, 1517, false); // deactivated
	resname = "biuro41";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1567, 1635, false); // deactivated
	resname = "biuro39";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-5", res, 1477, 1660, false); // deactivated

	resname = "biuro39";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-6", res, 540, 1555, false); // deactivated
	resname = "biuro39";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-7", res, 862, 1532, false); // deactivated

	resname = "biuroElpro";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3682, 872);
	resname = "biuroPyramid";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3017, 573);

	// aktywne budynki za biurami
	resname = "agencjaPosrednictwaPracy";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2443, 678);
	resname = "urzadMiasta";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2408, 749, true, true);

	// add non-active buildings
	resname = "most";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2141, 1132, false);
	resname = "zamek";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2850, 700, false);
	resname = "domek1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1638, 1703, false);
	resname = "domek2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2577, 1577, false);
	resname = "domek3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3063, 1362, false);
	resname = "hangar";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2100, 1572, false);
	resname = "kosciol1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2575, 800, false);
	resname = "skala-up";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 790, 0, false);
	resname = "skala-down";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3445, 1856, false);
	resname = "skala-right";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3759, 1191, false);
	resname = "skala-down-left";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 0, 2006, false);
	resname = "politechnika1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1492, 1244, false);
	resname = "politechnika2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1723, 1152, false);
	resname = "lotnisko";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3475, 457, false);
	resname = "drogowskaz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1079, 1149, false);
	resname = "drzewka-pn-zach";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 0, 144, false);
	resname = "drzewka-pn-mid";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1184, 216, false);
	resname = "drzewka-pn";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1454, 170, false);
	resname = "drzewka-pn-wsch-1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3948, 632, false);
	resname = "drzewka-pn-wsch-2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3796, 778, false);
	resname = "drzewka-pn-wsch-3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3706, 837, false);
	resname = "drzewka-pn-wsch-4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3567, 886, false);
	resname = "drzewka-podsaskim";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1949, 452, false);
	resname = "drzewka-saski1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1693, 195, false);
	resname = "drzewka-saski2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1883, 307, false);
	resname = "drzewka-pn-wsch-4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1576, 531, false);
	resname = "drzewka-pn-wsch-3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1447, 1725, false);
	resname = "drzewka-pn-wsch-2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 846, 1590, false);
	resname = "drzewka-pn-wsch-3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 520, 1609, false);
	resname = "drzewka-zus";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1074, 1025, false);
	resname = "drzewka-pd7";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2577, 929, false);
	resname = "drzewka-pn-wsch-4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2952, 545, false);
	resname = "drzewka-pd7";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3086, 585, false);
	resname = "drzewka-zach6";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3016, 585, false);
	resname = "drzewka-ing";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 947, 1113, false);
	resname = "drzewka-pn-wsch-4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1530, 2067, false);

	resname = "przystanek";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 294, 1222, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 143, 757, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1360, 721, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1068, 1294, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2471, 860, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2239, 759, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2732, 731, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2561, 556, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2720, 884, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2127, 1012, false);

	// add clouds
	resname = "chmura1";
	res = this.preloader.getResult(resname);
	this.map.addCloud(resname, res, 467, 192, 100);
	resname = "chmura2";
	res = this.preloader.getResult(resname);
	this.map.addCloud(resname, res, 392, 188, 100);
	resname = "chmura3";
	res = this.preloader.getResult(resname);
	this.map.addCloud(resname, res, 332, 136, 100);
	resname = "chmura4";
	res = this.preloader.getResult(resname);
	this.map.addCloud(resname, res, 392, 188, 100);

	// >>> ------ create interiors ------ <<<

	/**** Agencja Reklamowa 1 ****/
	resname = "intAR1";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["agencjaReklamowa1"] = interior;
	// -------
	resname = "ar1aImg";
	res = this.preloader.getResult(resname);
	var target = "intAR1r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 713,
			height: 387
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 969, 456, true, target, false, "Porozmawiaj z pracownikiem", true);
	// -------
	resname = "intAR1r";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(900, 40).setWorkerAlias('Pracownik'); // 1050 200
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Agencja Reklamowa 2 ****/
	resname = "intAR2";
	interior = new Interior(resname, gameObject, "vertical", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["agencjaReklamowa2"] = interior;
	// -------
	resname = "ar2aImg";
	res = this.preloader.getResult(resname);
	target = "intAR2r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 199,
			height: 207
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1890, 445, true, target, false, "Porozmawiaj z pracownikiem", true);
	// -------
	resname = "intAR2r";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1070, 100).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Agencja Reklamowa 3 ****/
	resname = "intAR3";
	interior = new Interior(resname, gameObject, "vertical", "left");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["agencjaReklamowa3"] = interior;
	// -------
	resname = "ar3aImg";
	res = this.preloader.getResult(resname);
	target = "intAR3r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 226,
			height: 348
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 751, 684, true, target, false, "Porozmawiaj z pracownikiem", true);
	// -------
	resname = "intAR3r";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(900, 50).setWorkerAlias('Pracownik'); // 860
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Bank 1 ****/
	resname = "intBank1";
	interior = new Interior(resname, gameObject, "vertical", "left");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["bank1"] = interior;
	// -------
	resname = "b1aImg";
	res = this.preloader.getResult(resname);
	target = "intBank1r1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 460,
			height: 558
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 741, 320, true, target, false, "Porozmawiaj&nbsp;z<br/>pracownikiem&nbsp;banku", true);
	// -------
	resname = "intBank1r1";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1000, 40).setWorkerAlias('Pracownik'); // 900 100
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Bank 2 ****/
	resname = "intBank2";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["bank2"] = interior;
	// -------
	resname = "b2r1aImg";
	res = this.preloader.getResult(resname);
	target = "intBank2r1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 136,
			height: 119
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1022, 378, true, target, false, "Porozmawiaj&nbsp;z<br/>pracownikiem&nbsp;banku", true);
	// -------
	resname = "b2r2aImg";
	res = this.preloader.getResult(resname);
	target = "intBank2r2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 193,
			height: 135
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1246, 357, true, target, false, "Porozmawiaj&nbsp;z<br/>pracownikiem&nbsp;banku", true);
	// -------
	resname = "intBank2r1";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(970, 250).setWorkerAlias('Pracownik'); // 1000, 150
	interior.activateHTML();
	// -------
	resname = "intBank2r2";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(950, 200).setWorkerAlias('Pracownik'); // 950 200
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Bank 3 ****/
	resname = "intBank3";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["bank3"] = interior;
	// -------
	resname = "b3r1aImg";
	res = this.preloader.getResult(resname);
	target = "intBank3r2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 216,
			height: 194
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 669, 322, true, target, false, "Porozmawiaj z<br/>pracownikiem banku", true);
	// -------
	resname = "b3r2aImg";
	res = this.preloader.getResult(resname);
	target = "intBank3r1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 153,
			height: 184
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1597, 299, true, target, false, "Porozmawiaj&nbsp;z<br/>pracownikiem&nbsp;banku", true);
	// -------
	resname = "intBank3r1";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1170, 70).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// -------
	resname = "intBank3r2";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(910, 70).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Bank 4 ****/
	resname = "intBank4";
	interior = new Interior(resname, gameObject, "uniform", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["bank4"] = interior;
	// -------
	resname = "b4aImg";
	res = this.preloader.getResult(resname);
	target = "intBank4_2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 160,
			height: 390
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1443, 361, true, target, false, "Podejdź do okienka", true);
	// -------
	resname = "intBank4_2";
	interior = new Interior(resname, gameObject, "vertical", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	// -------
	resname = "b4r1aImg";
	res = this.preloader.getResult(resname);
	target = "intBank4r1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 458,
			height: 572
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 362, 384, true, target, false, "Porozmawiaj&nbsp;z<br/>pracownikiem&nbsp;banku", true);
	// -------
	resname = "b4r2aImg";
	res = this.preloader.getResult(resname);
	target = "intBank4r2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 398,
			height: 525
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 2219, 419, true, target, false, "Porozmawiaj&nbsp;z<br/>pracownikiem&nbsp;banku", true);
	// -------
	resname = "intBank4r1";
	interior = new Interior(resname, gameObject, "uniform", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1100, 100).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// -------
	resname = "intBank4r2";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(510, 150, "right").setWorkerAlias('Pracownik'); // 650 100
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Centrum Szkoleniowe 1 ****/
	resname = "intCS1";
	interior = new Interior(resname, gameObject, "vertical", "left");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["centrumSzkoleniowe1"] = interior;
	// -------
	resname = "cs1aImg";
	res = this.preloader.getResult(resname);
	target = "intCS1r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 392,
			height: 320
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 798, 335, true, target, false, "Porozmawiaj z pracownikiem centrum szkoleniowego", true);
	// -------
	resname = "intCS1r";
	interior = new Interior(resname, gameObject, "uniform", "left");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(800, 50).setWorkerAlias('Pracownik');
	// -------
	resname = "intCS1e";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS1b";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS1s";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Centrum Szkoleniowe 2 ****/
	resname = "intCS2";
	interior = new Interior(resname, gameObject, "vertical", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["centrumSzkoleniowe2"] = interior;
	interior.enableDialogue(2000, 100, "right").setWorkerAlias('Pracownik'); // 2020 150
	// -------
	resname = "intCS2e";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS2b";
	interior = new Interior(resname, gameObject, "uniform", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS2s";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Centrum Szkoleniowe 3 ****/
	resname = "intCS3";
	interior = new Interior(resname, gameObject, "vertical", "left");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["centrumSzkoleniowe3"] = interior;
	// -------
	resname = "cs3aImg";
	res = this.preloader.getResult(resname);
	target = "intCS3r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 219,
			height: 326
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 537, 344, true, target, false, "Porozmawiaj z pracownikiem centrum szkoleniowego", true);
	// -------
	resname = "intCS3r"; //recepcja
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(870, 200).setWorkerAlias('Pracownik');
	// -------
	resname = "intCS3e"; //sala egzaminacyjna (lista szkolen, ich hitoria itp)
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS3b"; //komputer egzaminacyjny
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS3s"; //tablica szkoleniowa (komputer egzaminacyjny)
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Centrum Szkoleniowe 4 ****/
	resname = "intCS4";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["centrumSzkoleniowe4"] = interior;
	// -------
	resname = "cs4aImg";
	res = this.preloader.getResult(resname);
	target = "intCS4r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 152,
			height: 210
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1504, 269, true, target, false, "Porozmawiaj z pracownikiem centrum szkoleniowego", true);
	// -------
	resname = "intCS4r";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(380, 100, "right").setWorkerAlias('Pracownik');
	// -------
	resname = "intCS4e";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS4b";
	interior = new Interior(resname, gameObject, "uniform", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS4s";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Urzad Skarbowy 1 ****/
	resname = "intUS";
	interior = new Interior(resname, gameObject, "vertical");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["urzadSkarbowy1"] = interior;
	// -------
	resname = "usr1aImg";
	res = this.preloader.getResult(resname);
	target = "intUS1r1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 172,
			height: 155
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 196, 484, true, target, false, "Podejdź do informacji aby zadać pytanie.", true);
	// -------
	resname = "usr2aImg";
	res = this.preloader.getResult(resname);
	target = "intUS1r2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 246,
			height: 225
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 886, 357, true, target, false, "Podejdź tutaj aby złożyć deklaracje.", true);
	// -------
	resname = "intUSr1";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["intUS1r1"] = interior;
	interior.enableDialogue(190, 80, "right").setWorkerAlias('Urzędnik');
	// -------
	resname = "intUSr2";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	interior.enableDialogue(1000, 50).setWorkerAlias('Urzędnik'); // 1150 50
	interior.activateHTML();
	this.interiors["intUS1r2"] = interior;
	// ---------------------------------------------------

	/**** Urzad Skarbowy 2 ****/
	resname = "intUS";
	interior = new Interior(resname, gameObject, "vertical");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["urzadSkarbowy2"] = interior;
	// -------
	resname = "usr1aImg";
	res = this.preloader.getResult(resname);
	target = "intUS2r1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 172,
			height: 155
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 196, 484, true, target, false, "Podejdź do informacji aby zadać pytanie.", true);
	// -------
	resname = "usr2aImg";
	res = this.preloader.getResult(resname);
	target = "intUS2r2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 246,
			height: 225
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 886, 357, true, target, false, "Podejdź tutaj aby złożyć deklaracje.", true);
	// -------
	resname = "intUSr1";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["intUS2r1"] = interior;
	interior.enableDialogue(190, 80, "right").setWorkerAlias('Urzędnik');
	// -------
	resname = "intUSr2";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	interior.enableDialogue(1000, 50).setWorkerAlias('Urzędnik'); // 1150 50
	interior.activateHTML();
	this.interiors["intUS2r2"] = interior;
	// ---------------------------------------------------

	/**** Urzad Skarbowy 3 ****/
	resname = "intUS";
	interior = new Interior(resname, gameObject, "vertical");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["urzadSkarbowy3"] = interior;
	// -------
	resname = "usr1aImg";
	res = this.preloader.getResult(resname);
	target = "intUS3r1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 172,
			height: 155
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 196, 484, true, target, false, "Podejdź do informacji aby zadać pytanie.", true);
	// -------
	resname = "usr2aImg";
	res = this.preloader.getResult(resname);
	target = "intUS3r2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 246,
			height: 225
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 886, 357, true, target, false, "Podejdź tutaj aby złożyć deklaracje.", true);
	// -------
	resname = "intUSr1";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["intUS3r1"] = interior;
	interior.enableDialogue(190, 80, "right").setWorkerAlias('Urzędnik');
	// -------
	resname = "intUSr2";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	interior.enableDialogue(1000, 50).setWorkerAlias('Urzędnik'); // 1150 50
	interior.activateHTML();
	this.interiors["intUS3r2"] = interior;
	// -------
	resname = "intUSs_nip";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intUSs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intUSs_vat7";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intUSs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intUSs_vat7k";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intUSs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intUSs_pit36";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intUSs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intUSs_vatr";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intUSs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Urzad Pracy ****/
	resname = "intUP";
	interior = new Interior(resname, gameObject, "vertical", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["urzadPracy"] = interior;
	// -------
	resname = "uptaImg";
	res = this.preloader.getResult(resname);
	target = "intUPt";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 142,
			height: 243
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 2049, 697, true, target, false, "Podejdź do terminalu aby pobrać numerek.", true);
	// -------
	resname = "intUPr1";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	interior.enableDialogue(1190, 100).setWorkerAlias('Urzędnik');
	interior.activateHTML();
	this.interiors[resname] = interior;
	// ------- strzalka
	/*
	resname = "strzalkaImg";
	res = this.preloader.getResult(resname);
	target = "urzadPracy";
        var sprite = new createjs.SpriteSheet({
                images: [res],
                frames: {width:142, height:142},
                animations: { blank:[0] }
        });
	interior.addActiveElement(sprite,resname,30,850,true,target);
	*/
	// -------
	resname = "intUPr2";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	interior.enableDialogue(1320, 100).setWorkerAlias('Urzędnik');
	interior.activateHTML();
	this.interiors[resname] = interior;
	// ------- strzalka
	/*
	resname = "strzalkaImg";
	res = this.preloader.getResult(resname);
	target = "urzadPracy";
        var sprite = new createjs.SpriteSheet({
                images: [res],
                frames: {width:142, height:142},
                animations: { blank:[0] }
        });
	interior.addActiveElement(sprite,resname,30,850,true,target);
	*/
	// -------
	resname = "intUPs";
	interior = new Interior(resname + "1", gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["intUPs1"] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intUPs";
	interior = new Interior(resname + "2", gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["intUPs2"] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intUPt";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	// ------- strzalka
	/*
	resname = "strzalkaImg";
	res = this.preloader.getResult(resname);
	target = "urzadPracy";
        var sprite = new createjs.SpriteSheet({
                images: [res],
                frames: {width:142, height:142},
                animations: { blank:[0] }
        });
	interior.addActiveElement(sprite,resname,30,850,true,target);
	*/
	// ------- karteczki
	resname = "upn1aImg";
	res = this.preloader.getResult(resname);
	target = "intUPr1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 293,
			height: 287
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1360, 1090, true, target);
	// -------
	resname = "upn2aImg";
	res = this.preloader.getResult(resname);
	target = "intUPr2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 293,
			height: 287
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1360, 1090, true, target);
	// ------- przyciski terminalu
	resname = "uptp1aImg";
	res = this.preloader.getResult(resname);
	target = "intUPr1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 573,
			height: 115
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 661, 189, true, target, true);
	// -------
	resname = "uptp2aImg";
	res = this.preloader.getResult(resname);
	target = "intUPr2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 573,
			height: 115
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 661, 394, true, target, true);
	// ---------------------------------------------------

	/**** Agencja Posrednictwa Pracy ****/
	resname = "intAPP";
	interior = new Interior(resname, gameObject, "vertical", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["agencjaPosrednictwaPracy"] = interior;
	// -------
	resname = "appr1aImg";
	res = this.preloader.getResult(resname);
	target = "intAPPr1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 379,
			height: 335
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 955, 512, true, target, false, "Porozmawiaj z urzędnikiem", true);
	// -------
	resname = "appr2aImg";
	res = this.preloader.getResult(resname);
	target = "intAPPr2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 329,
			height: 386
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1628, 518, true, target, false, "Porozmawiaj z urzędnikiem", true);
	// -------
	resname = "intAPPr1";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1000, 100).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// -------
	resname = "intAPPr2";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1000, 50).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// ---------------------------------------------------

	/**** ZUS ****/
	resname = "intZ";
	interior = new Interior(resname, gameObject, "vertical", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["zus"] = interior;
	// -------
	resname = "zustaImg";
	res = this.preloader.getResult(resname);
	target = "intZt";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 280,
			height: 517
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 2606, 535, true, target, false, "Podejdź do terminalu", true);
	// -------
	resname = "intZt";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	// ------- przyciski terminalu zus
	resname = "zustp1aImg";
	res = this.preloader.getResult(resname);
	target = "intZr1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 589,
			height: 89
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 520, 396, true, target, true);
	// -------
	resname = "zustp2aImg";
	res = this.preloader.getResult(resname);
	target = "intZr2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 590,
			height: 90
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 519, 547, true, target, true);
	// ------- karteczki
	resname = "zusn1aImg";
	res = this.preloader.getResult(resname);
	target = "intZr1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 293,
			height: 287
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1360, 1090, true, target);
	// -------
	resname = "zusn2aImg";
	res = this.preloader.getResult(resname);
	target = "intZr2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 293,
			height: 287
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1360, 1090, true, target);
	// ------- rozmowy
	resname = "intZr1";
	interior = new Interior(resname, gameObject, "uniform", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1150, 100).setWorkerAlias('Pracownik');
	// -------
	resname = "intZr2";
	interior = new Interior(resname, gameObject, "uniform", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	interior.enableDialogue(1200, 150).setWorkerAlias('Pracownik');
	interior.activateHTML();
	this.interiors[resname] = interior;
	// -------
	/*
	resname = "intZs";
	interior = new Interior(resname,gameObject,"uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	*/
	// -------
	resname = "intZs_zua";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intZs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intZs_rca";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intZs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intZs_dra";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intZs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Biurko ****/
	resname = "biurko";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["zlecenia"] = interior;
	interior.activateHTML();

	resname = "biurko";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["noweZlecenia"] = interior;
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Biuro gracza ****/
	resname = "biuroGracza";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["biuroGracza"] = interior;
	// -------
	resname = "biuroTlo";
	res = this.preloader.getResult(resname);
	target = "back";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 1920,
			height: 1080
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 0, 0, false, target);
	// -------
	resname = "treeSprite";
	res = this.preloader.getResult(resname);
	target = "back";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 980,
			height: 720
				// count: 10
		},
		animations: {
			blank: [0, 20, true, 1]
		}
	});
	interior.addActiveElement(sprite, resname, 544, 0, false, target);
	// -------
	resname = "komputerSprite";
	res = this.preloader.getResult(resname);
	target = "internet";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 193,
			height: 155
		},
		animations: {
			blank: [0],
			opening: [0, 23, false, 1]
		}
	});
	interior.addActiveElement(sprite, resname, 880, 507, true, target, true, "Włącz laptopa", true);
	// -------

	/**** Komputer ****/
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["internet"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["internetBankowosc"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["internetCEIDG"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["internetKsiegowosc"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["finanse"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["statystyki"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["dokumenty"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["pracownicy"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["skrzynka"] = interior;
	interior.activateHTML();
	// ---------------------------------------------------

	//pass current building id to interior request
	function biuroZleceniaDataCallback() {
		var budDat = Building.current.getBuildingData();
		return {
			buildingId: budDat['id']
		};
	}

	/**** Kontrahent ****/
	resname = "biuroZlecenia1";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	interior.getDataCallback = biuroZleceniaDataCallback;
	// ---
	resname = "bz1raImg";
	res = this.preloader.getResult(resname);
	target = "biuroZlecenia1r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 299,
			height: 193
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 874, 377, true, target, false, "Porozmawiaj z pracownikiem", true);
	// -------
	resname = "biuroZlecenia1r";
	interior = new Interior(resname, gameObject, "uniform", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1300, 100).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// -------
	resname = "biuroZlecenia2";
	interior = new Interior(resname, gameObject, "vertical");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	interior.getDataCallback = biuroZleceniaDataCallback;
	// ---
	resname = "bz2raImg";
	res = this.preloader.getResult(resname);
	target = "biuroZlecenia2r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 299,
			height: 196
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 874, 374, true, target, false, "Porozmawiaj z pracownikiem", true);
	// -------
	resname = "biuroZlecenia2r";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1400, 100).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// -------

	// set container
	var newcontainer = this.map.getContainer();
	this.container = newcontainer;
	stage.addChild(this.container);

	// also check current hash at game init
	this.parseUrl();

	// hide preloader
	$("#loader").fadeOut(1000);

	var hash = window.location.hash;

	if (window.parsed == false)
		windowParseUrl();

	if (hash != "#register" && hash != "#password")
		window.location.hash = "";

	// setup crossroads on the map
	for (var a = 0; a < this.map.traffic.roads.length; a++) {
		var firstCrossroad = this.map.traffic.crossroads[this.map.traffic.roads[a].s1];
		var secondCrossroad = this.map.traffic.crossroads[this.map.traffic.roads[a].s2];
		if (firstCrossroad == undefined || secondCrossroad == undefined)
			continue;
	}

	this.stage.update();
};

Game.prototype.drawLine = function(a, b) {
	var g = new createjs.Graphics();
	g.setStrokeStyle(1);
	g.beginStroke(createjs.Graphics.getRGB(255, 0, 0));
	g.beginFill(createjs.Graphics.getRGB(255, 0, 0));
	g.drawCircle(0, 0, 3);
	var g = new createjs.Graphics();
	g.setStrokeStyle(1);
	g.beginStroke(createjs.Graphics.getRGB(255, 0, 0));
	g.beginFill(createjs.Graphics.getRGB(255, 0, 0));
	//g.drawCircle(0,0,3);
	var s = new createjs.Shape(g);
	//s/.x = firstCrossroad.position.x;
	//s.y = firstCrossroad.position.y;
	s.graphics.moveTo(a.x, a.y);
	s.graphics.lineTo(b.x, b.y);
	this.map.container.addChild(s);
}

Game.prototype.keyboard = function(event) {
	// scrolling containers using arrow keys
	if (this.map != null) {
		var c = this.container;
		var i, w, h;
		if (this.currentInterior == -1) {
			i = this.map.getImage();
			w = i.width - this.canvas.width;
			h = i.height - this.canvas.height;
		} else {
			i = this.interiors[this.currentInterior].image;
			s = this.getScaleInterior();
			w = (i.width * s) - this.canvas.width;
			h = (i.height * s) - this.canvas.height;
		}

		switch (event.which) {
			case 37:
				if (this._enableMapMovement) { // left
					if (c.x < 0) c.x += 10;
					else c.x = 0;
				} else return;
				break;
			case 38:
				if (this._enableMapMovement) { // up
					if (this.currentInterior == -1 && c.y < 0) c.y += 10;
				} else return;
				break;
			case 39:
				if (this._enableMapMovement) { // right
					if (c.x > -w) c.x -= 10;
					else c.x = -w;
				} else return;
				break;
			case 40:
				if (this._enableMapMovement) { // down
					if (this.currentInterior == -1 && c.y > -h) c.y -= 10;
				} else return;
				break;
			default:
				return; // exit this handler for other keys
		}
		if (this.currentInterior == -1) this.updateMinimap();
	}
	event.preventDefault();
};

Game.prototype.setContainer = function(c, interior) {
	this.currentInterior = typeof interior !== 'undefined' ? interior : -1;

	if (this.currentInterior != -1) {
		if ($("#button-back").not(":visible")) {
			$("#button-back").clearQueue().finish().fadeIn(500).addClass("hover1").delay(200).queue(function() {
				$(this).removeClass("hover1");
				$("#button-back").tipsy({
					gravity: 'w',
					trigger: 'manual',
					html: true
				}).tipsy('show');

				if ($("#rightbuttons").is(":visible")) {
					$("#rightbuttons").fadeOut(500);
					if ($("#symbol-biuro").hasClass("hover2")) {
						$("#symbol-biuro").trigger("click");
					}
				}

				if ($("#minimap").is(":visible")) {
					$("#minimap").fadeOut(500, function() {
						checkSize();
						$("#minimap-radar").css("display", "none");
						$("#minimap-linkback").css("display", "block");

						$("#symbol-hidemap").clearQueue().finish().animate({
							"right": "10px"
						}, 1000, "easeInExpo");
						$("#bottombar").clearQueue().finish().animate({
							right: "-240px"
						}, 1000, "easeInExpo");
						$("#rightbuttons").clearQueue().finish().animate({
							marginRight: "80px"
						}, 1000, "easeInExpo");
						$("#symbol-hidemap-img").removeClass("hidemap");
						$("#symbol-hidemap-img").addClass("showmap");
					});
				}
			});
		}
	} else {
		$("#minimap-radar").css("display", "block");
		$("#minimap-linkback").css("display", "none");
		$("#button-back").fadeOut(1000).tipsy({
			gravity: 'w',
			trigger: 'manual',
			html: true
		}).tipsy('hide');
		$("#rightbuttons").fadeIn(500).tipsy({
			gravity: 'w',
			trigger: 'manual',
			html: true
		}).tipsy('show');
	}

	var game = this;

	// if user logged in - enter the building
	$.get(window.links.studentAjaxIsLoggedIn, function(result) {
		if (result == "1" && window.isLoggedIn) {
			// reset container settings
			game.container.alpha = 1;
			game.container.scaleX = 1;
			game.container.scaleY = 1;

			// switch containers
			game.container = c;
			game.stage.removeAllChildren();
			game.stage.addChild(c);
		}

	});
};

Game.prototype.hideAllTooltips = function() {
	$(".gameTooltip").each(function() {
		var tname = $(this).attr('aria-describedby');
		var child = $("#" + tname);
		if (child.length > 0) {
			$(this).tooltip('close');
			$(this).attr("title", "");
		}
		$(this).attr("canvasX", "-500");
		$(this).attr("canvasY", "-500");
		$(this).prop("canvasX", "-500");
		$(this).prop("canvasY", "-500");
		$(this).css({
			top: "-500px",
			left: "-500px"
		});
	});
}

Game.prototype.parseUrl = function() {
	var hash = window.location.hash;

	$('.interiorHTMLElement').remove(); //hide additional interior elements
	$("#dialogue").hide();

	// hide all tooltips from previous game state (if any)
	this.hideAllTooltips();

	// changing game state, activating actions and animations
	switch (hash) {
		case "#tutorial":

		case "#city": // back to city from building
			if (this.currentInterior != -1) {
				createjs.Tween.get(this.interiors[this.currentInterior].getContainer()).to({
					alpha: 0
				}, 1000);
			}
			//disable dialogue event handlers on exit
			$(document).off('.przedsiebiorcaDialogueEvents');
		default:
			var intname = hash.replace("#", "");

			// TODO check if part of the string is kontrahent- show interior accordingly

			this.resize();

			var interior = this.interiors[intname];
			if (interior != null) {
				if (this.currentInterior != -1) {
					//	this.interiors[this.currentInterior].getContainer().alpha=1;
					//	this.interiors[this.currentInterior].getContainer().scaleX = 1;
					//      this.interiors[this.currentInterior].getContainer().scaleY = 1;
					this.interiors[this.currentInterior].getContainer().x = 0;
					this.interiors[this.currentInterior].getContainer().y = 0;
				}
				this.setContainer(interior.getContainer(), intname);
				this.interiors[this.currentInterior].getContainer().alpha = 0;
				this.interiors[this.currentInterior].getContainer().scaleX = 1;
				this.interiors[this.currentInterior].getContainer().scaleY = 1;
				this.scaleInterior();

				interior.scrollToPos();
				//interior.openTooltips();

				var tween = createjs.Tween.get(this.interiors[this.currentInterior].getContainer())
					.to({
						alpha: 1
					}, 1000).call(function() {
						interior.openTooltips();
					});
				game.scrollable = true;

				//if(hash=="#urzadPracy_formularz")
				//	activateForm(1);
				//else if(hash=="#internet")
				//	activateForm(2);

				interior.enableAdditionalElements(); //enables additional html elements
			} else if (this.map != null) {
				this.setContainer(this.map.getContainer());
				this.map.container.x = -this.map.image.width / 3;
				this.map.container.y = -this.map.image.height / 3;
				game.scrollable = false;
			}
			break;
	}
}

Game.prototype.scaleInterior = function() {
	if (this.currentInterior != -1) //>=0)
	{
		if (this.interiors[this.currentInterior].isHorizontalStretch()) //hstretch)
			this.interiors[this.currentInterior].container.scaleX = this.interiors[this.currentInterior].container.scaleY = this.getScaleInterior();
		else
			this.interiors[this.currentInterior].container.scaleY = this.interiors[this.currentInterior].container.scaleX = this.getScaleInterior();
	}
}

Game.prototype.getScaleInterior = function() {
	if (this.currentInterior != -1) //>=0)
	{
		if (this.interiors[this.currentInterior].isHorizontalStretch()) //hstretch)
		{
			var initialWidth = this.interiors[this.currentInterior].image.width;
			var targetWidth = this.canvas.width;
			return scale = targetWidth / initialWidth;
		} else {
			var initialHeight = this.interiors[this.currentInterior].image.height;
			var targetHeight = this.canvas.height;
			return scale = targetHeight / initialHeight;
		}
	} else return 1;
}

Game.prototype.updateMinimap = function() {
	var mw = $("#minimap").width();
	var mh = $("#minimap").height();
	var rw = $("#minimap-radar").width();
	var rh = $("#minimap-radar").height();

	ox = ((-this.container.x) / (this.map.image.width - this.canvas.width)) * (mw - rw - 5);
	oy = ((-this.container.y) / (this.map.image.height - this.canvas.height)) * (mh - rh - 5);

	var tx = this.container.x;
	var ty = this.container.y;
	var mx = this.map.image.width;
	var my = this.map.image.height;
	var cw = this.canvas.width;

	$("#minimap-radar").css({
		left: ox + "px",
		top: oy + "px"
	});
}

Game.prototype.isLoading = function() {
	return (this.preloader.progress > 0 && this.preloader.progress < 1) ? true : false;
}

//var internalTooltip = { bitmap:"", width:0, height:0, description:"" };

function Interior(n, gameObject, stretchMode, scrollTo) {
	this.name = n;
	this.game = gameObject;
	this.image = null; // background image
	this.bitmap = null; // interior background Bitmap
	this.dialogue = null; // Dialogue object inside this interior
	this.container = null; // each interior has separate container
	this.activeElements = []; // clickable elements like arrows, people, tools etc.
	this.internalTooltips = []; // array of tooltips in this interior
	this.htmlEnabled = false; // if html is enabled - data is downloaded in AjaxInfoDialog basing on current interior hash
	this.htmlLoaded = false;
	this.stretch = typeof stretchMode !== 'undefined' ? stretchMode : "vertical"; // vertical horizontal uniform
	this.scrollpos = typeof scrollTo !== 'undefined' ? scrollTo : "left"; // left center right
}

Interior.prototype.init = function(image) {
	this.image = image;
	this.bitmap = new createjs.Bitmap(image);

	if (this.bitmap != null) {
		this.container = new createjs.Container();

		var targetWidth = window.innerWidth; //this.game.canvas.width;
		var s1 = targetWidth / this.image.width;
		var targetHeight = window.innerHeight; //this.game.canvas.height;
		var s2 = targetHeight / this.image.height;

		var hstretch = this.isHorizontalStretch();
		var s = (hstretch) ? s1 : s2;

		var w = image.width;
		var h = image.height;

		// if the image is smaller than screen (like laptop interiors)
		// fill the background with neutral color - better than white
		var shape = new createjs.Shape();
		shape.graphics.beginFill("#787878").drawRect(0, 0, 4000, 3000);
		this.container.addChild(shape);

		this.container.addChild(this.bitmap);
		this.container.x = 0;
		this.container.y = 0;

		if (!hstretch) {
			this.bitmap.y = 0;
		} else // vertically center image
		{
			if (h * s < targetHeight)
				this.bitmap.y = (targetHeight - (h * s)) / 2;
		}

		this.container.alpha = 1;
		this.container.scaleX = 1;
		this.container.scaleY = 1;

		var container = this.container;
		var c = container;
		var inter = this;

		//		var canvas = document.getElementById("mainCanvas");
		this.bitmap.addEventListener("mousedown", function(evt) {
			var canvasWidth = window.innerWidth; //.game.canvas.width;
			var canvasHeight = window.innerHeight; //window.game.canvas.height;
			var s1 = canvasWidth / inter.image.width;
			var s2 = canvasHeight / inter.image.height;
			var offset = {
				x: c.x - evt.stageX,
				y: c.y - evt.stageY
			};
			evt.addEventListener("mousemove", function(e) {
				if (inter.isHorizontalStretch()) ///hstretch) // horizontal stretch = vertical scrolling
				{
					s = s1;
					if (-(e.stageY + offset.y) >= 0 && -(e.stageY + offset.y) <= (h * s - canvasHeight)) //canvas.height))
						c.y = e.stageY + offset.y;
				} else // vertical stretch = horizontal scrolling
				{
					s = s2;
					if (-(e.stageX + offset.x) >= 0 && -(e.stageX + offset.x) <= (w * s - canvasWidth)) //(w*s-canvas.width))
						c.x = e.stageX + offset.x;
				}
			});
		});
	}
}

Interior.prototype.isHorizontalStretch = function() {
	if (this.stretch == "vertical") {
		return false;
	} else if (this.stretch == "horizontal") {
		return true;
	} else // "uniform" and spelling errors
	{
		var targetWidth = window.innerWidth; //this.game.canvas.width;
		var s1 = targetWidth / this.image.width;
		var targetHeight = window.innerHeight; //this.game.canvas.height;
		var s2 = targetHeight / this.image.height;
		if (s1 > s2)
			return true;
		else
			return false;
	}
}

Interior.prototype.enableDialogue = function(x, y, direction) {
	var dir = typeof direction !== 'undefined' ? direction : "left"; // left or right
	this.dialogue = new Dialogue(this, x, y, dir);
	return this.dialogue;
}

Interior.prototype.getContainer = function() {
	if (this.bitmap != null)
		return this.container;
	else
		return null;
}

Interior.prototype.addActiveElement = function(sprite, resname, x, y, a, target, targetAnimation, description, blink) {
	var rn = typeof resname !== 'undefined' ? resname : "";
	var ta = typeof targetAnimation !== 'undefined' ? targetAnimation : false;
	var ds = typeof description !== 'undefined' ? description : "";
	var bl = typeof blink !== 'undefined' ? blink : false;

	var s = sprite;
	if (s != null) {
		var spriteBitmap = new createjs.BitmapAnimation(s);
		spriteBitmap.gotoAndPlay("blank");
		spriteBitmap.name = rn;
		spriteBitmap.x = x;
		spriteBitmap.y = y;

		if (a == true) {
			var tweenBlink;
			if (bl) {
				tweenBlink = createjs.Tween.get(spriteBitmap, {
					loop: true
				}, true);
				tweenBlink.to({
					alpha: 1
				}, 300);
				tweenBlink.to({
					alpha: 0
				}, 300);
				tweenBlink.to({
					alpha: 1
				}, 300);
			}

			if (ds.length > 1) {
				this.internalTooltips.push({
					bitmap: spriteBitmap,
					width: s._frames[0].rect.width,
					height: s._frames[0].rect.height,
					description: ds
				});
			}

			var INTERIOR = this;
			var active = this.activeElements;

			var container = this.container;
			var b = spriteBitmap;
			spriteBitmap.removeAllEventListeners();
			if (ds.length > 1) {
				var hideAll = false;
				spriteBitmap.addEventListener("mouseover", function() {
					if (hideAll)
						INTERIOR.showTooltip(spriteBitmap, s._frames[0].rect.width, s._frames[0].rect.height, ds);
					else
						hideAll = true;
				});
				spriteBitmap.addEventListener("mouseout", function() {
					if (hideAll) $('.interiorTooltip').each(function() {
						var tooltip = $(this);
						if ($('#' + tooltip.attr('aria-describedby')).length)
							tooltip.tooltip('close');
					});
				});
			}
			spriteBitmap.addEventListener("mouseover", function() {
				if (window.isInteriorAllowed(target)) {
					if (spriteBitmap.currentAnimation == "blank") {
						spriteBitmap.cursor = "pointer";
						spriteBitmap.alpha = 0.3;
					} else {
						spriteBitmap.cursor = "default";
						spriteBitmap.alpha = 1;
					}
				}
			});
			spriteBitmap.addEventListener("mouseout", function() {
				if (window.isInteriorAllowed(target)) {
					spriteBitmap.cursor = "default";
					spriteBitmap.alpha = 1;
				}
			});
			spriteBitmap.addEventListener("click", function() {
				if (!$(".ui-dialog-content").is(':visible') && (INTERIOR.htmlEnabled === false || INTERIOR.htmlLoaded)) {
					if (window.isInteriorAllowed(target)) {
						$(document).trigger('activeElementClicked.przedsiebiorca', {
							interior: INTERIOR,
							target: target
						});
						if (ta) {
							switch (target) {
								case "intUPr1":
								case "intUPr2":
								case "intZr1":
								case "intZr2":
									// :: Karteczki
									// hide others
									for (var key in active) {
										if (!key.match(/anim$/) && key != "strzalka") {
											// if()
											active[key].y = 1090;
										} else {}
									}
									// bring up this bitmap animation
									var spriteBitmap2 = active[target];
									var tween = createjs.Tween.get(spriteBitmap2);
									tween.to({
										x: 1360,
										y: 450
									}, 1000); //573
									break;
								case "internet":
									createjs.Tween.removeTweens(spriteBitmap);
									spriteBitmap.cursor = "default";
									spriteBitmap.alpha = 1;
									spriteBitmap.onAnimationEnd = function() {
										if (spriteBitmap.currentAnimation == "opening") {
											var tween = createjs.Tween.get(container).to({
												x: -(b.x - 50) * 5,
												y: -b.y * 5,
												scaleX: 5,
												scaleY: 5,
												alpha: 1
											}, 1000).call(function() {
												spriteBitmap.gotoAndPlay("blank");
												window.location.hash = "#" + target;
											});
										}
									}
									spriteBitmap.gotoAndPlay("opening");
									break;
							}
						} else {
							var tween = createjs.Tween.get(container).to({
								x: -(b.x - 50) * 5,
								y: -b.y * 5,
								scaleX: 5,
								scaleY: 5,
								alpha: 0
							}, 1000).call(function() {
								window.location.hash = "#" + target;
							});
						}
					}
				}
			});
		}

		if (target == "back") {
			this.activeElements[target] = spriteBitmap;
			this.container.addChild(spriteBitmap);
			this.container.setChildIndex(spriteBitmap, 0);
		} else if (rn == "strzalka") {
			this.activeElements[rn] = spriteBitmap;
			this.container.addChild(spriteBitmap);
			spriteBitmap.parent.addChild(spriteBitmap);
		} else {
			//this.activeElements.push(spriteBitmap);
			this.activeElements[target + (ta ? "anim" : "")] = spriteBitmap;
			this.container.addChild(spriteBitmap);
			spriteBitmap.parent.addChild(spriteBitmap);
		}
	}
}

Interior.prototype.activateHTML = function() {
	this.htmlEnabled = true;
}

Interior.prototype.loadHTML = function() {
	var GameObject = this.game;
	if ( /*!window.DEBUG_MODE &&*/ !window.isInteriorAllowed(window.game.currentInterior)) return;
	this.htmlLoaded = false;

	//pass additional data to interior
	var data = {
		hash: window.game.currentInterior
	};
	if (this.data) //from interior data property
	{
		for (var i in this.data)
			data[i] = this.data[i];
	}
	if (this.getDataCallback) {
		var additionalData = this.getDataCallback(); //from data callback function
		for (var i in additionalData)
			data[i] = additionalData[i];
	}

	var INTERIOR = this;

	$.post(window.links.studentAjaxInteriorHTML, data)
		.done(function(data) {
			var interiorHTMLElement = $('<div></div>');
			interiorHTMLElement.attr('class', 'interiorHTMLElement');
			interiorHTMLElement.appendTo('#canvasHolder');
			interiorHTMLElement.html(data);
			GameObject.refreshScene();
			if (INTERIOR.dialogue)
				INTERIOR.dialogue.enable();
		})
		.fail(function() {
			window.location.hash = '#city';
		})
		.always(function() {
			INTERIOR.htmlLoaded = true;
		});
}

Interior.prototype.getActionElement = function(id) {
	return id;
}

Interior.prototype.enableAdditionalElements = function() {
	$('.interiorHTMLElement').remove();
	$("#dialogue").hide();

	if (this.htmlEnabled)
		this.loadHTML();
	else if (this.dialogue)
		this.dialogue.enable();
}

Interior.prototype.showTooltip = function(bitmap, width, height, description) {
	if (!bitmap) return false;

	var ds = typeof description !== 'undefined' ? description : "";
	var tooltipObj = $('<div class="gameTooltip sticker interiorTooltip" title=""></div>');
	tooltipObj.appendTo($('#canvasHolder'));

	var container = this.container;

	var x = bitmap.x;
	var y = bitmap.y;
	var w = width * container.scaleX;
	var h = height * container.scaleY;

	$(document).on('activeElementClicked.przedsiebiorca', function() {
		if ($('#' + tooltipObj.attr('aria-describedby')).length)
			tooltipObj.tooltip('close');
	});

	tooltipObj.tooltip({
		disabled: true,
		position: {
			using: function() {
				$(this).attr("canvasY", y - $(this).outerHeight(true) - 25);
				$(this).attr("canvasX", x - ($(this).outerWidth(true) - width) / 2);
				$(this).addClass("sticker");
			}
		},
		content: ds + '<div class="tooltip-arrow bottom center"></div>',
		show: {
			effect: 'slideDown',
			duration: 100
		},
		hide: {
			effect: 'slideUp',
			duration: 100
		},
		close: function(event) {
			$(event.target).remove();
		}
	});

	tooltipObj.css({
		width: w + 'px',
		height: h + 'px',
		cursor: "pointer",
		zIndex: 10,
	});
	tooltipObj.tooltip("open").on('mouseout focusout mousemove mousein focusin mouseenter mouseleave hover', function(event) {
		event.stopImmediatePropagation();
	});

	tooltipObj.click(function() {
		bitmap.dispatchEvent("click");
	});

	var tname = tooltipObj.attr('aria-describedby');

	var child = $("#" + tname);

	if (child.length) {
		child.css('text-align', 'center');
		child.css('top', '-500px');
		child.css('left', '-500px');
	}

	adjustDialoguePosition();
}

Interior.prototype.openTooltips = function() {
	$('.interiorTooltip').remove();
	for (i = 0; i < this.internalTooltips.length; i++) {
		var ct = this.internalTooltips[i];
		this.showTooltip(ct.bitmap, ct.width, ct.height, ct.description);
	}
}

Interior.prototype.scrollToPos = function() {
	var d = this.scrollpos;
	var i = this.image;
	var canv = this.game.canvas;
	var cont = this.container;
	var s = this.game.getScaleInterior();

	var w, h;
	if (canv != null && cont != null) {
		w = (i.width * s) - canv.width;
		h = (i.height * s) - canv.height;
	}

	if (d == "left") {
		cont.x = 0;
	} else if (d == "center") {
		cont.x = -(w / 2);
	} else if (d == "right") {
		cont.x = -w;
	} else // "left" on spelling errors
	{
		cont.x = 0;
	}
}

function Map(gameObject) {
	this.game = gameObject; // pointer to Game object, needed to setGameState
	this.image = null; // background image (need to be stored for events)
	this.bitmap = null; // background bitmap
	this.container = null; // map container
	this.traffic = null; // traffic ai
	this.pedestrians = [];
	this.buildings = [];
	this.cars = [];
}

Map.prototype.init = function(image) {
	this.image = image;
	this.bitmap = new createjs.Bitmap(image);

	if (this.bitmap != null) {
		/* loading city background */
		this.container = new createjs.Container();
		this.container.addChild(this.bitmap);
		this.container.x = -this.image.width / 3;
		this.container.y = -this.image.height / 3;

		this.traffic = new Traffic();

		var g = this.game;
		var w = this.image.width;
		var h = this.image.height;
		var container = this.container;

		// move map by left mouse click and drag
		this.bitmap.addEventListener("mousedown", function(evt) {
			var c = container;
			var offset = {
				x: c.x - evt.stageX,
				y: c.y - evt.stageY
			};
			evt.addEventListener("mousemove", function(e) {
				var canvas = document.getElementById("mainCanvas");
				if (e.stageX + offset.x <= 0 && e.stageX + offset.x >= -(w - canvas.width))
					c.x = e.stageX + offset.x;
				if (e.stageY + offset.y <= 0 && e.stageY + offset.y >= -(h - canvas.height))
					c.y = e.stageY + offset.y;
				g.mousePos = {
					x: 300,
					y: 300
				};
				g.mouseOldPos = {
					x: 300,
					y: 300
				};
				g.updateMinimap();
			});
			g.mousePos = {
				x: 300,
				y: 300
			};
			g.mouseOldPos = {
				x: 300,
				y: 300
			};
		}, true);
	}
}

Map.prototype.getContainer = function() {
	if (this.bitmap != null)
		return this.container;
	else
		return null;
}

Map.prototype.addBuilding = function(n, i, x, y, a, d) {
	var building = new Building(n, x, y, this.game, a, d);
	building.init(i);
	//this.buildings.push(building);
	this.buildings[n] = building;
	this.container.addChild(building.bitmap);
	building.bitmap.parent.addChild(building.bitmap); // force bitmap on top layer
}

Map.prototype.getBuilding = function(name) //id)
	{
		//return this.buildings[id];
		return this.buildings[name];
	}

Map.prototype.getBuildingById = function(id) {
	var buildings = jQuery.parseJSON(userdata['budynki']);
	for (var i in buildings) {
		var building = buildings[i];
		if (building.id == id)
			return this.buildings[i];
	}
	return null;
}

Map.prototype.addPedestrian = function(n, i, sx, sy, s, a) {
	// this code needs refactoring when there is more time
	var human = new Pedestrian(n, sx, sy, s, a);
	human.init(i);
	this.pedestrians.push(human);
	this.container.addChild(human.bitmap);
	human.bitmap.parent.addChild(human.bitmap);

	if (this.pedestrians.length <= 6) {
		var p = [];
		p.push({
			x: 937,
			y: 1030
		});
		p.push({
			x: 750,
			y: 923
		});
		p.push({
			x: 1050,
			y: 753
		});
		p.push({
			x: 1375,
			y: 940
		});
		p.push({
			x: 1230,
			y: 1026
		});
		p.push({
			x: 1090,
			y: 950
		});

		var sn = this.pedestrians.length - 1;

		human.bitmap.x = p[sn].x;
		human.bitmap.y = p[sn].y;
		human.bitmap.gotoAndPlay("back");

		var src = sn;
		var dst = sn + 1;
		if (dst > p.length - 1) dst = 0;

		function calculateDistance(x1, y1, x2, y2) {
			return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
		};

		function reorient1(bitmap, dst) {
			if (dst == 0) bitmap.gotoAndPlay("left");
			else if (dst == 1) bitmap.gotoAndPlay("back");
			else if (dst == 2) bitmap.gotoAndPlay("right");
			else if (dst == 3) bitmap.gotoAndPlay("front");
			else if (dst == 4) bitmap.gotoAndPlay("left");
			else if (dst == 5) bitmap.gotoAndPlay("back");
		};

		var tween = createjs.Tween.get(human.bitmap, {
			loop: true
		}, true);

		for (i = 0; i < p.length; i++) {
			tween.call(reorient1, [human.bitmap, dst]);
			tween.to({
				x: p[dst].x,
				y: p[dst].y
			}, calculateDistance(p[src].x, p[src].y, p[dst].x, p[dst].y) * s);
			if (src >= p.length - 1) {
				src = 0;
			} else {
				src++;
			}
			if (dst >= p.length - 1) {
				dst = 0;
			} else {
				dst++;
			}
		}

	} else if (this.pedestrians.length <= 14) {
		var p2 = [];
		p2.push({
			x: 582,
			y: 1400
		});
		p2.push({
			x: 282,
			y: 1232
		});
		p2.push({
			x: 434,
			y: 1140
		});
		p2.push({
			x: 217,
			y: 1014
		});
		p2.push({
			x: 333,
			y: 952
		});
		p2.push({
			x: 711,
			y: 1179
		});
		p2.push({
			x: 896,
			y: 1068
		});
		p2.push({
			x: 1030,
			y: 1140
		});

		var sn = this.pedestrians.length - 6 - 1;

		human.bitmap.x = p2[sn].x; //0
		human.bitmap.y = p2[sn].y; //0
		human.bitmap.gotoAndPlay("back");

		var src = sn;
		var dst = sn + 1;
		if (dst > p2.length - 1) dst = 0;

		function calculateDistance(x1, y1, x2, y2) {
			return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
		};

		function reorient2(bitmap, dst) {
			if (dst == 0) bitmap.gotoAndPlay("left");
			else if (dst == 1) bitmap.gotoAndPlay("back");
			else if (dst == 2) bitmap.gotoAndPlay("right");
			else if (dst == 3) bitmap.gotoAndPlay("back");
			else if (dst == 4) bitmap.gotoAndPlay("right");
			else if (dst == 5) bitmap.gotoAndPlay("front");
			else if (dst == 6) bitmap.gotoAndPlay("right");
			else if (dst == 7) bitmap.gotoAndPlay("front");
		};

		var tween = createjs.Tween.get(human.bitmap, {
			loop: true
		}, true);

		for (i = 0; i < p2.length; i++) {
			tween.call(reorient2, [human.bitmap, dst]);
			tween.to({
				x: p2[dst].x,
				y: p2[dst].y
			}, calculateDistance(p2[src].x, p2[src].y, p2[dst].x, p2[dst].y) * s);
			if (src >= p2.length - 1) {
				src = 0;
			} else {
				src++;
			}
			if (dst >= p2.length - 1) {
				dst = 0;
			} else {
				dst++;
			}
		}
	} else if (this.pedestrians.length <= 27) {
		var p3 = [];
		p3.push({
			x: 1420,
			y: 1313
		});
		p3.push({
			x: 1130,
			y: 1143
		});
		p3.push({
			x: 1423,
			y: 978
		});
		p3.push({
			x: 1483,
			y: 1016
		});
		p3.push({
			x: 1355,
			y: 1120
		});
		p3.push({
			x: 1485,
			y: 1165
		});
		p3.push({
			x: 1557,
			y: 1235
		});
		p3.push({
			x: 1720,
			y: 1145
		});
		p3.push({
			x: 1423,
			y: 978
		});
		p3.push({
			x: 1130,
			y: 1143
		});
		p3.push({
			x: 1285,
			y: 1235
		});
		p3.push({
			x: 1425,
			y: 1155
		});
		p3.push({
			x: 1557,
			y: 1235
		});

		var sn = this.pedestrians.length - 14 - 1;

		human.bitmap.x = p3[sn].x; //0
		human.bitmap.y = p3[sn].y; //0
		human.bitmap.gotoAndPlay("back");

		var src = sn;
		var dst = sn + 1;
		if (dst > p3.length - 1) dst = 0;

		function calculateDistance(x1, y1, x2, y2) {
			return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
		};

		function reorient3(bitmap, dst) {
			if (dst == 0) bitmap.gotoAndPlay("left");
			else if (dst == 1) bitmap.gotoAndPlay("back");
			else if (dst == 2) bitmap.gotoAndPlay("right");
			else if (dst == 3) bitmap.gotoAndPlay("front");
			else if (dst == 4) bitmap.gotoAndPlay("left");
			else if (dst == 5) bitmap.gotoAndPlay("front");
			else if (dst == 6) bitmap.gotoAndPlay("front");
			else if (dst == 7) bitmap.gotoAndPlay("right");
			else if (dst == 8) bitmap.gotoAndPlay("back");
			else if (dst == 9) bitmap.gotoAndPlay("left");
			else if (dst == 10) bitmap.gotoAndPlay("front");
			else if (dst == 11) bitmap.gotoAndPlay("right");
			else if (dst == 12) bitmap.gotoAndPlay("front");
			else if (dst == 13) bitmap.gotoAndPlay("left");
			else if (dst == 14) bitmap.gotoAndPlay("back");

		};

		var tween = createjs.Tween.get(human.bitmap, {
			loop: true
		}, true);

		for (i = 0; i < p3.length; i++) {
			tween.call(reorient3, [human.bitmap, dst]);
			tween.to({
				x: p3[dst].x,
				y: p3[dst].y
			}, calculateDistance(p3[src].x, p3[src].y, p3[dst].x, p3[dst].y) * s);
			if (src >= p3.length - 1) {
				src = 0;
			} else {
				src++;
			}
			if (dst >= p3.length - 1) {
				dst = 0;
			} else {
				dst++;
			}
		}
	} else if (this.pedestrians.length <= 37) {
		var p4 = [];
		p4.push({
			x: 1240,
			y: 1420
		});
		p4.push({
			x: 1110,
			y: 1352
		});
		p4.push({
			x: 1260,
			y: 1277
		});
		p4.push({
			x: 1082,
			y: 1176
		});
		p4.push({
			x: 947,
			y: 1262
		});
		p4.push({
			x: 1066,
			y: 1328
		});
		p4.push({
			x: 1124,
			y: 1286
		});
		p4.push({
			x: 1186,
			y: 1325
		});
		p4.push({
			x: 1270,
			y: 1287
		});
		p4.push({
			x: 1370,
			y: 1344
		});

		var sn = this.pedestrians.length - 27 - 1;

		human.bitmap.x = p4[sn].x;
		human.bitmap.y = p4[sn].y;
		human.bitmap.gotoAndPlay("back");

		var src = sn;
		var dst = sn + 1;
		if (dst > p4.length - 1) dst = 0;

		function calculateDistance(x1, y1, x2, y2) {
			return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
		};

		function reorient4(bitmap, dst) {
			if (dst == 0) bitmap.gotoAndPlay("left");
			else if (dst == 1) bitmap.gotoAndPlay("back");
			else if (dst == 2) bitmap.gotoAndPlay("right");
			else if (dst == 3) bitmap.gotoAndPlay("back");
			else if (dst == 4) bitmap.gotoAndPlay("left");
			else if (dst == 5) bitmap.gotoAndPlay("front");
			else if (dst == 6) bitmap.gotoAndPlay("right");
			else if (dst == 7) bitmap.gotoAndPlay("front");
			else if (dst == 8) bitmap.gotoAndPlay("right");
			else if (dst == 9) bitmap.gotoAndPlay("front");
		};

		var tween = createjs.Tween.get(human.bitmap, {
			loop: true
		}, true);

		for (i = 0; i < p4.length; i++) {
			tween.call(reorient4, [human.bitmap, dst]);
			tween.to({
				x: p4[dst].x,
				y: p4[dst].y
			}, calculateDistance(p4[src].x, p4[src].y, p4[dst].x, p4[dst].y) * s);
			if (src >= p4.length - 1) {
				src = 0;
			} else {
				src++;
			}
			if (dst >= p4.length - 1) {
				dst = 0;
			} else {
				dst++;
			}
		}
	}
}

Map.prototype.getPedestrian = function(id) {
	return this.pedestrians[id];
}

Map.prototype.addCar = function(n, i, sx, sy, s, a) {
	var car = new Car(n, sx, sy, s, a); // this.game, a
	car.init(i);
	this.cars.push(car);
	this.traffic.addCar(car);
	this.container.addChild(car.bitmap);
	car.bitmap.parent.addChild(car.bitmap); // force bitmap on top layer
}

Map.prototype.getCar = function(id) {
	return this.cars[id];
}

Map.prototype.addCloud = function(n, i, sx, sy, s, a) {
	var car = new Car(n, sx, sy, s, a);
	car.init(i);
	this.cars.push(car);
	// boat path
	this.container.addChild(car.bitmap);
	car.bitmap.parent.addChild(car.bitmap);

	var p1, p2, p3, p4, p5, p6, p7;

	if (n == "lodka") // -100 -40
	{ // x - 50
		p1 = {
			x: 1171,
			y: 1859
		};
		p2 = {
			x: 915,
			y: 1710
		};
		p3 = {
			x: 610,
			y: 1888
		};
		p4 = {
			x: 866,
			y: 2036
		};
		/*
		p1 = {x:1184,y:1964};
		p2 = {x:1028,y:1772};
		p3 = {x: 424,y:1840};
		p4 = {x: 380,y:2020};
		*/
	} else if (n == "lodka-2") // -100
	{
		p1 = {
			x: 382,
			y: 2074
		};
		p2 = {
			x: 585,
			y: 1957
		};
		p3 = {
			x: 243,
			y: 1757
		};
		p4 = {
			x: 39,
			y: 1874
		};
	} else if (n == "samolot") {
		p1 = {
			x: 3323,
			y: 485
		};
		p2 = {
			x: 4116,
			y: 18
		}; //4096,38
		p3 = {
			x: 3437,
			y: 418
		};
		p4 = {
			x: 3573,
			y: 501
		};
	} else if (n == "chmura1") {
		p1 = {
			x: 3448,
			y: 300
		};
		p2 = {
			x: 2000,
			y: 300
		};
		p3 = {
			x: 1744,
			y: 296
		};
		p4 = {
			x: -500,
			y: 850
		};
	} else if (n == "chmura2") {
		p1 = {
			x: 2640,
			y: 930
		};
		p2 = {
			x: 1700,
			y: 810
		};
		p3 = {
			x: 845,
			y: 1024
		};
		p4 = {
			x: -500,
			y: 1000
		};
	} else if (n == "chmura3") {
		p1 = {
			x: 2200,
			y: 1500
		};
		p2 = {
			x: 1600,
			y: 1500
		};
		p3 = {
			x: 400,
			y: 1700
		};
		p4 = {
			x: -500,
			y: 2000
		};
	} else if (n == "chmura4") {
		p1 = {
			x: 1500,
			y: 900
		};
		p2 = {
			x: 700,
			y: 1500
		};
		p3 = {
			x: 400,
			y: 1500
		};
		p4 = {
			x: -500,
			y: 2000
		};
	}

	car.bitmap.x = p1.x;
	car.bitmap.y = p1.y;
	car.bitmap.gotoAndPlay("northEast");

	function calculateDistance(x1, y1, x2, y2) {
		return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
	};

	var tween = createjs.Tween.get(car.bitmap, {
		loop: true
	}, true);
	if (n == "lodka") tween.call(function() {
		car.bitmap.gotoAndPlay("northWest")
	});
	// --- p1
	tween.to({
		x: p2.x,
		y: p2.y
	}, calculateDistance(p1.x, p1.y, p2.x, p2.y) * s);
	if (n == "lodka") {
		//		tween.to({rotation:-25},35*s);
		tween.call(function() {
			car.bitmap.gotoAndPlay("southWest")
		});
	}
	if (n == "lodka-2") {
		tween.call(function() {
			car.bitmap.gotoAndPlay("northWest")
		});
	}
	if (n == "samolot") tween.call(function() {
		car.bitmap.gotoAndPlay("southWest")
	});
	// --- p2
	tween.to({
		x: p3.x,
		y: p3.y
	}, calculateDistance(p2.x, p2.y, p3.x, p3.y) * s);
	if (n == "lodka") {
		//		tween.to({rotation:45},35*s);
		tween.call(function() {
			car.bitmap.gotoAndPlay("southEast")
		});
	}
	if (n == "lodka-2") {
		tween.call(function() {
			car.bitmap.gotoAndPlay("southWest")
		});
	}
	if (n == "samolot") tween.call(function() {
		car.bitmap.gotoAndPlay("southEast")
	});
	// --- p3
	if (n == "samolot")
		tween.to({
			x: p4.x,
			y: p4.y
		}, calculateDistance(p3.x, p3.y, p4.x, p4.y) * s * 7);
	else
		tween.to({
			x: p4.x,
			y: p4.y
		}, calculateDistance(p3.x, p3.y, p4.x, p4.y) * s);
	if (n == "lodka") {
		//		tween.to({rotation:-25},35*s);
		tween.call(function() {
			car.bitmap.gotoAndPlay("northEast")
		});
	}
	if (n == "lodka-2") {
		tween.call(function() {
			car.bitmap.gotoAndPlay("southEast")
		});
	}
	if (n == "samolot") tween.call(function() {
		car.bitmap.gotoAndPlay("northWest")
	});
	// --- p4
	if (n == "samolot")
		tween.to({
			x: p1.x,
			y: p1.y
		}, calculateDistance(p4.x, p4.y, p1.x, p1.y) * s * 7);
	else
		tween.to({
			x: p1.x,
			y: p1.y
		}, calculateDistance(p4.x, p4.y, p1.x, p1.y) * s);
	if (n == "lodka") {
		//		tween.to({rotation:0},35*s);
		tween.call(function() {
			car.bitmap.gotoAndPlay("northWest")
		});
	}
	if (n == "lodka-2") {
		tween.call(function() {
			car.bitmap.gotoAndPlay("northEast")
		});
	}
	if (n == "samolot") tween.call(function() {
		car.bitmap.gotoAndPlay("northEast")
	});
}

Map.prototype.getImage = function() {
	return this.image;
}

Map.prototype.clearBuildingFilters = function() {
	for (index in window.game.map.buildings) {
		window.game.map.buildings[index].clearFilters();
	}
}

//	Setup Access-Control-Allow-Origin on moodle:
//	/login/index.php
//	/login/logout.php

Moodle = {
	url: 'http://kreatywnie.lublin.eu/elearning',

	authorize: function(login, password, done) {
		$.ajax({
			type: 'POST',
			url: Moodle.url + '/login/index.php',
			crossDomain: true,
			contentType: 'application/x-www-form-urlencoded',
			data: {
				username: login,
				password: password
			},
			xhrFields: {
				withCredentials: true
			},
			beforeSend: function(xhr) {
				xhr.withCredentials = true;
			},
			success: Moodle.setup,
			complete: done
		});
	},
	login: function() {
		Moodle.authorize($('#UserStudentLoginForm_login').val(),
			$('#UserStudentLoginForm_password').val());
	},
	loginTeacher: function(done) {
		Moodle.authorize($('#UserAdministratorLoginForm_login').val(),
			$('#UserAdministratorLoginForm_password').val(), done);
	},
	setup: function() {
		$('#logoutButton').off('click');
		$('#logoutButton').on('click', function() {
			function logOut() {
				window.location.href = href;
			}
			var href = $(this).attr('href');
			$.ajax({
				type: 'GET',
				url: Moodle.url + '/login/logout.php',
				crossDomain: true,
				success: function(data) {
					var m = /<input type="hidden" name="sesskey" value="([a-zA-Z0-9]{1,})" \/>/.exec(data);
					if (m != null)
						$.ajax({
							type: 'GET',
							data: {
								sesskey: m[1]
							},
							url: Moodle.url + '/login/logout.php',
							crossDomain: true,
							complete: logOut
						});
					else logOut();
				},
				error: logOut
			});
			return false;
		});
		$('#user-student-login-form').off('submit');
		$('#user-student-login-form').on('submit', function() {
			$('input[type="submit"]').attr('disabled', true);
			Moodle.loginTeacher(function() {
				window.setTimeout(function() {
					$('#user-student-login-form').off('submit');
					$('#user-student-login-form').submit();
				}, 500);
			});
			return false;
		});
	}
}

$(document).ready(Moodle.setup);

function Pedestrian(n, sx, sy, sp, active) {
	this.name = n;
	this.sx = sx;
	this.sy = sy;
	this.bitmap = null;
	this.speed = typeof sp !== 'undefined' ? sp : 4;
	this.active = typeof active !== 'undefined' ? active : false;
}

Pedestrian.prototype.init = function(image) {
	var img = image;
	if (img != null) {
		var sprite = new createjs.SpriteSheet({
			images: [img],
			framerate: 10,
			frames: {
				width: this.sx,
				height: this.sy
			},
			animations: {
				right: [0, 27],
				back: [28, 55],
				front: [56, 83],
				left: [84, 111]
			}
		});

		this.bitmap = new createjs.BitmapAnimation(sprite);
	}
}

function Traffic() {
	this.cars = [];

	this.crossroads = [{}, //0
		{
			position: {
				x: 580,
				y: 1440
			},
			eastNorth: 1,
			eastSouth: null,
			westNorth: 2,
			westSouth: null
		}, //1
		{
			position: {
				x: 897,
				y: 1260
			},
			eastNorth: 4,
			eastSouth: 3,
			westNorth: null,
			westSouth: 1
		}, //2
		{
			position: {
				x: 1241,
				y: 1460
			},
			eastNorth: 6,
			eastSouth: null,
			westNorth: 3,
			westSouth: null
		}, //3
		{
			position: {
				x: 1428,
				y: 1352
			},
			eastNorth: 7,
			eastSouth: null,
			westNorth: 5,
			westSouth: 6
		}, //4
		{
			position: {
				x: 1084,
				y: 1154
			},
			eastNorth: 10,
			eastSouth: 5,
			westNorth: 106,
			westSouth: 4
		}, //5
		{
			position: {
				x: 1428,
				y: 956
			},
			eastNorth: 13,
			eastSouth: 9,
			westNorth: 66,
			westSouth: 10
		}, //6
		{
			position: {
				x: 1584,
				y: 1045
			},
			eastNorth: 12,
			eastSouth: 8,
			westNorth: 9,
			westSouth: null
		}, //7
		{
			position: {
				x: 1769,
				y: 1154
			},
			eastNorth: 11,
			eastSouth: null,
			westNorth: 8,
			westSouth: 7
		}, //8
		{
			position: {
				x: 1770,
				y: 935
			},
			eastNorth: 62,
			eastSouth: 14,
			westNorth: null,
			westSouth: 12
		}, //9
		{
			position: {
				x: 1957,
				y: 1044
			},
			eastNorth: 60,
			eastSouth: 15,
			westNorth: 14,
			westSouth: 11
		}, //10
		{
			position: {
				x: 2300,
				y: 845
			},
			eastNorth: null,
			eastSouth: 59,
			westNorth: 58,
			westSouth: 60
		}, //11
		{
			position: {
				x: 2112,
				y: 736
			},
			eastNorth: 42,
			eastSouth: 58,
			westNorth: 57,
			westSouth: 61
		}, //12
		{
			position: {
				x: 1925,
				y: 844
			},
			eastNorth: 61,
			eastSouth: null,
			westNorth: 63,
			westSouth: 62
		}, //13
		{
			position: {
				x: 1770,
				y: 755
			},
			eastNorth: 64,
			eastSouth: 63,
			westNorth: null,
			westSouth: 13
		}, //14
		{
			position: {
				x: 1956,
				y: 646
			},
			eastNorth: null,
			eastSouth: 57,
			westNorth: 56,
			westSouth: 64
		}, //15
		{
			position: {
				x: 1926,
				y: 628
			},
			eastNorth: 44,
			eastSouth: 56,
			westNorth: 55,
			westSouth: null
		}, //16
		{
			position: {
				x: 1772,
				y: 540
			},
			eastNorth: null,
			eastSouth: 55,
			westNorth: 54,
			westSouth: 65
		}, //17
		{
			position: {
				x: 1240,
				y: 847
			},
			eastNorth: 65,
			eastSouth: 66,
			westNorth: 67,
			westSouth: null
		}, //18
		{
			position: {
				x: 1052,
				y: 738
			},
			eastNorth: null,
			eastSouth: 67,
			westNorth: 68,
			westSouth: 87
		}, //19
		{
			position: {
				x: 865,
				y: 629
			},
			eastNorth: 53,
			eastSouth: 68,
			westNorth: 71,
			westSouth: null
		}, //20
		{
			position: {
				x: 818,
				y: 601
			},
			eastNorth: null,
			eastSouth: 71,
			westNorth: 83,
			westSouth: 69
		}, //21
		{
			position: {
				x: 475,
				y: 800
			},
			eastNorth: null,
			eastSouth: 72,
			westNorth: 73,
			westSouth: 105
		}, //22
		{
			position: {
				x: 520,
				y: 828
			},
			eastNorth: 70,
			eastSouth: 107,
			westNorth: 72,
			westSouth: null
		}, //23
		{
			position: {
				x: 336,
				y: 936
			},
			eastNorth: 104,
			eastSouth: 81,
			westNorth: 80,
			westSouth: null
		}, //24
		{
			position: {
				x: 288,
				y: 909
			},
			eastNorth: null,
			eastSouth: 80,
			westNorth: null,
			westSouth: 75
		}, //25
		{
			position: {
				x: 181,
				y: 1026
			},
			eastNorth: 77,
			eastSouth: 78,
			westNorth: null,
			westSouth: null
		}, //26
		{
			position: {
				x: 521,
				y: 1044
			},
			eastNorth: 84,
			eastSouth: 82,
			westNorth: 81,
			westSouth: null
		}, //27
		{
			position: {
				x: 710,
				y: 935
			},
			eastNorth: 87,
			eastSouth: 85,
			westNorth: 107,
			westSouth: 84
		}, //28
		{
			position: {
				x: 897,
				y: 1044
			},
			eastNorth: null,
			eastSouth: 106,
			westNorth: 85,
			westSouth: 86
		}, //29
		{
			position: {
				x: 708,
				y: 1153
			},
			eastNorth: 86,
			eastSouth: null,
			westNorth: 82,
			westSouth: null
		}, //30
		{
			position: {
				x: 396,
				y: 1152
			},
			eastNorth: null,
			eastSouth: null,
			westNorth: 78,
			westSouth: 79
		}, //31
		{
			position: {
				x: 242,
				y: 1243
			},
			eastNorth: 79,
			eastSouth: 2,
			westNorth: null,
			westSouth: null
		}, //32
		{
			position: {
				x: 1347,
				y: 294
			},
			eastNorth: null,
			eastSouth: 50,
			westNorth: 51,
			westSouth: 52
		}, //33
		{
			position: {
				x: 1395,
				y: 321
			},
			eastNorth: 49,
			eastSouth: 54,
			westNorth: 50,
			westSouth: null
		}, //34
		{
			position: {
				x: 1628,
				y: 130
			},
			eastNorth: null,
			eastSouth: 46,
			westNorth: 47,
			westSouth: 48
		}, //35
		{
			position: {
				x: 1678,
				y: 158
			},
			eastNorth: null,
			eastSouth: 45,
			westNorth: 46,
			westSouth: null
		}, //36
		{
			position: {
				x: 2208,
				y: 466
			},
			eastNorth: 43,
			eastSouth: null,
			westNorth: 45,
			westSouth: 44
		}, //37
		{
			position: {
				x: 2394,
				y: 357
			},
			eastNorth: 38,
			eastSouth: 35,
			westNorth: null,
			westSouth: 43
		}, //38
		{
			position: {
				x: 2442,
				y: 329
			},
			eastNorth: null,
			eastSouth: null,
			westNorth: 36,
			westSouth: 38
		}, //39
		{
			position: {
				x: 2580,
				y: 464
			},
			eastNorth: 39,
			eastSouth: 33,
			westNorth: null,
			westSouth: 42
		}, //40
		{
			position: {
				x: 2628,
				y: 438
			},
			eastNorth: null,
			eastSouth: null,
			westNorth: 34,
			westSouth: 39
		}, //41
		{
			position: {
				x: 2925,
				y: 665
			},
			eastNorth: 40,
			eastSouth: 31,
			westNorth: null,
			westSouth: 41
		}, //42
		{
			position: {
				x: 2973,
				y: 637
			},
			eastNorth: null,
			eastSouth: null,
			westNorth: 32,
			westSouth: 40
		}, //43
		{
			position: {
				x: 2457,
				y: 936
			},
			eastNorth: 41,
			eastSouth: null,
			westNorth: 59,
			westSouth: null
		}, //44
		{
			position: {
				x: 3423,
				y: 953
			},
			eastNorth: null,
			eastSouth: 19,
			westNorth: null,
			westSouth: 17
		}, //45
		{
			position: {
				x: 3471,
				y: 926
			},
			eastNorth: null,
			eastSouth: null,
			westNorth: 30,
			westSouth: 21
		}, //46
		{
			position: {
				x: 3471,
				y: 981
			},
			eastNorth: 20,
			eastSouth: null,
			westNorth: 19,
			westSouth: null
		}, //47
		{
			position: {
				x: 3518,
				y: 953
			},
			eastNorth: 24,
			eastSouth: null,
			westNorth: 22,
			westSouth: null
		}, //48
		{
			position: {
				x: 2613,
				y: 1424
			},
			eastNorth: null,
			eastSouth: 16,
			westNorth: 15,
			westSouth: 28
		}, //49
		{
			position: {
				x: 2662,
				y: 1452
			},
			eastNorth: 18,
			eastSouth: 27,
			westNorth: 16,
			westSouth: null
		}, //50
		{
			position: {
				x: 1718,
				y: -91
			},
			eastNorth: null,
			eastSouth: null,
			westNorth: 88,
			westSouth: null
		}, //51
		{
			position: {
				x: 1622,
				y: -91
			},
			eastNorth: null,
			eastSouth: 37,
			westNorth: 89,
			westSouth: null
		}, //52
		{
			position: {
				x: 1247,
				y: -91
			},
			eastNorth: null,
			eastSouth: 47,
			westNorth: 90,
			westSouth: null
		}, //53
		{
			position: {
				x: 682,
				y: -91
			},
			eastNorth: 90,
			eastSouth: 51,
			westNorth: 91,
			westSouth: null
		}, //54
		{
			position: {
				x: -91,
				y: -91
			},
			eastNorth: 91,
			eastSouth: null,
			westNorth: null,
			westSouth: 92
		}, //55
		{
			position: {
				x: -91,
				y: 75
			},
			eastNorth: null,
			eastSouth: 83,
			westNorth: 92,
			westSouth: 93
		}, //56
		{
			position: {
				x: -91,
				y: 472
			},
			eastNorth: null,
			eastSouth: 73,
			westNorth: 93,
			westSouth: 94
		}, //57
		{
			position: {
				x: -91,
				y: 1130
			},
			eastNorth: null,
			eastSouth: null,
			westNorth: null,
			westSouth: 94
		}, //58
		{
			position: {
				x: -91,
				y: 1186
			},
			eastNorth: 76,
			eastSouth: null,
			westNorth: null,
			westSouth: 95
		}, //59
		{
			position: {
				x: -91,
				y: 2250
			},
			eastNorth: null,
			eastSouth: 96,
			westNorth: 95,
			westSouth: null
		}, //60
		{
			position: {
				x: 1190,
				y: 2250
			},
			eastNorth: null,
			eastSouth: 97,
			westNorth: null,
			westSouth: 95
		}, //61
		{
			position: {
				x: 1286,
				y: 2250
			},
			eastNorth: 29,
			eastSouth: 98,
			westNorth: null,
			westSouth: 97
		}, //62
		{
			position: {
				x: 4040,
				y: 2250
			},
			eastNorth: null,
			eastSouth: 99,
			westNorth: 27,
			westSouth: 98
		}, //63
		{
			position: {
				x: 4182,
				y: 2250
			},
			eastNorth: 100,
			eastSouth: null,
			westNorth: null,
			westSouth: 99
		}, //64
		{
			position: {
				x: 4182,
				y: 1400
			},
			eastNorth: 101,
			eastSouth: 100,
			westNorth: null,
			westSouth: null
		}, //65
		{
			position: {
				x: 4182,
				y: 1336
			},
			eastNorth: 102,
			eastSouth: 101,
			westNorth: 25,
			westSouth: null
		}, //66
		{
			position: {
				x: 4182,
				y: 566
			},
			eastNorth: 103,
			eastSouth: 102,
			westNorth: null,
			westSouth: null
		}, //67
		{
			position: {
				x: 4182,
				y: 510
			},
			eastNorth: null,
			eastSouth: 103,
			westNorth: null,
			westSouth: 23
		}, //68
	];

	this.roads = [{}, //0
		{
			s1: 1,
			s2: 2,
			carsToFirst: [],
			carsToSecond: []
		}, //1
		{
			s1: 1,
			s2: 32,
			carsToFirst: [],
			carsToSecond: []
		}, //2
		{
			s1: 3,
			s2: 2,
			carsToFirst: [],
			carsToSecond: []
		}, //3
		{
			s1: 5,
			s2: 2,
			carsToFirst: [],
			carsToSecond: []
		}, //4
		{
			s1: 5,
			s2: 4,
			carsToFirst: [],
			carsToSecond: []
		}, //5
		{
			s1: 3,
			s2: 4,
			carsToFirst: [],
			carsToSecond: []
		}, //6
		{
			s1: 4,
			s2: 8,
			carsToFirst: [],
			carsToSecond: []
		}, //7
		{
			s1: 8,
			s2: 7,
			carsToFirst: [],
			carsToSecond: []
		}, //8
		{
			s1: 7,
			s2: 6,
			carsToFirst: [],
			carsToSecond: []
		}, //9
		{
			s1: 5,
			s2: 6,
			carsToFirst: [],
			carsToSecond: []
		}, //10
		{
			s1: 8,
			s2: 10,
			carsToFirst: [],
			carsToSecond: []
		}, //11
		{
			s1: 9,
			s2: 7,
			carsToFirst: [],
			carsToSecond: []
		}, //12
		{
			s1: 6,
			s2: 14,
			carsToFirst: [],
			carsToSecond: []
		}, //13
		{
			s1: 9,
			s2: 10,
			carsToFirst: [],
			carsToSecond: []
		}, //14
		{
			s1: 10,
			s2: 49,
			carsToFirst: [],
			carsToSecond: []
		}, //15
		{
			s1: 50,
			s2: 49,
			carsToFirst: [],
			carsToSecond: []
		}, //16
		{
			s1: 49,
			s2: 45,
			carsToFirst: [],
			carsToSecond: []
		}, //17
		{
			s1: 50,
			s2: 47,
			carsToFirst: [],
			carsToSecond: []
		}, //18
		{
			s1: 45,
			s2: 47,
			carsToFirst: [],
			carsToSecond: []
		}, //19
		{
			s1: 47,
			s2: 48,
			carsToFirst: [],
			carsToSecond: []
		}, //20
		{
			s1: 45,
			s2: 46,
			carsToFirst: [],
			carsToSecond: []
		}, //21
		{
			s1: 46,
			s2: 48,
			carsToFirst: [],
			carsToSecond: []
		}, //22
		{
			s1: 46,
			s2: 68,
			carsToFirst: [],
			carsToSecond: []
		}, //23
		{
			s1: 48,
			s2: 67,
			carsToFirst: [],
			carsToSecond: []
		}, //24
		{
			s1: 48,
			s2: 66,
			carsToFirst: [],
			carsToSecond: []
		}, //25
		{
			s1: 47,
			s2: 65,
			carsToFirst: [],
			carsToSecond: []
		}, //26
		{
			s1: 50,
			s2: 63,
			carsToFirst: [],
			carsToSecond: []
		}, //27
		{
			s1: 61,
			s2: 49,
			carsToFirst: [],
			carsToSecond: []
		}, //28
		{
			s1: 50,
			s2: 62,
			carsToFirst: [],
			carsToSecond: []
		}, //29
		{
			s1: 43,
			s2: 46,
			carsToFirst: [],
			carsToSecond: []
		}, //30
		{
			s1: 42,
			s2: 45,
			carsToFirst: [],
			carsToSecond: []
		}, //31
		{
			s1: 41,
			s2: 43,
			carsToFirst: [],
			carsToSecond: []
		}, //32
		{
			s1: 40,
			s2: 42,
			carsToFirst: [],
			carsToSecond: []
		}, //33
		{
			s1: 39,
			s2: 41,
			carsToFirst: [],
			carsToSecond: []
		}, //34
		{
			s1: 38,
			s2: 40,
			carsToFirst: [],
			carsToSecond: []
		}, //35
		{
			s1: 39,
			s2: 51,
			carsToFirst: [],
			carsToSecond: []
		}, //36
		{
			s1: 38,
			s2: 52,
			carsToFirst: [],
			carsToSecond: []
		}, //37
		{
			s1: 38,
			s2: 39,
			carsToFirst: [],
			carsToSecond: []
		}, //38
		{
			s1: 40,
			s2: 41,
			carsToFirst: [],
			carsToSecond: []
		}, //39
		{
			s1: 42,
			s2: 43,
			carsToFirst: [],
			carsToSecond: []
		}, //40
		{
			s1: 42,
			s2: 44,
			carsToFirst: [],
			carsToSecond: []
		}, //41
		{
			s1: 12,
			s2: 40,
			carsToFirst: [],
			carsToSecond: []
		}, //42
		{
			s1: 37,
			s2: 38,
			carsToFirst: [],
			carsToSecond: []
		}, //43
		{
			s1: 37,
			s2: 16,
			carsToFirst: [],
			carsToSecond: []
		}, //44
		{
			s1: 36,
			s2: 37,
			carsToFirst: [],
			carsToSecond: []
		}, //45
		{
			s1: 35,
			s2: 36,
			carsToFirst: [],
			carsToSecond: []
		}, //46
		{
			s1: 35,
			s2: 53,
			carsToFirst: [],
			carsToSecond: []
		}, //47
		{
			s1: 35,
			s2: 33,
			carsToFirst: [],
			carsToSecond: []
		}, //48
		{
			s1: 34,
			s2: 36,
			carsToFirst: [],
			carsToSecond: []
		}, //49
		{
			s1: 34,
			s2: 33,
			carsToFirst: [],
			carsToSecond: []
		}, //50
		{
			s1: 54,
			s2: 33,
			carsToFirst: [],
			carsToSecond: []
		}, //51
		{
			s1: 21,
			s2: 33,
			carsToFirst: [],
			carsToSecond: []
		}, //52
		{
			s1: 20,
			s2: 34,
			carsToFirst: [],
			carsToSecond: []
		}, //53
		{
			s1: 17,
			s2: 34,
			carsToFirst: [],
			carsToSecond: []
		}, //54
		{
			s1: 17,
			s2: 16,
			carsToFirst: [],
			carsToSecond: []
		}, //55
		{
			s1: 15,
			s2: 16,
			carsToFirst: [],
			carsToSecond: []
		}, //56
		{
			s1: 15,
			s2: 12,
			carsToFirst: [],
			carsToSecond: []
		}, //57
		{
			s1: 11,
			s2: 12,
			carsToFirst: [],
			carsToSecond: []
		}, //58
		{
			s1: 11,
			s2: 44,
			carsToFirst: [],
			carsToSecond: []
		}, //59
		{
			s1: 11,
			s2: 10,
			carsToFirst: [],
			carsToSecond: []
		}, //60
		{
			s1: 12,
			s2: 13,
			carsToFirst: [],
			carsToSecond: []
		}, //61
		{
			s1: 9,
			s2: 13,
			carsToFirst: [],
			carsToSecond: []
		}, //62
		{
			s1: 14,
			s2: 13,
			carsToFirst: [],
			carsToSecond: []
		}, //63
		{
			s1: 14,
			s2: 15,
			carsToFirst: [],
			carsToSecond: []
		}, //64
		{
			s1: 18,
			s2: 17,
			carsToFirst: [],
			carsToSecond: []
		}, //65
		{
			s1: 18,
			s2: 6,
			carsToFirst: [],
			carsToSecond: []
		}, //66
		{
			s1: 18,
			s2: 19,
			carsToFirst: [],
			carsToSecond: []
		}, //67
		{
			s1: 20,
			s2: 19,
			carsToFirst: [],
			carsToSecond: []
		}, //68
		{
			s1: 21,
			s2: 22,
			carsToFirst: [],
			carsToSecond: []
		}, //69
		{
			s1: 20,
			s2: 23,
			carsToFirst: [],
			carsToSecond: []
		}, //70
		{
			s1: 20,
			s2: 21,
			carsToFirst: [],
			carsToSecond: []
		}, //71
		{
			s1: 23,
			s2: 22,
			carsToFirst: [],
			carsToSecond: []
		}, //72
		{
			s1: 57,
			s2: 22,
			carsToFirst: [],
			carsToSecond: []
		}, //73
		{
			s1: 23,
			s2: 22,
			carsToFirst: [],
			carsToSecond: []
		}, //74.............
		{
			s1: 58,
			s2: 25,
			carsToFirst: [],
			carsToSecond: []
		}, //75
		{
			s1: 59,
			s2: 26,
			carsToFirst: [],
			carsToSecond: []
		}, //76
		{
			s1: 24,
			s2: 26,
			carsToFirst: [],
			carsToSecond: []
		}, //77
		{
			s1: 26,
			s2: 31,
			carsToFirst: [],
			carsToSecond: []
		}, //78
		{
			s1: 32,
			s2: 31,
			carsToFirst: [],
			carsToSecond: []
		}, //79
		{
			s1: 24,
			s2: 25,
			carsToFirst: [],
			carsToSecond: []
		}, //80
		{
			s1: 24,
			s2: 27,
			carsToFirst: [],
			carsToSecond: []
		}, //81
		{
			s1: 30,
			s2: 27,
			carsToFirst: [],
			carsToSecond: []
		}, //82
		{
			s1: 56,
			s2: 21,
			carsToFirst: [],
			carsToSecond: []
		}, //83
		{
			s1: 28,
			s2: 27,
			carsToFirst: [],
			carsToSecond: []
		}, //84
		{
			s1: 28,
			s2: 29,
			carsToFirst: [],
			carsToSecond: []
		}, //85
		{
			s1: 30,
			s2: 29,
			carsToFirst: [],
			carsToSecond: []
		}, //86
		{
			s1: 28,
			s2: 19,
			carsToFirst: [],
			carsToSecond: []
		}, //87
		{
			s1: 51,
			s2: 52,
			carsToFirst: [],
			carsToSecond: []
		}, //88
		{
			s1: 52,
			s2: 53,
			carsToFirst: [],
			carsToSecond: []
		}, //89
		{
			s1: 53,
			s2: 54,
			carsToFirst: [],
			carsToSecond: []
		}, //90
		{
			s1: 55,
			s2: 54,
			carsToFirst: [],
			carsToSecond: []
		}, //91
		{
			s1: 55,
			s2: 56,
			carsToFirst: [],
			carsToSecond: []
		}, //92
		{
			s1: 57,
			s2: 56,
			carsToFirst: [],
			carsToSecond: []
		}, //93
		{
			s1: 57,
			s2: 58,
			carsToFirst: [],
			carsToSecond: []
		}, //94
		{
			s1: 60,
			s2: 59,
			carsToFirst: [],
			carsToSecond: []
		}, //95
		{
			s1: 60,
			s2: 61,
			carsToFirst: [],
			carsToSecond: []
		}, //96
		{
			s1: 62,
			s2: 61,
			carsToFirst: [],
			carsToSecond: []
		}, //97
		{
			s1: 62,
			s2: 63,
			carsToFirst: [],
			carsToSecond: []
		}, //98
		{
			s1: 64,
			s2: 63,
			carsToFirst: [],
			carsToSecond: []
		}, //99
		{
			s1: 64,
			s2: 65,
			carsToFirst: [],
			carsToSecond: []
		}, //100
		{
			s1: 65,
			s2: 66,
			carsToFirst: [],
			carsToSecond: []
		}, //101
		{
			s1: 67,
			s2: 66,
			carsToFirst: [],
			carsToSecond: []
		}, //102
		{
			s1: 67,
			s2: 68,
			carsToFirst: [],
			carsToSecond: []
		}, //103
		{
			s1: 24,
			s2: 23,
			carsToFirst: [],
			carsToSecond: []
		}, //104
		{
			s1: 25,
			s2: 22,
			carsToFirst: [],
			carsToSecond: []
		}, //105
		{
			s1: 29,
			s2: 5,
			carsToFirst: [],
			carsToSecond: []
		}, //106
		{
			s1: 23,
			s2: 28,
			carsToFirst: [],
			carsToSecond: []
		}, //107

	];

	this.availableRoads = [];
	for (a = 1; a < this.roads.length; a++) {
		if (a == 74)
			continue;
		this.availableRoads.push(a);
	}
	this.lastCrossroad = 0;
	this.pedestrianCrossingOffset = 30;
	this.roadCount = this.roads.length; //67
	this.crossroadOffset = 57;
	this.g = null;
	this.s = null;
	this.numerOfNewElements = 0;

	var traffic = this;
	setInterval(function() {
		var currDate = new Date();
		for (var i = 0; i < traffic.crossroads.length; i++) {
			var carsOnCrossroad = traffic.getCarsOnCrossroadWaiting(i);
			for (var j = 0; j < carsOnCrossroad.length; j++) {
				if ((currDate - traffic.cars[carsOnCrossroad[j]].waitingStartTime) > 2000 && traffic.wakeWaitingCarIfPossible(carsOnCrossroad[j], j, carsOnCrossroad)) {
					traffic.cars[carsOnCrossroad[j]].changeDirection();
					//console.log(carsOnCrossroad[j]);
					continue;
				}
			}
			//traffic.wakeRandomWaitingCar(i);
		}
	}, 2000);
}

Traffic.prototype.reorientCar = function(car, roadId) {
	roadId %= this.roads.length;
	var crossroadPosition;
	if (car.goesToSecondCrossroad) {
		crossroadPosition = this.crossroads[this.roads[roadId].s1].position;
	} else {
		crossroadPosition = this.crossroads[this.roads[roadId].s2].position;
	}

	var carPosition = {
		x: car.bitmap.x,
		y: car.bitmap.y
	};

	var orientation = this.orientationFromPoints(crossroadPosition, carPosition);

	if (orientation == "northWest") {
		car.bitmap.x += car.northWestOffset.x;
		car.bitmap.y += car.northWestOffset.y;
	} else if (orientation == "southEast") {
		car.bitmap.x += car.southEastOffset.x;
		car.bitmap.y += car.southEastOffset.y;
	} else if (orientation == "northEast") {
		car.bitmap.x += car.northEastOffset.x;
		car.bitmap.y += car.northEastOffset.y;
	} else if (orientation == "southWest") {
		car.bitmap.x += car.southWestOffset.x;
		car.bitmap.y += car.southWestOffset.y;
	}

	car.bitmap.gotoAndPlay(orientation);
}

Traffic.prototype.orientationFromPoints = function(firstPoint, secondPoint) {
	var oriantation = "";

	if (firstPoint.x >= secondPoint.x && firstPoint.y >= secondPoint.y) {
		oriantation = "northWest";
	} else if (firstPoint.x <= secondPoint.x && firstPoint.y <= secondPoint.y) {
		oriantation = "southEast";
	} else if (firstPoint.x <= secondPoint.x && firstPoint.y >= secondPoint.y) {
		oriantation = "northEast";
	} else if (firstPoint.x >= secondPoint.x && firstPoint.y <= secondPoint.y) {
		oriantation = "southWest";
	}

	return oriantation;
}

Traffic.prototype.addCar = function(car) {

	this.cars.push(car);
	if (this.lastCrossroad > this.roads.length)
		car.goesToSecondCrossroad = false;
	else
		car.goesToSecondCrossroad = true;

	//if(this.lastCrossroad%this.availableRoads.length==1)
	//	this.lastCrossroad++;

	car.bitmap.x = (this.crossroads[this.roads[this.availableRoads[this.lastCrossroad % this.availableRoads.length]].s1].position.x + this.crossroads[this.roads[this.availableRoads[this.lastCrossroad % this.availableRoads.length]].s2].position.x) / 2;
	car.bitmap.y = (this.crossroads[this.roads[this.availableRoads[this.lastCrossroad % this.availableRoads.length]].s1].position.y + this.crossroads[this.roads[this.availableRoads[this.lastCrossroad % this.availableRoads.length]].s2].position.y) / 2;
	//console.log(car.bitmap.x+" "+car.bitmap.y);
	if (car.goesToSecondCrossroad)
		this.roads[this.availableRoads[this.lastCrossroad % this.availableRoads.length]].carsToSecond.push(this.cars.length - 1);
	else
		this.roads[this.availableRoads[this.lastCrossroad % this.availableRoads.length]].carsToFirst.push(this.cars.length - 1);

	this.reorientCar(car, this.availableRoads[this.lastCrossroad % this.availableRoads.length], this.cars.length - 1);

	this.lastCrossroad++;
}

Traffic.prototype.handleTraffic = function() {
	var logString = "";
	for (var i = 1; i < this.roads.length; i++) {
		if (i == 74 || this.crossroads[this.roads[i].s1] == undefined || this.crossroads[this.roads[i].s2] == undefined || this.crossroads[this.roads[i].s1].position == undefined || this.crossroads[this.roads[i].s2].position == undefined)
			continue;

		//crossroads positions
		var firstCrossroadPosition = this.crossroads[this.roads[i].s1].position;
		var secondCrossroadPosition = this.crossroads[this.roads[i].s2].position;
		var firstCrossroadPositionVector = new Vector([firstCrossroadPosition.x, firstCrossroadPosition.y]);
		var secondCrossroadPositionVector = new Vector([secondCrossroadPosition.x, secondCrossroadPosition.y]);

		//calculating translation (speed) vector for car
		var translationVector = secondCrossroadPositionVector.subtract(firstCrossroadPositionVector);
		translationVector.normalize();
		translationVector = translationVector.multiply(new Vector([3, 3]));

		//out of map
		if (i >= 88 && i <= 103)
			translationVector = translationVector.multiply(new Vector([50, 50]));

		var j = 0;

		//for each car going to second crossroad
		for (j = 0; j < this.roads[i].carsToSecond.length; j++) {
			var vehiclePosition = this.cars[this.roads[i].carsToSecond[j]].getOriginalPosition();

			var crossroadIndex = this.roads[i].s2;

			vehicleCrossroadSegment = secondCrossroadPositionVector.subtract(new Vector([vehiclePosition.x, vehiclePosition.y]));
			vehicleCrossroadSegmentOpposite = vehicleCrossroadSegment.multiply(new Vector([-1, -1]));
			vehicleCrossroadSegmentOpposite.normalize();
			vehicleCrossroadSegmentOpposite = vehicleCrossroadSegmentOpposite.multiply(new Vector([this.crossroadOffset, this.crossroadOffset]));

			var crosswalkPositionVector = secondCrossroadPositionVector.add(vehicleCrossroadSegmentOpposite);
			var vehicleCrosswalkSegment = crosswalkPositionVector.subtract(new Vector([vehiclePosition.x, vehiclePosition.y]));

			var newDistanceToSource = vehicleCrossroadSegment.magnitude();
			var newDistanceToCrossing = vehicleCrosswalkSegment.magnitude();

			var carsOnCrossroad = this.getCarsOnCrossroad(this.roads[i].s2);
			var carsOnCrossroadWaiting = this.getCarsOnCrossroadWaiting(this.roads[i].s2);

			//current car is on crossroad
			var isOnCrossroad = $.inArray(this.roads[i].carsToSecond[j], carsOnCrossroad) != -1;

			//entering the crossroad
			if ( /*newDistanceToCrossing > this.cars[this.roads[i].carsToSecond[j]].distanceToCrossing && */ isOnCrossroad && !this.cars[this.roads[i].carsToSecond[j]].isOnCrossroad) {
				this.cars[this.roads[i].carsToSecond[j]].currentCrossroadId = this.roads[i].s2;
				this.cars[this.roads[i].carsToSecond[j]].chooseRandomDirection();
				if (!this.isCrossroadCorner(this.roads[i].s2)) {
					this.cars[this.roads[i].carsToSecond[j]].isWaiting = true;
					this.cars[this.roads[i].carsToSecond[j]].waitingStartTime = new Date();
				}
			}

			//this.carDebug(this.roads[i].carsToSecond[j]);
			this.cars[this.roads[i].carsToSecond[j]].isOnCrossroad = isOnCrossroad;

			if (this.cars[this.roads[i].carsToSecond[j]].isWaiting)
				continue;

			//vehicle reached the end of street
			if (newDistanceToSource > this.cars[this.roads[i].carsToSecond[j]].distanceToSource) {
				var carId = this.roads[i].carsToSecond[0];

				if (this.changeRoad(i, carId, crossroadIndex))
					this.roads[i].carsToSecond.shift();

				continue;
			}

			this.cars[this.roads[i].carsToSecond[j]].distanceToSource = vehicleCrossroadSegment.magnitude();
			this.cars[this.roads[i].carsToSecond[j]].distanceToCrossing = vehicleCrosswalkSegment.magnitude();

			//check if there's space between current car and next car
			if (j > 0) {
				var previousCarPosition = this.cars[this.roads[i].carsToSecond[j - 1]].getOriginalPosition();
				var currentCarPosition = this.cars[this.roads[i].carsToSecond[j]].getOriginalPosition();
				var carDistanceVector = new Vector([previousCarPosition.x, previousCarPosition.y]);
				carDistanceVector = carDistanceVector.subtract(new Vector([currentCarPosition.x, currentCarPosition.y]));
				var carDistance = carDistanceVector.magnitude();

				if (carDistance > this.cars[this.roads[i].carsToSecond[j - 1]].length + 10) {
					this.cars[this.roads[i].carsToSecond[j]].translate(translationVector);
				}
			} else {
				this.cars[this.roads[i].carsToSecond[j]].translate(translationVector);
			}
			if (logString.length > 1)
				logString += "<br>";


		}

		translationVector = translationVector.multiply(new Vector([-1, -1]));

		//for each car going to first crossroad
		for (j = 0; j < this.roads[i].carsToFirst.length; j++) {
			var vehiclePosition = this.cars[this.roads[i].carsToFirst[j]].getOriginalPosition();

			var crossroadIndex = this.roads[i].s1;

			vehicleCrossroadSegment = firstCrossroadPositionVector.subtract(new Vector([vehiclePosition.x, vehiclePosition.y]));
			vehicleCrossroadSegmentOpposite = vehicleCrossroadSegment.multiply(new Vector([-1, -1]));
			vehicleCrossroadSegmentOpposite.normalize();
			vehicleCrossroadSegmentOpposite = vehicleCrossroadSegmentOpposite.multiply(new Vector([this.crossroadOffset, this.crossroadOffset]));

			var crosswalkPositionVector = firstCrossroadPositionVector.add(vehicleCrossroadSegmentOpposite);
			var vehicleCrosswalkSegment = crosswalkPositionVector.subtract(new Vector([vehiclePosition.x, vehiclePosition.y]));

			var newDistanceToSource = vehicleCrossroadSegment.magnitude();
			var newDistanceToCrossing = vehicleCrosswalkSegment.magnitude();

			var carsOnCrossroad = this.getCarsOnCrossroad(this.roads[i].s1);
			var carsOnCrossroadWaiting = this.getCarsOnCrossroadWaiting(this.roads[i].s1);

			var isOnCrossroad = $.inArray(this.roads[i].carsToFirst[j], carsOnCrossroad) != -1;

			if ( /*newDistanceToCrossing > this.cars[this.roads[i].carsToFirst[j]].distanceToCrossing && */ isOnCrossroad && !this.cars[this.roads[i].carsToFirst[j]].isOnCrossroad) {
				this.cars[this.roads[i].carsToFirst[j]].currentCrossroadId = this.roads[i].s1;
				this.cars[this.roads[i].carsToFirst[j]].chooseRandomDirection();
				if (!this.isCrossroadCorner(this.roads[i].s1)) {
					this.cars[this.roads[i].carsToFirst[j]].isWaiting = true;
					this.cars[this.roads[i].carsToFirst[j]].waitingStartTime = new Date();
				}
			}

			this.cars[this.roads[i].carsToFirst[j]].isOnCrossroad = isOnCrossroad;

			//this.carDebug(this.roads[i].carsToFirst[j]);

			if (this.cars[this.roads[i].carsToFirst[j]].isWaiting)
				continue;

			//vehicle reached the end of street
			if (newDistanceToSource > this.cars[this.roads[i].carsToFirst[j]].distanceToSource) {
				var carId = this.roads[i].carsToFirst[0];

				if (this.changeRoad(i, carId, crossroadIndex))
					this.roads[i].carsToFirst.shift();

				continue;
			}

			this.cars[this.roads[i].carsToFirst[j]].distanceToSource = vehicleCrossroadSegment.magnitude();
			this.cars[this.roads[i].carsToFirst[j]].distanceToCrossing = vehicleCrosswalkSegment.magnitude();

			//check if there's space between current car and next car
			if (j > 0) {
				var previousCarPosition = this.cars[this.roads[i].carsToFirst[j - 1]].getOriginalPosition();
				var currentCarPosition = this.cars[this.roads[i].carsToFirst[j]].getOriginalPosition();
				var carDistanceVector = new Vector([previousCarPosition.x, previousCarPosition.y]);
				carDistanceVector = carDistanceVector.subtract(new Vector([currentCarPosition.x, currentCarPosition.y]));
				var carDistance = carDistanceVector.magnitude();

				if (carDistance > this.cars[this.roads[i].carsToFirst[j - 1]].length + 10) {
					this.cars[this.roads[i].carsToFirst[j]].translate(translationVector);
				}
			} else {
				this.cars[this.roads[i].carsToFirst[j]].translate(translationVector);
			}
			if (logString.length > 1)
				logString += "<br>";
		}
	}

	for (j = 1; j < this.crossroads.length; j++) {
		var carsOnCrossroad = this.getCarsOnCrossroad(j);
		var carsOnCrossroadWaiting = this.getCarsOnCrossroadWaiting(j);
		if (carsOnCrossroadWaiting.length == carsOnCrossroad.length) {
			this.wakeRandomWaitingCar(j);
		}
		for (var a = 0; a < carsOnCrossroadWaiting.length; a++) {
			this.wakeWaitingCarIfPossible(carsOnCrossroadWaiting[a], j, carsOnCrossroad);
		}
	}

	var carsOnCrossroad = this.getCarsOnCrossroad(5);
	var carsOnCrossroadWaiting = this.getCarsOnCrossroadWaiting(5);
	logString = "";
	for (a = 0; a < carsOnCrossroad.length; a++) {
		logString += this.cars[carsOnCrossroad[a]].name + " ";
	}
	logString += "<br />";
	for (a = 0; a < carsOnCrossroadWaiting.length; a++) {
		logString += this.cars[carsOnCrossroad[a]].name + " ";
	}
	$(".infoBox").html(logString);
	logString = "";
}

$(document).ready(function() {

	//$('<div style="position: fixed; top:100px; left: 100px; z-index:9999; background-color:white; padding:10px;" class="infoBox"> TEST</div>').appendTo( "body" );/
});

Traffic.prototype.getPossibleRoads = function(crossroadId, currentRoadId) {
	var firstRoad = this.crossroads[crossroadId].eastNorth;
	var secondRoad = this.crossroads[crossroadId].eastSouth;
	var thirdRoad = this.crossroads[crossroadId].westNorth;
	var fourthRoad = this.crossroads[crossroadId].westSouth;

	var possibleRoads = [];

	if (!(firstRoad == currentRoadId || firstRoad == null))
		possibleRoads.push(firstRoad);
	if (!(secondRoad == currentRoadId || secondRoad == null))
		possibleRoads.push(secondRoad);
	if (!(thirdRoad == currentRoadId || thirdRoad == null))
		possibleRoads.push(thirdRoad);
	if (!(fourthRoad == currentRoadId || fourthRoad == null))
		possibleRoads.push(fourthRoad);

	return possibleRoads;
}

Traffic.prototype.changeRoad = function(currentRoadId, carId, crossroadIndex) {
	var randomRoad;

	if (this.cars[carId].currentCrossroad == null) {
		this.cars[carId].currentCrossroadId = crossroadIndex;
		this.cars[carId].chooseRandomDirection();
	}

	var turnSignal = this.cars[carId].turnSignal;
	if (turnSignal == "southWest")
		randomRoad = this.crossroads[crossroadIndex].westSouth;
	if (turnSignal == "southEast")
		randomRoad = this.crossroads[crossroadIndex].eastSouth;
	if (turnSignal == "northWest")
		randomRoad = this.crossroads[crossroadIndex].westNorth;
	if (turnSignal == "northEast")
		randomRoad = this.crossroads[crossroadIndex].eastNorth;

	if (this.roads[randomRoad] == undefined) {
		return true;
	}

	if (this.roads[randomRoad].s1 == crossroadIndex) {
		if (this.roads[randomRoad].carsToSecond.length > 0) {
			var lastCarPosition = this.cars[this.roads[randomRoad].carsToSecond[this.roads[randomRoad].carsToSecond.length - 1]].getOriginalPosition();
			var lastCarDistanceFromCrossroadVector = new Vector([lastCarPosition.x - this.crossroads[this.roads[randomRoad].s1].position.x, lastCarPosition.y - this.crossroads[this.roads[randomRoad].s1].position.y]);
			var lastCarDistanceFromCrossroad = lastCarDistanceFromCrossroadVector.magnitude();
			if (lastCarDistanceFromCrossroad - this.cars[this.roads[randomRoad].carsToSecond[this.roads[randomRoad].carsToSecond.length - 1]].length < this.cars[carId].length) {
				return false;
			}
		}

		this.roads[randomRoad].carsToSecond.push(carId);

		if (!this.cars[carId].goesToSecondCrossroad)
			this.cars[carId].goesToSecondCrossroad = true;

		var currentOrientation = this.orientationFromPoints(this.crossroads[this.roads[randomRoad].s1].position, this.crossroads[this.roads[randomRoad].s2].position);


		if (currentOrientation != this.cars[carId].bitmap.currentAnimation || currentRoadId >= 88 && currentRoadId <= 103) {
			this.cars[carId].bitmap.x = this.crossroads[this.roads[randomRoad].s1].position.x;
			this.cars[carId].bitmap.y = this.crossroads[this.roads[randomRoad].s1].position.y;
			//this.cars[carId].setPosition({x:this.crossroads[this.roads[randomRoad].s1].position.x,y:this.crossroads[this.roads[randomRoad].s1].position.y});
			var translationVector = new Vector([this.crossroads[this.roads[randomRoad].s2].position.x, this.crossroads[this.roads[randomRoad].s2].position.y]);
			translationVector = translationVector.subtract(new Vector([this.crossroads[this.roads[randomRoad].s1].position.x, this.crossroads[this.roads[randomRoad].s1].position.y]));
			translationVector.normalize();
			translationVector = translationVector.multiply(new Vector([this.cars[carId].length, this.cars[carId].length]));
			this.cars[carId].translate(translationVector);
			this.reorientCar(this.cars[carId], randomRoad);
		}

		// fixing car's layers
		if (this.cars[carId].bitmap.currentAnimation == 'southEast' || this.cars[carId].bitmap.currentAnimation == 'northEast') {
			var indexes = [];
			for (var a = 0; a < this.roads[randomRoad].carsToSecond.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToSecond[a]].bitmap, 10);
			}
			for (var a = 0; a < this.roads[randomRoad].carsToFirst.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToFirst[a]].bitmap, 2);
			}
		} else {
			var indexes = [];
			for (var a = 0; a < this.roads[randomRoad].carsToSecond.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToSecond[a]].bitmap, 2);
			}
			for (var a = 0; a < this.roads[randomRoad].carsToFirst.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToFirst[a]].bitmap, 10);
			}
		}
	} else {
		if (this.roads[randomRoad].carsToFirst.length > 0) {
			var lastCarPosition = this.cars[this.roads[randomRoad].carsToFirst[this.roads[randomRoad].carsToFirst.length - 1]].getOriginalPosition();
			var lastCarDistanceFromCrossroadVector = new Vector([lastCarPosition.x - this.crossroads[this.roads[randomRoad].s2].position.x, lastCarPosition.y - this.crossroads[this.roads[randomRoad].s2].position.y]);
			var lastCarDistanceFromCrossroad = lastCarDistanceFromCrossroadVector.magnitude();
			if (lastCarDistanceFromCrossroad - this.cars[this.roads[randomRoad].carsToFirst[this.roads[randomRoad].carsToFirst.length - 1]].length < this.cars[carId].length) {
				return false;
			}
		}

		this.roads[randomRoad].carsToFirst.push(carId);
		if (this.cars[carId].goesToSecondCrossroad)
			this.cars[carId].goesToSecondCrossroad = false;

		var currentOrientation = this.orientationFromPoints(this.crossroads[this.roads[randomRoad].s2].position, this.crossroads[this.roads[randomRoad].s1].position);

		if (currentOrientation != this.cars[carId].bitmap.currentAnimation || currentRoadId >= 88 && currentRoadId <= 103) {
			this.cars[carId].bitmap.x = this.crossroads[this.roads[randomRoad].s2].position.x;
			this.cars[carId].bitmap.y = this.crossroads[this.roads[randomRoad].s2].position.y;
			//this.cars[carId].setPosition({x:this.crossroads[this.roads[randomRoad].s2].position.x,y:this.crossroads[this.roads[randomRoad].s2].position.y});
			var translationVector = new Vector([this.crossroads[this.roads[randomRoad].s1].position.x, this.crossroads[this.roads[randomRoad].s1].position.y]);
			translationVector = translationVector.subtract(new Vector([this.crossroads[this.roads[randomRoad].s2].position.x, this.crossroads[this.roads[randomRoad].s2].position.y]));
			translationVector.normalize();
			translationVector = translationVector.multiply(new Vector([this.cars[carId].length, this.cars[carId].length]));
			this.cars[carId].translate(translationVector);
			this.reorientCar(this.cars[carId], randomRoad);
		}

		// fixing car's layers
		if (this.cars[carId].bitmap.currentAnimation == 'southEast' || this.cars[carId].bitmap.currentAnimation == 'northEast') {
			for (var a = 0; a < this.roads[randomRoad].carsToSecond.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToSecond[a]].bitmap, 2);
			}
			for (var a = 0; a < this.roads[randomRoad].carsToFirst.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToFirst[a]].bitmap, 10);
			}
		} else {
			for (var a = 0; a < this.roads[randomRoad].carsToSecond.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToSecond[a]].bitmap, 10);
			}
			for (var a = 0; a < this.roads[randomRoad].carsToFirst.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToFirst[a]].bitmap, 2);
			}
		}
	}

	this.cars[carId].distanceToSource = Number.MAX_VALUE;
	this.cars[carId].distanceToCrossing = Number.MAX_VALUE;


	for (var i = 0; i < window.game.map.pedestrians.length; i++) {
		window.game.container.setChildIndex(window.game.map.pedestrians[i].bitmap, 10);
	}

	return true;
}

Traffic.prototype.fixCarsLayer = function() {

}

Traffic.prototype.getCarsOnCrossroad = function(crossroadId) {
	var firstRoad = this.roads[this.crossroads[crossroadId].eastNorth];
	var secondRoad = this.roads[this.crossroads[crossroadId].eastSouth];
	var thirdRoad = this.roads[this.crossroads[crossroadId].westNorth];
	var fourthRoad = this.roads[this.crossroads[crossroadId].westSouth];

	var carsOnCrossroad = [];

	//first road
	if (firstRoad != undefined) {
		for (var i = 0; i < firstRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(firstRoad.carsToFirst[i], crossroadId, "eastNorth"))
				carsOnCrossroad.push(firstRoad.carsToFirst[i]);
		}

		for (var i = 0; i < firstRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(firstRoad.carsToSecond[i], crossroadId, "eastNorth"))
				carsOnCrossroad.push(firstRoad.carsToSecond[i]);
		}
	}
	//second road
	if (secondRoad != undefined) {
		for (var i = 0; i < secondRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(secondRoad.carsToFirst[i], crossroadId, "eastSouth"))
				carsOnCrossroad.push(secondRoad.carsToFirst[i]);
		}

		for (var i = 0; i < secondRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(secondRoad.carsToSecond[i], crossroadId, "eastSouth"))
				carsOnCrossroad.push(secondRoad.carsToSecond[i]);
		}
	}

	//third road
	if (thirdRoad != undefined) {
		for (var i = 0; i < thirdRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(thirdRoad.carsToFirst[i], crossroadId, "westNorth"))
				carsOnCrossroad.push(thirdRoad.carsToFirst[i]);
		}

		for (var i = 0; i < thirdRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(thirdRoad.carsToSecond[i], crossroadId, "westNorth"))
				carsOnCrossroad.push(thirdRoad.carsToSecond[i]);
		}
	}

	//fourth road
	if (fourthRoad != undefined) {
		for (var i = 0; i < fourthRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(fourthRoad.carsToFirst[i], crossroadId, "westSouth"))
				carsOnCrossroad.push(fourthRoad.carsToFirst[i]);
		}

		for (var i = 0; i < fourthRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(fourthRoad.carsToSecond[i], crossroadId, "westSouth"))
				carsOnCrossroad.push(fourthRoad.carsToSecond[i]);
		}
	}

	return carsOnCrossroad;
}

Traffic.prototype.wakeRandomWaitingCar = function(crossroadId) {
	var cars = this.getCarsOnCrossroadWaiting(crossroadId);
	var car = this.cars[cars[Math.floor(Math.random() * cars.length)]];
	if (car != undefined)
		car.isWaiting = false;
}

Traffic.prototype.wakeWaitingCarIfPossible = function(carId, crossroadId, carsOnCrossroad) {
	var possible = true;
	var turning = this.cars[carId].getTurning();
	for (var i = 0; i < carsOnCrossroad.length; i++) {
		if (this.cars[carsOnCrossroad[i]].isWaiting)
			continue;
		var secondTurning = this.cars[carsOnCrossroad[i]].turning;

		//if there's car on crossroad which is turning left and driving in different direction
		if (secondTurning == "left" && this.cars[carId].bitmap.currentAnimation != this.cars[carsOnCrossroad[i]].bitmap.currentAnimation) {
			possible = false;
		}

		//if there's car on crossroad which is driving straight but crossing current's line
		if (secondTurning == "straight" && turning == "straight" && this.cars[carsOnCrossroad[i]].turnSignal != this.cars[carId].bitmap.currentAnimation && this.cars[carsOnCrossroad[i]].turnSignal != this.getOppositeDirection(this.cars[carId].bitmap.currentAnimation)) {
			possible = false;
		}

		if (!(turning == "right" && (secondTurning == "right" || secondTurning == "straight")) && !turning == "straight")
			possible = false;

		if (turning == "left")
			possible = false;
	}

	if (possible)
		this.cars[carId].isWaiting = false;

	return possible;
}
Traffic.prototype.getOppositeDirection = function(direction) {
	if (direction == "northWest")
		return "southEast";
	else if (direction == "northEast")
		return "southWest";
	else if (direction == "southWest")
		return "northEast";
	else if (direction == "southEast")
		return "northWest";
}

Traffic.prototype.getCarsOnCrossroadWaiting = function(crossroadId) {
	var firstRoad = this.roads[this.crossroads[crossroadId].eastNorth];
	var secondRoad = this.roads[this.crossroads[crossroadId].eastSouth];
	var thirdRoad = this.roads[this.crossroads[crossroadId].westNorth];
	var fourthRoad = this.roads[this.crossroads[crossroadId].westSouth];

	var carsOnCrossroad = [];

	//first road
	if (firstRoad != undefined) {
		for (var i = 0; i < firstRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(firstRoad.carsToFirst[i], crossroadId, "eastNorth") && this.cars[firstRoad.carsToFirst[i]].isWaiting)
				carsOnCrossroad.push(firstRoad.carsToFirst[i]);
		}

		for (var i = 0; i < firstRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(firstRoad.carsToSecond[i], crossroadId, "eastNorth") && this.cars[firstRoad.carsToSecond[i]].isWaiting)
				carsOnCrossroad.push(firstRoad.carsToSecond[i]);
		}
	}
	//second road
	if (secondRoad != undefined) {
		for (var i = 0; i < secondRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(secondRoad.carsToFirst[i], crossroadId, "eastSouth") && this.cars[secondRoad.carsToFirst[i]].isWaiting)
				carsOnCrossroad.push(secondRoad.carsToFirst[i]);
		}

		for (var i = 0; i < secondRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(secondRoad.carsToSecond[i], crossroadId, "eastSouth") && this.cars[secondRoad.carsToSecond[i]].isWaiting)
				carsOnCrossroad.push(secondRoad.carsToSecond[i]);
		}
	}

	//third road
	if (thirdRoad != undefined) {
		for (var i = 0; i < thirdRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(thirdRoad.carsToFirst[i], crossroadId, "westNorth") && this.cars[thirdRoad.carsToFirst[i]].isWaiting)
				carsOnCrossroad.push(thirdRoad.carsToFirst[i]);
		}

		for (var i = 0; i < thirdRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(thirdRoad.carsToSecond[i], crossroadId, "westNorth") && this.cars[thirdRoad.carsToSecond[i]].isWaiting)
				carsOnCrossroad.push(thirdRoad.carsToSecond[i]);
		}
	}

	//fourth road
	if (fourthRoad != undefined) {
		for (var i = 0; i < fourthRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(fourthRoad.carsToFirst[i], crossroadId, "westSouth") && this.cars[fourthRoad.carsToFirst[i]].isWaiting)
				carsOnCrossroad.push(fourthRoad.carsToFirst[i]);
		}

		for (var i = 0; i < fourthRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(fourthRoad.carsToSecond[i], crossroadId, "westSouth") && this.cars[fourthRoad.carsToSecond[i]].isWaiting)
				carsOnCrossroad.push(fourthRoad.carsToSecond[i]);
		}
	}

	return carsOnCrossroad;
}

Traffic.prototype.carIsOnCrossroad = function(carId, crossroadId, roadOrientation) {
	var frontPosition = this.cars[carId].getOriginalPosition();
	var rearPosition = this.cars[carId].getOriginalRearPosition();

	switch (roadOrientation) {
		case "eastNorth":
			if (this.crossroads[crossroadId].eastNorth != null) {
				var crossingPoint = this.getPointBehindCrossing(crossroadId, "eastNorth");
				if (rearPosition.x < crossingPoint.x && rearPosition.y > crossingPoint.y ||
					frontPosition.x < crossingPoint.x && frontPosition.y > crossingPoint.y)
					return true;
			}
			break;
		case "eastSouth":
			if (this.crossroads[crossroadId].eastSouth != null) {
				var crossingPoint = this.getPointBehindCrossing(crossroadId, "eastSouth");
				if (rearPosition.x < crossingPoint.x && rearPosition.y < crossingPoint.y ||
					frontPosition.x < crossingPoint.x && frontPosition.y < crossingPoint.y)
					return true;
			}
			break;
		case "westNorth":
			if (this.crossroads[crossroadId].westNorth != null) {
				var crossingPoint = this.getPointBehindCrossing(crossroadId, "westNorth");
				if (rearPosition.x > crossingPoint.x && rearPosition.y > crossingPoint.y ||
					frontPosition.x > crossingPoint.x && frontPosition.y > crossingPoint.y)
					return true;
			}
			break;
		case "westSouth":
			if (this.crossroads[crossroadId].westSouth != null) {
				var crossingPoint = this.getPointBehindCrossing(crossroadId, "westSouth");
				if (rearPosition.x > crossingPoint.x && rearPosition.y < crossingPoint.y ||
					frontPosition.x > crossingPoint.x && frontPosition.y < crossingPoint.y)
					return true;
			}
			break;
	}

	return false;
}

Traffic.prototype.getPointBehindCrossing = function(crossroadId, orientation) {
	var firstCrossroadPosition = this.crossroads[crossroadId].position;
	var secondCrossroadPosition = null;

	var secondCrossroadId = this.getNeighborCrossroad(crossroadId, orientation);
	secondCrossroadPosition = this.crossroads[secondCrossroadId].position;

	var firstCrossroadPositionVector = new Vector([firstCrossroadPosition.x, firstCrossroadPosition.y]);
	var secondCrossroadPositionVector = new Vector([secondCrossroadPosition.x, secondCrossroadPosition.y]);
	var translationVector = secondCrossroadPositionVector.subtract(firstCrossroadPositionVector);
	translationVector.normalize();
	translationVector = translationVector.multiply(new Vector([this.crossroadOffset, this.crossroadOffset]));

	var resultPoint = firstCrossroadPositionVector.add(translationVector);

	return {
		x: resultPoint.items[0],
		y: resultPoint.items[1]
	};
}

Traffic.prototype.getNeighborCrossroad = function(crossroadId, orientation) {
	var secondCrossroadId = null;
	var roadId = null;
	switch (orientation) {
		case "eastNorth":
			roadId = this.crossroads[crossroadId].eastNorth;
			break;
		case "westNorth":
			roadId = this.crossroads[crossroadId].westNorth;
			break;
		case "eastSouth":
			roadId = this.crossroads[crossroadId].eastSouth;
			break;
		case "westSouth":
			roadId = this.crossroads[crossroadId].westSouth;
			break;
	}
	//	if(secondCrossroadId == undefined)
	//		return undefined;
	//console.log(crossroadId+" "+orientation);
	if (this.roads[roadId] == undefined)
		return;
	secondCrossroadId = this.roads[roadId].s1;

	if (secondCrossroadId == crossroadId)
		secondCrossroadId = this.roads[roadId].s2;

	return secondCrossroadId;
}

Traffic.prototype.isCrossroadCorner = function(crossroadId) {
	var numberOfRoads = 0;
	if (this.crossroads[crossroadId].eastNorth != null)
		numberOfRoads++;
	if (this.crossroads[crossroadId].westSouth != null)
		numberOfRoads++;
	if (this.crossroads[crossroadId].eastSouth != null)
		numberOfRoads++;
	if (this.crossroads[crossroadId].westNorth != null)
		numberOfRoads++;

	return numberOfRoads == 2;
}

Traffic.prototype.showLines = function() {
	/*var g = new createjs.Graphics();
	g.setStrokeStyle(1);
	g.beginStroke(createjs.Graphics.getRGB(255,0,0));
	g.beginFill(createjs.Graphics.getRGB(255,0,0));
	var s = new createjs.Shape(g);
		s.x = 100;
		s.y = 100;
	s.graphics.lineTo(1000,1000);
	window.game.stage.addChild(s);

	var graphics = new createjs.Graphics().beginFill("#ff0000").drawRect(0, 0, 100, 100);
	var shape = new createjs.Shape(graphics);

	window.game.stage.update(event);
	*/


	var g = new createjs.Graphics();
	g.setStrokeStyle(1);
	g.beginStroke(createjs.Graphics.getRGB(0, 0, 0));
	g.beginFill(createjs.Graphics.getRGB(255, 0, 0));
	g.drawCircle(0, 0, 3);
	var s = new createjs.Shape(g);
	s.x = 100;
	s.y = 100;

	window.game.stage.addChild(s);
	//window.game.stage.update();

	//this.putCircle({x: this.crossroads[5].position.x, y:this.crossroads[5].position.y});
	/*
		this.putCircle(this.getPointBehindCrossing(5, "eastNorth"));
		console.log(this.getPointBehindCrossing(5, "eastNorth"));
		this.putCircle(this.getPointBehindCrossing(5, "westSouth"));
		console.log(this.getPointBehindCrossing(5, "westSouth"));
		this.putCircle(this.getPointBehindCrossing(5, "eastSouth"));
		console.log(this.getPointBehindCrossing(5, "eastSouth"));
		this.putCircle(this.getPointBehindCrossing(5, "westNorth"));
		console.log(this.getPointBehindCrossing(5, "westNorth"));*/
}

Traffic.prototype.putCircle = function(position) {
	var circle = new createjs.Shape();
	circle.graphics.beginFill("red").drawCircle(0, 0, 5);
	//Set position of Shape instance.
	//circle.x = circle.y = 50;
	circle.x = position.x;
	circle.y = position.y;
	//Add Shape instance to stage display list.
	window.game.map.container.addChild(circle);
}

Traffic.prototype.drawLine = function(position, position2) {
	this.g = new createjs.Graphics();
	this.g.setStrokeStyle(1);
	this.g.beginStroke(createjs.Graphics.getRGB(255, 0, 0));
	this.g.beginFill(createjs.Graphics.getRGB(255, 0, 0));
	//g.drawCircle(0,0,3);
	this.s = new createjs.Shape(this.g);
	//s/.x = firstCrossroad.position.x;
	//s.y = firstCrossroad.position.y;
	this.s.graphics.moveTo(position.x, position.y);
	this.s.graphics.lineTo(position2.x, position2.y);
	window.game.map.container.addChildAt(this.s, window.game.map.container.children.length);
}

Traffic.prototype.crossroadDebug = function(crossroadId) {
	this.removeNewElements();
	var previousChildrenLength = window.game.container.children.length;

	var firstCrossroad = this.getNeighborCrossroad(crossroadId, "eastNorth");
	var secondCrossroad = this.getNeighborCrossroad(crossroadId, "eastSouth");
	var thirdCrossroad = this.getNeighborCrossroad(crossroadId, "westNorth");
	var fourthCrossroad = this.getNeighborCrossroad(crossroadId, "westSouth");

	if (firstCrossroad != undefined)
		this.drawLine(this.crossroads[crossroadId].position, this.crossroads[firstCrossroad].position);

	if (secondCrossroad != undefined)
		this.drawLine(this.crossroads[crossroadId].position, this.crossroads[secondCrossroad].position);

	if (thirdCrossroad != undefined)
		this.drawLine(this.crossroads[crossroadId].position, this.crossroads[thirdCrossroad].position);

	if (fourthCrossroad != undefined)
		this.drawLine(this.crossroads[crossroadId].position, this.crossroads[fourthCrossroad].position);
	this.numerOfNewElements = window.game.container.children.length - previousChildrenLength;
	return this.numerOfNewElements;
}

Traffic.prototype.removeNewElements = function() {
	for (var i = 0; i < this.numerOfNewElements; i++) {
		window.game.container.removeChildAt(window.game.container.children.length - 1);
	}
	this.numerOfNewElements = 0;
}

Traffic.prototype.carDebug = function(carId) {
	var currDate = new Date();
	if ($("#car_" + carId).length == 0) {
		//$("body").append('<div id="car_'+carId+'" style="position: absolute; background-color: white;">'+this.cars[carId].distanceToSource+'</div>');
		//$("body").append('<div id="car_'+carId+'" style="position: absolute; background-color: white;">'+this.cars[carId].isWaiting+'</div>');
		$("body").append('<div id="car_' + carId + '" style="position: absolute; background-color: white;">' + this.cars[carId].waitingStartTime + '</div>');

	}
	var newPosition = window.game.map.bitmap.localToGlobal(this.cars[carId].bitmap.x, this.cars[carId].bitmap.y);
	$("#car_" + carId).css("top", newPosition.y);
	$("#car_" + carId).css("left", newPosition.x);
	$("#car_" + carId).text(currDate - this.cars[carId].waitingStartTime);
}


// + poprawić warstwy
// - poprawić miejsce przeskoku samochodu
// - zablokować pokrywanie samochodu
// - stworzyć warunek wejścia na skrzyzowanie
// - samochody zatrzymywać przed przejściem
// + wyklikać pozostałe ścieżki
// + obsługa czteropasmówki

Vector = function(items) {
	this.items = items
}

Vector.prototype.add = function(other) {
	var result = []
	for (var i = 0; i < this.items.length; i++) {
		result.push(this.items[i] + other.items[i])
	}

	return new Vector(result);
}

Vector.prototype.subtract = function(other) {
	var result = []
	for (var i = 0; i < this.items.length; i++) {
		result.push(this.items[i] - other.items[i])
	}

	return new Vector(result);
}

Vector.prototype.multiply = function(other) {
	var result = []
	for (var i = 0; i < this.items.length; i++) {
		result.push(this.items[i] * other.items[i])
	}

	return new Vector(result);
}

Vector.prototype.magnitude = function() {
	var result = 0;
	for (var i = 0; i < this.items.length; i++) {
		result += this.items[i] * this.items[i];
	}

	return Math.sqrt(result);
}

Vector.prototype.normalize = function() {
	var magnitude = this.magnitude();

	for (var i = 0; i < this.items.length; i++) {
		this.items[i] = this.items[i] / magnitude;
	}
}

Vector.distanceb = function(firstVector, secondVector) {
	var distanceVector = firstVector.subtract(secondVector);
	return distanceVector.magnitude;
}

/** Common GUI functions. **/

window.DEBUG_MODE = true;

/**
 * URL hash dispatcher.
 */
function windowParseUrl() {
	window.parsed = true;
	var registerInterval = 0;

	var hash = window.location.hash;
	console.log('windowParseUrl ' + hash + ' ' + ((new Date().getTime()) / 1000));

	if (hash == window.storeForMeOldHash)
		return;
	window.storeForMeOldHash = hash;

	$.get(window.links.studentAjaxIsLoggedIn, function(result) {
		if (hash == '#city' && result == 1) {
			showMinimap();
		} else
			$("#minimap-linkback").css("display", "none");
		$(".tipsy-w").css("display", "none");
		$("#symbol-hidemap-img").removeClass("showmap");
		$("#symbol-hidemap-img").addClass("hidemap");

	});
	//hide right sidebar
	$('#sidebar-hide').click();

	//close dialogs
	$('.ui-dialog > .ui-dialog-content').each(function() {
		if ($(this).dialog('isOpen'))
			$(this).dialog('close');
	});

	//remove tooltips
	$('.interiorTooltip').remove();

	switch (hash) {
		case "#register":
			$.get(window.links.studentAjaxIsLoggedIn, function(result) {
				// this form only works when not logged in and if registration is enabled
				if (result != 1) {
					window.isLoggedIn = false;

					$.get(window.links.studentAjaxIsRegistrationEnabled, function(regEnabled) {
						if (regEnabled == 1) {
							function showRegister() {
								resetIntroStyle();
								$(".ui-dialog-content").dialog("close");
								$("#dialog-register").dialog("open");
							}

							if ($("#dialog-register").find("register-form").length <= 0) // check if form not loaded
							{
								$("#dialog-register").load(window.links.studentAjaxRegister, function() {
									activateRegister();
									showRegister();
								});
							} else if ($("#dialog-register").dialog("isOpen") == false) {
								showRegister();
							}
						} else window.location.hash = "";
					});
				} else window.location.hash = "";
			});
			break;

		case "#password":
			$.get(window.links.studentAjaxIsLoggedIn, function(result) {
				if (result != 1) // this form only works when not logged in
				{
					window.isLoggedIn = false;

					function showPassword() {
						resetIntroStyle();
						$(".ui-dialog-content").dialog("close");
						$("#dialog-password").dialog("open");
					}

					if ($("#dialog-password").find("password-form").length <= 0) // check if form not loaded
					{
						$("#dialog-password").load(window.links.studentAjaxPassword, function() {
							activatePassword();
							showPassword();
						});
					} else if ($("#dialog-password").dialog("isOpen") == false) // if loaded but not opened
					{
						showPassword();
					}
				} else window.location.hash = "#city";
			});
			break;

		default:
			$.get(window.links.studentAjaxIsLoggedIn, function(result) {
				if (result != 1) {
					window.isLoggedIn = false;

					function showLogin() {
						resetIntroStyle();
						$(".ui-dialog-content").dialog("close");
						$("#dialog-login").dialog("open");
					}

					if ($("#dialog-login").find("login-form").length <= 0) // check if form not loaded
					{
						$("#dialog-login").load(window.links.studentAjaxLogin, function() {
							activateLogin();
							showLogin();
							registerInterval = window.setInterval(updateRegister, 20000);
						});
					} else if ($("#dialog-login").dialog("isOpen") == false) // if loaded but not opened
					{
						showLogin();
					}
				} else {
					$.get(window.links.studentAjaxGetUserData, function(result) {
						//console.log('window.links.studentAjaxGetUserData ' + result);
						if (result != 0 && result != null) {
							var res = jQuery.parseJSON(result);

							Mailbox.update(res['naglowki_wiadomosci']);

							//trigger turaStatusChanged event handlers
							if (window.userdata == null || parseInt(window.userdata['tura_aktywna']) != parseInt(res['tura_aktywna'])) {
								$(window).trigger('turaStatusChanged', parseInt(res['tura_aktywna']));
							}

							window.userdata = res;
							window.isLoggedIn = true;

							//check if current interior is allowed
							var currentInterior = window.location.hash.substring(1);
							if (currentInterior.length > 0 && !isInteriorAllowed(currentInterior))
								window.location.hash = '#city';

							/// === DEBUG ONLY ===============================================
							if (window.DEBUG_MODE && userdata != null && parseInt(userdata.tura) == -1)
								window.game.debugEnableAllBuildings();
							else
								window.game.enableAllowedBuildings();
							/// === BUT THIS IS ACTUALLY USEFUL ==============================

							/*
														$("#bottombar").animate({right: "0px", bottom: "0px"}, 2000, "easeOutExpo");
														var sidebarPosition = $('#mainCanvas').height()/3-$("#sidebar").height()/2;
														$("#sidebar").animate({right:"0px",top:sidebarPosition}, 2000, "easeInExpo");
							                                        		$("#minimap").fadeIn(2000);
							*/
							updateTime();
							updateLesson();
							clearInterval(registerInterval);
							clearInterval(window.updateGameDataInterval);
							window.updateGameDataInterval = window.setInterval(updateGameData, 30000);
							window.kontrahentdata = jQuery.parseJSON(window.userdata["kontrahenci"]);
							window.buildingdata = jQuery.parseJSON(window.userdata["budynki"]);
							window.biurodata = jQuery.parseJSON(window.userdata["biura"]);
							window.bankdata = jQuery.parseJSON(window.userdata["banki"]);
							window.game.enableAllowedBuildings();

							$("#footer").hide("slide", {
								direction: "down"
							}, 1000, function() {
								if (!$("#symbol-komputer").is(":visible")) {
									$("#button-back").hide();
									$("#rightbuttons").show();

									$("#bottombar").animate({
										right: "0px",
										bottom: "0px"
									}, 2000, "easeOutExpo");
									var sidebarPosition = $('#mainCanvas').height() / 3 - $("#sidebar").height() / 2;
									$("#sidebar").animate({
										right: "0px",
										top: sidebarPosition
									}, 2000, "easeInExpo");
									$("#minimap").fadeIn(2000);

									$("#button-ue").fadeIn(1000);
									$("#button-about").fadeIn(1000);
									$("#clockbar").animate({
										left: "-20px"
									}, 2000, "easeInExpo");
									$("#lessonbar").animate({
										right: "-20px"
									}, 2000, "easeInExpo");

									if (window.lockWebTickerTs == null)
										window.lockWebTickerTs = 0;
									//var currentTs = new Date().getTime();
									var currentTs = new Date().getTime();
									if (window.lockWebTickerTs + 1000 < currentTs) {
										window.lockWebTickerTs = currentTs
										checkSize();
										setupButtons();
										parseActions();
										setupSidebarData(false);
									}
								}
							});

							$("#mainmenu a").each(function() { // menudiv
								if (this.text == "Panel administratora")
									$(this).parent().hide(1000);
								if (this.text == "Panel nauczyciela")
									$(this).parent().hide(1000);
								if ($(this).parent().attr('class') == "hiddenMenu")
									$(this).parent().css("display", "inline");
							});
							$("#canvasHolder").css("background-image", "none");
						}
					});

					// check on every hashchange
					getAllowedInteriors();
					setupSidebarData(false);
				}
			});
			break;
	}
}

function getAllowedInteriors() {
	$.ajax({
		url: window.links.studentAjaxGetAllowedInteriors,
		global: false,
		type: 'GET',
		success: function(result) {
			var res = jQuery.parseJSON(result);
			if (res && window.userdata) window.userdata['allowedInteriors'] = res['allowedInteriors'];
			window.game.enableAllowedBuildings();
		}
	});
}

/**
 * Sprawdza czy zadane wnętrze jest dozwolone.
 * Nie sprawdza czy tura jest aktywna.
 * @param {type} string
 * @returns {boolean}
 */
function isInteriorAllowed(interior) {
	return window.userdata != null && window.userdata.allowedInteriors != null &&
		window.userdata.allowedInteriors[interior] != undefined;
}

/**
 * Sprawdza czy zadane wnętrze jest dozwolone, a tura nieaktywna
 * @param {type} string
 * @returns {boolean}
 */
function isInteriorAllowedAndLessonActive(interior) {
	return window.userdata != null && window.userdata.allowedInteriors != null &&
		window.userdata.allowedInteriors[interior] != undefined &&
		parseInt(window.userdata.tura_aktywna);
}

/**
 * Sprawdza czy zadane wnętrze jest dozwolone, a tura aktywna.
 * @param {type} string
 * @returns {boolean}
 */
function isInteriorAllowedAndLessonInactive(interior) {
	return window.userdata != null && window.userdata.allowedInteriors != null &&
		window.userdata.allowedInteriors[interior] != undefined &&
		!parseInt(window.userdata.tura_aktywna);
}

/**
 * Reset css back to intro style.
 */
function resetIntroStyle() {
	$("#footer").show();

	$("#gameSidebar").hide();
	$("#minimap").hide();

	$(".hiddenMenu").css("display", "none");
}

/**
 * Executed every 30 seconds
 */
function updateGameData() {
	updateTime();
	updateLesson();
	getAllowedInteriors();
	setupSidebarData(false);
}

/**
 * Update displayed time, executed every 30 seconds
 */
function updateTime() {
	/* przerobic na ajax */

	/*
	var time = new Date();
	var h = time.getHours();
	var m = time.getMinutes();
	$("#timestring").text(""+(h<=9?'0'+h:h)+":"+(m<=9?'0'+m:m));
	*/

	//	$.get(window.links.studentAjaxGetTime, function(res) {

	$.ajax({
		url: window.links.studentAjaxGetTime,
		global: false, // do not show cursor loading animation for this ajax request
		type: 'GET',
		success: function(res) {
			var time = new Date();
			time.setTime(res);
			var h = time.getHours();
			var m = time.getMinutes();
			$("#timestring").text("" + (h <= 9 ? '0' + h : h) + ":" + (m <= 9 ? '0' + m : m));
		}
	});
}

/**
 * Check and display lesson number, update lesson state, executed every 30 seconds
 */
function updateLesson() {
	// ajax sprawdzenie nr tury i czy aktywna
	$.ajax({
		url: window.links.studentAjaxGetCurrentLesson,
		global: false, // do not show cursor loading animation for this ajax request
		success: function(result) {
			var res = jQuery.parseJSON(result);
			if (res['tura'] != window.userdata['tura']) {
				if (res['tura_aktywna'] && !window.userdata['tura_aktywna']) {
					// if new lesson was started notify and enable some features
					// alert("rozpoczyna się nowa ("+res['tura']+") lekcja");
					// dodac jeszcze wiadomosc z TEXT_NOWA_LEKCJA
					if ($("#dialog-info").dialog("isOpen") === true) {
						$("#dialog-info").dialog('close');
					}
					$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
						activateInfo(parseInt(res["tura"]));
						var sactive = (window.userdata['tura_aktywna'] != "0") ? "(trwa)" : "(zakończona)";
						$("#lessonstring").text("Lekcja: " + window.userdata['tura'] + " " + sactive);
					});
				} else if (!res['tura_aktywna'] && window.userdata['tura_aktywna']) {
					// if lesson time has passed, notify and disable some features
					//alert("zakończyła się lekcja nr "+window.userdata['tura']);
					if ($("#dialog-info").dialog("isOpen") === true) {
						$("#dialog-info").dialog('close');
					}
					$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
						if (window.userdata.tura <= 4)
							activateInfo(-1);
						else
							activateInfo(0);

						var sactive = (window.userdata['tura_aktywna'] != "0") ? "(trwa)" : "(zakończona)";
						$("#lessonstring").text("Lekcja: " + window.userdata['tura'] + " " + sactive);
					});
				} else if (res['tura_aktywna'] && window.userdata['tura_aktywna']) {
					// if new lesson has started directly after previous one
					// showing welcome screen of next lesson - TEST IT
					if ($("#dialog-info").dialog("isOpen") === true) {
						$("#dialog-info").dialog('close');
					}
					$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
						activateInfo(parseInt(res["tura"]));
						var sactive = (window.userdata['tura_aktywna'] != "0") ? "(trwa)" : "(zakończona)";
						$("#lessonstring").text("Lekcja: " + window.userdata['tura'] + " " + sactive);
					});
				}

				// update available actions for this lesson
				getAllowedInteriors();
				/*
				$.ajax({
					url: window.links.studentAjaxGetAllowedInteriors,
					global: false,
					success: function(r2) {
						window.userdata['allowedInteriors'] = r2['allowedInteriors'];
					}
				});
				*/
			} else if (!res['tura_aktywna'] && window.userdata['tura_aktywna']) {
				// if lesson time has passed, notify and disable some features
				//alert("zakończyła się lekcja nr "+window.userdata['tura']);
				if ($("#dialog-info").dialog("isOpen") === true) {
					$("#dialog-info").dialog('close');
				}
				$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
					if (window.userdata.tura <= 4)
						activateInfo(-1);
					else
						activateInfo(0);

					var sactive = (window.userdata['tura_aktywna'] != "0") ? "(trwa)" : "(zakończona)";
					$("#lessonstring").text("Lekcja: " + window.userdata['tura'] + " " + sactive);
				});
			}

			window.userdata['tura'] = res['tura'];
			window.userdata['tura_aktywna'] = res['tura_aktywna'];
		}
	});

	var sactive = (window.userdata['tura_aktywna'] != "0") ? "(trwa)" : "(zakończona)";
	$("#lessonstring").text("Lekcja: " + window.userdata['tura'] + " " + sactive);
}

/**
 * Show register button if registration was enabled, checked every 30 seconds
 */
function updateRegister() {
	if ($("#dialog-login").dialog("isOpen") == true) {
		$.ajax({
			url: window.links.studentAjaxIsRegistrationEnabled,
			global: false, // do not show cursor loading animation for this ajax request
			success: function(result) {
				if (result != 0 && $("#register-button").length <= 0) {
					$("#UserStudentLoginForm_login").after(' <input id="register-button" tabindex="4" name="ytr" type="button" value="Nowe konto" role="button" aria-disabled="false">');
					$("#register-button").button().click(function() {
						window.location.hash = "#register";
					});
				} else if (result == 0 && $("#register-button").length > 0) {
					$("#register-button").remove();
				}
			}
		});
	}
}

/**
 * Parse actions - what was done, what needs to be done.
 */
function parseActions() {
	// po kazdym zalogowaniu pokazujemy okienko dialogowe z informacją o zadaniach do zrobienia w aktualnej lekcji
	//if(parseInt(window.userdata['tura_aktywna']) == 0)
	if (!(window.userdata['tura_aktywna'])) {
		$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
			if (window.userdata.tura <= 4)
				activateInfo(-1);
			else
				activateInfo(0); // brak lekcji (dom)
		});
	} else {
		/*
		$.ajax({
                	url: window.links.studentAjaxIsBlockedAction,
                	global: false,   // do not show cursor loading animation for this ajax request
                	type: 'GET',
			success: function(result)
			{
				if(result > 0)
				{
					$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
						activateInfo(parseInt(window.userdata["tura"]),163); // odrzuconyFormularz blokujemy gre
					});
				}
				else

			}
		});
		*/

		if (parseInt(window.userdata["tura"]) > 0) // lekcja
		{
			$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() { //on firefox loads double time !!!
				activateInfo(parseInt(window.userdata["tura"]));
			});
		}
	}

	// === pobieramy wiadomosci do dolnego tickera ===
	$.ajax({
		url: window.links.studentAjaxGetStudentActionData,
		global: false, // do not show cursor loading animation for this ajax request
		type: 'GET',
		dataType: 'json',
		success: function(result) {
			var messages = jQuery.parseJSON(result["naglowki_akcji"]);

			if (messages.length == 0)
				$("#webticker").html("<li> Nowi przedsiębiorcy w mieście! </li>");
			else {
				for (var i = 0; i < messages.length; i++)
					$("#webticker").append("<li>" + messages[i] + "</li>");
			}
			$("#webticker").webTicker({
				speed: 40,
				direction: "left",
				moving: true,
				startEmpty: true,
				duplicate: true,
				updatetype: "swap",
				hoverpause: false
			});
		}
	});
}

/**
 * Resizing gui - executed on window resize and on minimap hide/show
 */
function checkSize() {
	// center all dialog windows
	$(".ui-dialog-content:visible").dialog("option", "position", "center");

	var wratio = 4096 / window.innerWidth;
	var hratio = 2160 / window.innerHeight;
	var mwratio = 239 / wratio;
	var mhratio = 127 / hratio;
	$("#minimap-radar").width(mwratio);
	$("#minimap-radar").height(mhratio);

	if ($("#minimap").is(":visible")) {
		if (window.innerWidth < 1216) // przyciski GUI w 2 rzędach // 1162
		{
			if (window.game && window.game.currentInterior != -1) {
				$("#rightbuttons").clearQueue().finish().animate({
					marginRight: "321px"
				}, 500, "easeOutExpo"); //350
				$("#buttons").clearQueue().finish().animate({
					height: "51px",
					width: "790px",
					left: (window.innerWidth / 2 - 395) + "px"
				}, 500, "easeOutExpo"); //790
			} else {
				$("#rightbuttons").clearQueue().finish().animate({
					marginRight: "321px"
				}, 500, "easeOutExpo"); //350
				$("#buttons").clearQueue().finish().animate({
					height: "110px",
					width: "790px",
					left: (window.innerWidth / 2 - 395) + "px"
				}, 500, "easeOutExpo"); //790
			}
		} else {
			$("#rightbuttons").clearQueue().finish().animate({
				marginRight: "321px"
			}, 500, "easeOutExpo"); //350
			$("#buttons").clearQueue().finish().animate({
				height: "51px",
				width: "100%",
				left: "0px"
			}, 500, "easeOutExpo");
		}
	} else {
		if (window.innerWidth < 945) // przyciski GUI w 2 rzędach // 891
		{
			if (window.game && window.game.currentInterior != -1) {
				$("#rightbuttons").css({
					"margin-right": "51px"
				}); //80
				$("#buttons").clearQueue().finish().animate({
					height: "51px",
					width: "520px",
					left: (window.innerWidth / 2 - 255) + "px"
				}, 500, "easeOutExpo"); //w520
			} else {
				$("#rightbuttons").css({
					"margin-right": "51px"
				}); //80
				$("#buttons").clearQueue().finish().animate({
					height: "110px",
					width: "520px",
					left: (window.innerWidth / 2 - 255) + "px"
				}, 500, "easeOutExpo"); //w520 h220
			}
		} else {
			$("#rightbuttons").clearQueue().finish().animate({
				marginRight: "51px"
			}, 500, "easeOutExpo"); //80
			$("#buttons").clearQueue().finish().animate({
				height: "51px",
				width: "100%",
				left: "0px"
			}, 500, "easeOutExpo");
		}
	}
}

/**
 * Check missed forms
 */
function checkMissedForms() {
	if (!$(".ui-dialog-content").is(':visible') && window.userdata['tura_aktywna']) {
		var adres = window.location.hash;
		if (adres == "#dokumenty" || adres == "#internet" || adres == "#skrzynka" || adres == "#internetBankowosc" || adres == "#finanse" || adres == "#statystyki" || adres == "#pracownicy" || adres == "#biuroGracza") {
			// ============== CHECK IF THERE ARE BLOCKED ACTIONS
			if ($("#dialog-info").dialog("isOpen") === true) {
				$("#dialog-info").dialog('close');
			}
			$.ajax({
				url: window.links.studentAjaxIsBlockedAction,
				global: false, // do not show cursor loading animation for this ajax request
				type: 'GET',
				success: function(result) {
					if (result > 0) {
						if (result == 2) // zaległe formularze
						{
							$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
								$("#info-submit").val("Wypełnij dokumenty");
								activateInfo(parseInt(window.userdata["tura"]), 164); // zalegleFormularze z poprzednich lekcji
							});
						} else if (result == 7) // zalegle formularze po dotacji
						{
							$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
								$("#info-submit").val("Wypełnij dokumenty");
								activateInfo(parseInt(window.userdata["tura"]), 176); // blokujemy gre bo brak biura
							});
						}
						/*
                                                else
                                                {
                                                        $("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
                                                        	submitInfo();
							});
                                                }
                                                */
					}
				}
			});
			//\============== CHECK IF THERE ARE BLOCKED ACTIONS
		}
	}
}

/***
 * Showing buttons one by one
 */
function setupButtons() {
	// left corner
	$("#button-ue").click(function() {
		if ($("#footer").is(":visible")) {
			$("#footer").hide("slide", {
				direction: "down"
			}, 1000, function() {
				$("#footer").css({
					"z-index": "4"
				});
			});
		} else {
			$("#footer").css({
				"z-index": "600"
			});
			$("#footer").show("slide", {
				direction: "down"
			}, 1000).delay(2000);
			$("#footer").mousemove(function() {
				$("#footer").hide("slide", {
					direction: "down"
				}, 1000, function() {
					$("#footer").css({
						"z-index": "4"
					});
				});
			});
		}
	});
	$("#button-ue").tipsy({
		gravity: 'sw',
		html: true
	});

	// right corner
	$("#button-about").click(function() {
		if ($("#dialog-about").find(".container").length <= 0) // check if form not loaded
		{
			$("#dialog-about").load(window.links.studentAjaxAboutDialog, function() {
				$("#dialog-about").dialog("open");
			});
		} else $("#dialog-about").dialog("open");
	});
	$("#button-about").tipsy({
		gravity: 'se',
		html: true,
		offset: 18
	});

	// button back from interior
	$("#button-back").click(function() {
		checkMissedForms();
		showMinimap();
	});

	$("#browser_close").click(function() {
		showMinimap();
		return false;
	});

	$("#headerbar img").click(function() {
		checkMissedForms();
		showMinimap();
	});

	if ($("#button-back").is(":visible"))
		$("#button-back").tipsy({
			gravity: 'w',
			trigger: 'manual',
			html: true
		}).tipsy('show');

	//$("#button-back").tipsy('show');

	// bottombar - left

	$("#symbol-komputer").clearQueue().finish().delay(0).fadeIn(500).addClass("hover1").delay(200).queue(function() {
		$(this).removeClass("hover1");
	});
	$("#symbol-komputer").click(function() {
		if (isInteriorAllowed('biuroGracza') && window.userdata['ilosc_biur'] > 0) // internet
			if (!$(".ui-dialog-content").is(':visible'))
				window.location.hash = 'biuroGracza';
			else
				$(".ui-dialog-title").effect("pulsate", {}, 700);
		else
		if (window.userdata['tura_aktywna'])
			showMessage('Info', 'Ten przycisk będzie aktywny na dalszym etapie gry.'); // Akcja jest w tym momencie niedostępna.
		else
			showMessage('Info', 'Ten przycisk będzie aktywny podczas trwania lekcji.');
	});

	$("#symbol-finanse").clearQueue().finish().delay(200).fadeIn(500).addClass("hover1").delay(200).queue(function() {
		$(this).removeClass("hover1");
	});
	$("#symbol-finanse").click(function() {
		if (isInteriorAllowed('finanse'))
			if (!$(".ui-dialog-content").is(':visible'))
				window.location.hash = "finanse";
			else
				$(".ui-dialog-title").effect("pulsate", {}, 700);
		else
		if (window.userdata['tura_aktywna'])
			showMessage('Info', 'Ten przycisk będzie aktywny na dalszym etapie gry.');
		else
			showMessage('Info', 'Ten przycisk będzie aktywny podczas trwania lekcji.');
	});

	$("#symbol-statystyki").clearQueue().finish().delay(400).fadeIn(500).addClass("hover1").delay(200).queue(function() {
		$(this).removeClass("hover1");
	});
	$("#symbol-statystyki").click(function() {
		if (isInteriorAllowed('statystyki'))
			if (!$(".ui-dialog-content").is(':visible'))
				window.location.hash = "statystyki";
			else
				$(".ui-dialog-title").effect("pulsate", {}, 700);
		else
		if (window.userdata['tura_aktywna'])
			showMessage('Info', 'Ten przycisk będzie aktywny na dalszym etapie gry.');
		else
			showMessage('Info', 'Ten przycisk będzie aktywny podczas trwania lekcji.');
	});

	$("#symbol-pliki").clearQueue().finish().delay(600).fadeIn(500).addClass("hover1").delay(200).queue(function() {
		$(this).removeClass("hover1");
	});
	/*	$("#symbol-pliki").click(function(){
			if (isInteriorAllowed('dokumenty'))
				if(!$(".ui-dialog-content").is(':visible'))
					window.location.hash="dokumenty";
				else
					$(".ui-dialog-title").effect("pulsate",{},700);
			else
				if(window.userdata['tura_aktywna'])
					showMessage('Info', 'Ten przycisk będzie aktywny na dalszym etapie gry.');
				else
					showMessage('Info', 'Ten przycisk będzie aktywny podczas trwania lekcji.');
		}); */
	$("#symbol-pliki").click(function() {
		if (isInteriorAllowed('dokumenty'))
			if (!$(".ui-dialog-content").is(':visible'))
				window.location.hash = "dokumenty";
			else
				$(".ui-dialog-title").effect("pulsate", {}, 700);
		else
			showMessage('Info', 'Ten przycisk nie jest aktywny.');
	});

	$("#symbol-pracownicy").clearQueue().finish().delay(800).fadeIn(500).addClass("hover1").delay(200).queue(function() {
		$(this).removeClass("hover1");
	});
	$("#symbol-pracownicy").click(function() {
		if (isInteriorAllowed('pracownicy'))
			if (!$(".ui-dialog-content").is(':visible'))
				window.location.hash = "pracownicy";
			else
				$(".ui-dialog-title").effect("pulsate", {}, 700);
		else
		if (window.userdata['tura_aktywna'])
			showMessage('Info', 'Ten przycisk będzie aktywny na dalszym etapie gry.');
		else
			showMessage('Info', 'Ten przycisk będzie aktywny podczas trwania lekcji.');
	});

	$("#symbol-zlecenia").clearQueue().finish().delay(1000).fadeIn(500).addClass("hover1").delay(200).queue(function() {
		$(this).removeClass("hover1");
	});

	$('#tasks-counter').html(window.userdata.tasksToGo);
	if (!window.userdata.tura_aktywna && window.userdata.tasksToGo)
		$('#tasks-counter').fadeIn();
	else
		$('#tasks-counter').fadeOut();

	$("#symbol-zlecenia").click(function() {
		if (isInteriorAllowed('zlecenia'))
			if (!$(".ui-dialog-content").is(':visible'))
				window.location.hash = "zlecenia";
			else
				$(".ui-dialog-title").effect("pulsate", {}, 700);
		else
			showMessage('Info', 'Zlecenia mogą być rozwiązywane w domu, po zakończeniu lekcji.');
	});

	$(".barbutton").tipsy({
		gravity: 's'
	}); // show tooltips
	/************************/

	// bottombar - right
	$("#symbol-urzadpracy").clearQueue().finish().delay(2600).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	});
	$("#symbol-urzadpracy").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {
			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");
			var p1 = $("#mpointer1");
			p1.show();
			p1.css({
				top: "26px",
				left: "147px"
			});
			p1.effect("pulsate", {}, 1000);
			var p2 = $("#mpointer2");
			p2.show();
			p2.css({
				top: "40px",
				left: "142px"
			});
			p2.effect("pulsate", {}, 1000);
			window.game.map.buildings["urzadPracy"].highlight("#gameTooltip2");
			window.game.map.buildings["agencjaPosrednictwaPracy"].highlight("#gameTooltip3");
		}
	});

	$("#symbol-zus").clearQueue().finish().delay(2400).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	});
	$("#symbol-zus").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {
			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");
			var p1 = $("#mpointer1");
			p1.show();
			p1.css({
				top: "55px",
				left: "60px"
			});
			p1.effect("pulsate", {}, 1000);
			window.game.map.buildings["zus"].highlight("#gameTooltip2");
		}
	});

	$("#symbol-urzadskarbowy").clearQueue().finish().delay(2200).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	}); // 1200
	$("#symbol-urzadskarbowy").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {
			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");
			var p1 = $("#mpointer1");
			p1.show();
			p1.css({
				top: "40px",
				left: "110px"
			});
			p1.effect("pulsate", {}, 1000);
			var p2 = $("#mpointer2");
			p2.show();
			p2.css({
				top: "14px",
				left: "150px"
			});
			p2.effect("pulsate", {}, 1000);
			var p3 = $("#mpointer3");
			p3.show();
			p3.css({
				top: "55px",
				left: "120px"
			});
			p3.effect("pulsate", {}, 1000);
			window.game.map.buildings["urzadSkarbowy1"].highlight("#gameTooltip2");
			window.game.map.buildings["urzadSkarbowy2"].highlight("#gameTooltip3");
			window.game.map.buildings["urzadSkarbowy3"].highlight("#gameTooltip4");
		}
	});

	$("#symbol-bank").clearQueue().finish().delay(2000).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	});
	$("#symbol-bank").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {

			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");
			var p1 = $("#mpointer1");
			p1.show();
			p1.css({
				top: "22px",
				left: "139px"
			});
			p1.effect("pulsate", {}, 1000);
			var p2 = $("#mpointer2");
			p2.show();
			p2.css({
				top: "50px",
				left: "50px"
			});
			p2.effect("pulsate", {}, 1000);
			var p3 = $("#mpointer3");
			p3.show();
			p3.css({
				top: "40px",
				left: "120px"
			});
			p3.effect("pulsate", {}, 1000);
			var p4 = $("#mpointer4");
			p4.show();
			p4.css({
				top: "28px",
				left: "90px"
			});
			p4.effect("pulsate", {}, 1000);
			window.game.map.buildings["bank1"].highlight("#gameTooltip2");
			window.game.map.buildings["bank2"].highlight("#gameTooltip3");
			window.game.map.buildings["bank3"].highlight("#gameTooltip4");
			window.game.map.buildings["bank4"].highlight("#gameTooltip5");
		}
	});

	$('#rightbuttons [id!="symbol-biuro"]').click(function() {
		if ($("#symbol-biuro").hasClass("hover2")) window.game.map.clearBuildingFilters();
	}); //if clicked on button different than "symbol-biuro" - remove color filters from offices buildings
	$("#symbol-biuro").clearQueue().finish().delay(1800).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	});
	$("#symbol-biuro").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			window.game.map.clearBuildingFilters();
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {
			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");

			var p1 = $("#mpointer1");
			p1.show();
			//p1.css({top:"5px",left:"38px"});
			p1.css({
				top: "38px",
				left: "5px"
			});
			p1.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro27"].highlight("#gameTooltip2", true);
			var p2 = $("#mpointer2");
			p2.show();
			//p2.css({top:"14px",left:"32px"});
			p2.css({
				top: "32px",
				left: "14px"
			});
			p2.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro28b"].highlight("#gameTooltip3", true);
			var p3 = $("#mpointer3");
			p3.show();
			//p3.css({top:"30px",left:"33px"});
			p3.css({
				top: "33px",
				left: "30px"
			});
			p3.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro5"].highlight("#gameTooltip4", true);
			var p4 = $("#mpointer4");
			p4.show();
			//p4.css({top:"40px",left:"40px"});
			p4.css({
				top: "40px",
				left: "40px"
			});
			p4.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro18"].highlight("#gameTooltip5", true);
			var p5 = $("#mpointer5");
			p5.show();
			//p5.css({top:"16px",left:"56px"});
			p5.css({
				top: "56px",
				left: "16px"
			});
			p5.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro14"].highlight("#gameTooltip6", true);
			var p6 = $("#mpointer6");
			p6.show();
			//p6.css({top:"60px",left:"47px"});
			p6.css({
				top: "47px",
				left: "60px"
			});
			p6.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro13-2"].highlight("#gameTooltip7", true);
			var p7 = $("#mpointer7");
			p7.show();
			//p7.css({top:"19px",left:"69px"});
			p7.css({
				top: "69px",
				left: "19px"
			});
			p7.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro33"].highlight("#gameTooltip8", true);
			var p8 = $("#mpointer8");
			p8.show();
			//p8.css({top:"59px",left:"69px"});
			p8.css({
				top: "69px",
				left: "59px"
			});
			p8.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro28b-2"].highlight("#gameTooltip9", true);
			var p9 = $("#mpointer9");
			p9.show();
			//p9.css({top:"68px",left:"72px"});
			p9.css({
				top: "72px",
				left: "68px"
			});
			p9.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro29"].highlight("#gameTooltip10", true);
			var p10 = $("#mpointer10");
			p10.show();
			//p10.css({top:"79px",left:"59px"});
			p10.css({
				top: "59px",
				left: "79px"
			});
			p10.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro28-4"].highlight("#gameTooltip11", true);
			var p11 = $("#mpointer11");
			p11.show();
			//p11.css({top:"107px",left:"66px"});
			p11.css({
				top: "66px",
				left: "107px"
			});
			p11.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro43"].highlight("#gameTooltip12", true);
			var p12 = $("#mpointer12");
			p12.show();
			//p12.css({top:"65px",left:"41px"});
			p12.css({
				top: "41px",
				left: "65px"
			});
			p12.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro51"].highlight("#gameTooltip13", true);
			var p13 = $("#mpointer13");
			p13.show();
			//p13.css({top:"84px",left:"44px"});
			p13.css({
				top: "44px",
				left: "84px"
			});
			p13.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro1"].highlight("#gameTooltip14", true);
			var p14 = $("#mpointer14");
			p14.show();
			//p14.css({top:"91px",left:"54px"});
			p14.css({
				top: "54px",
				left: "91px"
			});
			p14.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro7"].highlight("#gameTooltip15", true);
			var p15 = $("#mpointer15");
			p15.show();
			//p15.css({top:"64px",left:"28px"});
			p15.css({
				top: "28px",
				left: "64px"
			});
			p15.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro10-2"].highlight("#gameTooltip16", true);
			var p16 = $("#mpointer16");
			p16.show();
			//p16.css({top:"82px",left:"31px"});
			p16.css({
				top: "31px",
				left: "82px"
			});
			p16.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro25"].highlight("#gameTooltip17", true);
			var p17 = $("#mpointer17");
			p17.show();
			//p17.css({top:"93px",left:"40px"});
			p17.css({
				top: "40px",
				left: "93px"
			});
			p17.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro48"].highlight("#gameTooltip18", true);
			var p18 = $("#mpointer18");
			p18.show();
			//p18.css({top:"129px",left:"57px"});
			p18.css({
				top: "57px",
				left: "129px"
			});
			p18.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro42-2"].highlight("#gameTooltip19", true);
			var p19 = $("#mpointer19");
			p19.show();
			//p19.css({top:"160px",left:"93px"});
			p19.css({
				top: "93px",
				left: "160px"
			});
			p19.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro59"].highlight("#gameTooltip20", true);
			var p20 = $("#mpointer20");
			p20.show();
			//p20.css({top:"79px",left:"24px"});
			p20.css({
				top: "24px",
				left: "79px"
			});
			p20.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro14-2"].highlight("#gameTooltip21", true);
			var p21 = $("#mpointer21");
			p21.show();
			//p21.css({top:"78px",left:"20px"});
			p21.css({
				top: "20px",
				left: "78px"
			});
			p21.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro16"].highlight("#gameTooltip22", true);

			var p22 = $("#mpointer22");
			p22.show();
			//p22.css({top:"94px",left:"1px"});
			p22.css({
				top: "1px",
				left: "94px"
			});
			p22.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro39"].highlight("#gameTooltip23", true);
			var p23 = $("#mpointer23");
			p23.show();
			//p23.css({top:"135px",left:"25px"});
			p23.css({
				top: "25px",
				left: "135px"
			});
			p23.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro4"].highlight("#gameTooltip24", true);
			var p24 = $("#mpointer24");
			p24.show();
			//p24.css({top:"160px",left:"21px"});
			p24.css({
				top: "21px",
				left: "160px"
			});
			p24.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro60"].highlight("#gameTooltip25", true);
			var p25 = $("#mpointer25");
			p25.show();
			//p25.css({top:"141px",left:"32px"});
			p25.css({
				top: "32px",
				left: "141px"
			});
			p25.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro54-2"].highlight("#gameTooltip26", true);
			var p26 = $("#mpointer26");
			p26.show();
			//p26.css({top:"140px",left:"37px"});
			p26.css({
				top: "37px",
				left: "140px"
			});
			p26.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro53-3"].highlight("#gameTooltip27", true);
			var p27 = $("#mpointer27");
			p27.show();
			//p27.css({top:"141px",left:"40px"});
			p27.css({
				top: "40px",
				left: "141px"
			});
			p27.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro50-4"].highlight("#gameTooltip28", true);
			var p28 = $("#mpointer28");
			p28.show();
			//p28.css({top:"155px",left:"48px"});
			p28.css({
				top: "48px",
				left: "155px"
			});
			p28.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro53"].highlight("#gameTooltip29", true);
			var p29 = $("#mpointer29");
			p29.show();
			//p29.css({top:"160px",left:"45px"});
			p29.css({
				top: "45px",
				left: "160px"
			});
			p29.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro52"].highlight("#gameTooltip30", true);
			var p30 = $("#mpointer30");
			p30.show();
			//p30.css({top:"169px",left:"40px"});
			p30.css({
				top: "40px",
				left: "169px"
			});
			p30.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro54"].highlight("#gameTooltip31", true);

			// additional

			var p31 = $("#mpointer31");
			p31.show();
			//p11.css({top:"52px",left:"40px"});
			p31.css({
				top: "40px",
				left: "52px"
			});
			p31.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro13"].highlight("#gameTooltip12");
			window.game.map.buildings["biuro13"].highlight("#gameTooltip32", true);
			var p32 = $("#mpointer32");
			p32.show();
			//p12.css({top:"72px",left:"54px"});
			p32.css({
				top: "54px",
				left: "72px"
			});
			p32.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro34"].highlight("#gameTooltip13");
			window.game.map.buildings["biuro34"].highlight("#gameTooltip33", true);


			var p34 = $("#mpointer34");
			p34.show();
			//p1.css({top:"8px",left:"28px"});
			p34.css({
				top: "28px",
				left: "8px"
			});
			p34.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro37"].highlight("#gameTooltip2");
			window.game.map.buildings["biuro37"].highlight("#gameTooltip35", true);
			var p35 = $("#mpointer35");
			p35.show();
			//p2.css({top:"13px",left:"43px"});
			p35.css({
				top: "43px",
				left: "13px"
			});
			p35.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro26"].highlight("#gameTooltip3");
			window.game.map.buildings["biuro26"].highlight("#gameTooltip36", true);
			var p36 = $("#mpointer36");
			p36.show();
			//p3.css({top:"12px",left:"64px"});
			p36.css({
				top: "64px",
				left: "12px"
			});
			p36.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro23"].highlight("#gameTooltip4");
			window.game.map.buildings["biuro23"].highlight("#gameTooltip37", true);
			var p37 = $("#mpointer37");
			p37.show();
			//p4.css({top:"22px",left:"58px"});
			p37.css({
				top: "58px",
				left: "22px"
			});
			p37.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro57"].highlight("#gameTooltip5");
			window.game.map.buildings["biuro57"].highlight("#gameTooltip38", true);
			var p38 = $("#mpointer38");
			p38.show();
			//p5.css({top:"31px",left:"64px"});
			p38.css({
				top: "64px",
				left: "31px"
			});
			p38.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro32"].highlight("#gameTooltip6");
			window.game.map.buildings["biuro32"].highlight("#gameTooltip39", true);
			var p39 = $("#mpointer39");
			p39.show();
			//p6.css({top:"35px",left:"75px"});
			p39.css({
				top: "75px",
				left: "35px"
			});
			p39.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro10"].highlight("#gameTooltip7");
			window.game.map.buildings["biuro10"].highlight("#gameTooltip40", true);
		}
	});
	$("#symbol-kontrahenci").clearQueue().finish().delay(1600).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	});
	$("#symbol-kontrahenci").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {
			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");

			// 5

			var p6 = $("#mpointer6");
			p6.show();
			//p13.css({top:"81px",left:"57px"});
			p6.css({
				top: "57px",
				left: "81px"
			});
			p6.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro42"].highlight("#gameTooltip14");
			window.game.map.buildings["biuro42"].highlight("#gameTooltip7");

			var p7 = $("#mpointer7");
			p7.show();
			//p7.css({top:"42px",left:"68px"});
			p7.css({
				top: "68px",
				left: "42px"
			});
			p7.effect("pulsate", {}, 1000);
			//window.game.map.buildings["metropolian"].highlight("#gameTooltip8");
			window.game.map.buildings["metropolian"].highlight("#gameTooltip8");
			var p8 = $("#mpointer8");
			p8.show();
			//p8.css({top:"52px",left:"66px"});
			p8.css({
				top: "66px",
				left: "52px"
			});
			p8.effect("pulsate", {}, 1000);
			//window.game.map.buildings["ing"].highlight("#gameTooltip9");
			window.game.map.buildings["ing"].highlight("#gameTooltip9");
			var p9 = $("#mpointer9");
			p9.show();
			//p9.css({top:"68px",left:"74px"});
			p9.css({
				top: "74px",
				left: "68px"
			});
			p9.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro28-2"].highlight("#gameTooltip10");
			window.game.map.buildings["biuro28-2"].highlight("#gameTooltip10");
			var p10 = $("#mpointer10");
			p10.show();
			//p10.css({top:"68px",left:"78px"});
			p10.css({
				top: "78px",
				left: "68px"
			});
			p10.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro29-2"].highlight("#gameTooltip11");
			window.game.map.buildings["biuro29-2"].highlight("#gameTooltip11");

			// 3

			var p14 = $("#mpointer14");
			p14.show();
			//p14.css({top:"112px",left:"64px"});
			p14.css({
				top: "64px",
				left: "112px"
			});
			p14.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro48-2"].highlight("#gameTooltip15");
			window.game.map.buildings["biuro48-2"].highlight("#gameTooltip15");
			var p15 = $("#mpointer15");
			p15.show();
			//p15.css({top:"70px",left:"42px"});
			p15.css({
				top: "42px",
				left: "70px"
			});
			p15.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro46"].highlight("#gameTooltip16");
			window.game.map.buildings["biuro46"].highlight("#gameTooltip16");
			var p16 = $("#mpointer16");
			p16.show();
			//p16.css({top:"87px",left:"42px"});
			p16.css({
				top: "42px",
				left: "87px"
			});
			p16.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro8"].highlight("#gameTooltip17");
			window.game.map.buildings["biuro8"].highlight("#gameTooltip17");
			var p17 = $("#mpointer17");
			p17.show();
			//p17.css({top:"102px",left:"58px"});
			p17.css({
				top: "58px",
				left: "102px"
			});
			p17.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro2"].highlight("#gameTooltip18");
			window.game.map.buildings["biuro2"].highlight("#gameTooltip18");
			var p18 = $("#mpointer18");
			p18.show();
			//p18.css({top:"112px",left:"52px"});
			p18.css({
				top: "52px",
				left: "112px"
			});
			p18.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro6"].highlight("#gameTooltip19");
			window.game.map.buildings["biuro6"].highlight("#gameTooltip19");
			var p19 = $("#mpointer19");
			p19.show();
			//p19.css({top:"132px",left:"53px"});
			p19.css({
				top: "53px",
				left: "132px"
			});
			p19.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro55"].highlight("#gameTooltip20");
			window.game.map.buildings["biuro55"].highlight("#gameTooltip20");
			var p20 = $("#mpointer20");
			p20.show();
			//p20.css({top:"72px",left:"26px"});
			p20.css({
				top: "26px",
				left: "72px"
			});
			p20.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro20-2"].highlight("#gameTooltip21");
			window.game.map.buildings["biuro20-2"].highlight("#gameTooltip21");
			var p21 = $("#mpointer21");
			p21.show();
			//p21.css({top:"101px",left:"33px"});
			p21.css({
				top: "33px",
				left: "101px"
			});
			p21.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro34-2"].highlight("#gameTooltip22");
			window.game.map.buildings["biuro34-2"].highlight("#gameTooltip22");
			var p22 = $("#mpointer22");
			p22.show();
			//p22.css({top:"103px",left:"3px"});
			p22.css({
				top: "3px",
				left: "103px"
			});
			p22.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro19"].highlight("#gameTooltip23");
			window.game.map.buildings["biuro19"].highlight("#gameTooltip23");
			var p23 = $("#mpointer23");
			p23.show();
			//p23.css({top:"103px",left:"3px"});
			p23.css({
				top: "4px",
				left: "104px"
			});
			p23.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro12-2"].highlight("#gameTooltip24");
			window.game.map.buildings["biuro12-2"].highlight("#gameTooltip24");
			var p24 = $("#mpointer24");
			p24.show();
			//p24.css({top:"127px",left:"31px"});
			p24.css({
				top: "31px",
				left: "127px"
			});
			p24.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro47"].highlight("#gameTooltip25");
			window.game.map.buildings["biuro47"].highlight("#gameTooltip25");
			var p25 = $("#mpointer25");
			p25.show();
			//p25.css({top:"135px",left:"43px"});
			p25.css({
				top: "43px",
				left: "135px"
			});
			p25.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro45"].highlight("#gameTooltip26");
			window.game.map.buildings["biuro45"].highlight("#gameTooltip26");
			var p26 = $("#mpointer26");
			p26.show();
			//p26.css({top:"145px",left:"38px"});
			p26.css({
				top: "38px",
				left: "145px"
			});
			p26.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro50-3"].highlight("#gameTooltip27");
			window.game.map.buildings["biuro50-3"].highlight("#gameTooltip27");
			var p27 = $("#mpointer27");
			p27.show();
			//p27.css({top:"139px",left:"34px"});
			p27.css({
				top: "34px",
				left: "139px"
			});
			p27.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro53-2"].highlight("#gameTooltip28");
			window.game.map.buildings["biuro53-2"].highlight("#gameTooltip28");
			var p28 = $("#mpointer28");
			p28.show();
			//p28.css({top:"165px",left:"24px"});
			p28.css({
				top: "24px",
				left: "165px"
			});
			p28.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro9"].highlight("#gameTooltip29");
			window.game.map.buildings["biuro9"].highlight("#gameTooltip29");
			var p29 = $("#mpointer29");
			p29.show();
			//p29.css({top:"177px",left:"33px"});
			p29.css({
				top: "33px",
				left: "177px"
			});
			p29.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuroPyramid"].highlight("#gameTooltip30");
			window.game.map.buildings["biuroPyramid"].highlight("#gameTooltip30");
			var p30 = $("#mpointer30");
			p30.show();
			//p30.css({top:"158px",left:"45px"});
			p30.css({
				top: "45px",
				left: "158px"
			});
			p30.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro50-2"].highlight("#gameTooltip31");
			window.game.map.buildings["biuro50-2"].highlight("#gameTooltip31");
			var p31 = $("#mpointer31");
			p31.show();
			//p31.css({top:"166px",left:"41px"});
			p31.css({
				top: "41px",
				left: "166px"
			});
			p31.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro50"].highlight("#gameTooltip32");
			window.game.map.buildings["biuro50"].highlight("#gameTooltip32");
			var p32 = $("#mpointer32");
			p32.show();
			//p32.css({top:"172px",left:"40px"});
			p32.css({
				top: "40px",
				left: "172px"
			});
			p32.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro51-2"].highlight("#gameTooltip33");
			window.game.map.buildings["biuro51-2"].highlight("#gameTooltip33");
			var p33 = $("#mpointer33");
			p33.show();
			//p33.css({top:"213px",left:"54px"});
			p33.css({
				top: "54px",
				left: "213px"
			});
			p33.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuroElpro"].highlight("#gameTooltip34");
			window.game.map.buildings["biuroElpro"].highlight("#gameTooltip34");

		}
	});

	$("#symbol-szkolenia").clearQueue().finish().delay(1400).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	});
	$("#symbol-szkolenia").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {
			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");
			var p1 = $("#mpointer1");
			p1.show();
			p1.css({
				top: "45px",
				left: "96px"
			});
			p1.effect("pulsate", {}, 1000);
			var p2 = $("#mpointer2");
			p2.show();
			p2.css({
				top: "32px",
				left: "22px"
			});
			p2.effect("pulsate", {}, 1000);
			var p3 = $("#mpointer3");
			p3.show();
			p3.css({
				top: "30px",
				left: "170px"
			});
			p3.effect("pulsate", {}, 1000);
			var p4 = $("#mpointer4");
			p4.show();
			p4.css({
				top: "80px",
				left: "162px"
			});
			p4.effect("pulsate", {}, 1000);

			window.game.map.buildings["centrumSzkoleniowe1"].highlight("#gameTooltip2");
			window.game.map.buildings["centrumSzkoleniowe2"].highlight("#gameTooltip3");
			window.game.map.buildings["centrumSzkoleniowe3"].highlight("#gameTooltip4");
			window.game.map.buildings["centrumSzkoleniowe4"].highlight("#gameTooltip5");
		}
	});
	$("#symbol-marketing").clearQueue().finish().delay(1200).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	}); // 2600
	$("#symbol-marketing").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {
			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");
			var p1 = $("#mpointer1");
			p1.show();
			p1.css({
				top: "55px",
				left: "36px"
			});
			p1.effect("pulsate", {}, 1000);

			var p2 = $("#mpointer2");
			p2.show();
			p2.css({
				top: "25px",
				left: "32px"
			});
			p2.effect("pulsate", {}, 1000);

			var p3 = $("#mpointer3");
			p3.show();
			p3.css({
				top: "20px",
				left: "86px"
			});
			p3.effect("pulsate", {}, 1000);

			window.game.map.buildings["agencjaReklamowa1"].highlight("#gameTooltip2");
			window.game.map.buildings["agencjaReklamowa2"].highlight("#gameTooltip3");
			window.game.map.buildings["agencjaReklamowa3"].highlight("#gameTooltip4");
		}
	});

	$(".barbutton2").tipsy({
		gravity: 's'
	}); // show tooltips
	/************************/

	// hide minimap
	$("#symbol-hidemap").clearQueue().finish().delay(2800).fadeIn(500).addClass("hover3").delay(200).queue(function() {
		$(this).removeClass("hover3");
	});
	$("#symbol-hidemap").click(function(event) {
		if ($("#minimap").is(":visible")) {
			$("#minimap").fadeOut(1000, function() {
				checkSize();
			});
			$(this).clearQueue().finish().animate({
				"right": "10px"
			}, 1000, "easeInExpo");
			$("#bottombar").clearQueue().finish().animate({
				right: "-240px"
			}, 1000, "easeInExpo");
			$("#rightbuttons").clearQueue().finish().animate({
				marginRight: "51px"
			}, 1000, "easeInExpo"); //80
			$("#symbol-hidemap-img").removeClass("hidemap");
			$("#symbol-hidemap-img").addClass("showmap");
		} else {
			$("#minimap").show();
			checkSize();
			$("#minimap").hide();
			$("#minimap").fadeIn(1000); //, function() { checkSize(); });
			//$("#minimap").show(); checkSize();
			$(this).clearQueue().finish().animate({
				"right": "250px"
			}, 1000, "easeOutExpo");
			$("#bottombar").clearQueue().finish().animate({
				right: "0px"
			}, 1000, "easeOutExpo");
			$("#rightbuttons").clearQueue().finish().animate({
				marginRight: "321px"
			}, 1000, "easeOutExpo"); //350
			$("#symbol-hidemap-img").removeClass("showmap");
			$("#symbol-hidemap-img").addClass("hidemap");
		}
	});

	// sidebar buttons
	$("#symbol-firma").clearQueue().finish().delay(2000).fadeIn(500).addClass("hover3").delay(200).queue(function() {
		$(this).removeClass("hover3");
	});
	$("#symbol-punkty").clearQueue().finish().delay(2200).fadeIn(500).addClass("hover3").delay(200).queue(function() {
		$(this).removeClass("hover3");
	});
	$("#symbol-skrzynka").clearQueue().finish().delay(2400).fadeIn(500).addClass("hover3").delay(200).queue(function() {
		$(this).removeClass("hover3");
	});
	$("#symbol-statbar").clearQueue().finish().delay(2600).fadeIn(500).addClass("hover3").delay(200).queue(function() {
		$(this).removeClass("hover3");
	});

	// show sidebar and switch buttons
	$("#symbol-firma").click(function() {
		if ($("#sidebar-collapsed").is(":visible")) {
			setupSidebarData();
			$("#sidebar-collapsed").fadeOut(500, function() {
				$("#sidebar").css({
					width: "190px",
					height: "407px"
				});
				$(".sidebar-header").fadeIn(500);
				$("#sidebar-hide").animate({
					right: "0px"
				}, 500, "easeInExpo");
				$("#sidebar-expanded").fadeIn(1000).animate({
					right: "0px"
				}, 1000, "easeOutExpo");
			});
		}
		$("#symbol-firma").clearQueue().finish().animate({
			top: "-10px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-punkty").clearQueue().finish().animate({
			top: "245px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-skrzynka").clearQueue().finish().animate({
			top: "300px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-statbar").clearQueue().finish().animate({
			top: "355px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#sidebar-firma").clearQueue().finish().animate({
			top: "0px"
		}, 500, "easeInCirc");
		$("#sidebar-punkty").clearQueue().finish().animate({
			top: "255px"
		}, 500, "easeInCirc");
		$("#sidebar-skrzynka").clearQueue().finish().animate({
			top: "310px"
		}, 500, "easeInCirc");
		$("#sidebar-statbar").clearQueue().finish().animate({
			top: "360px"
		}, 500, "easeInCirc");
		$("#opis-firma").clearQueue().finish().delay(500).fadeIn(500);
		$("#opis-punkty").clearQueue().finish().fadeOut(500);
		$("#opis-skrzynka").clearQueue().finish().fadeOut(500);
		$("#opis-stat").clearQueue().finish().fadeOut(500);
	});
	$("#symbol-punkty").click(function() {
		if ($("#sidebar-collapsed").is(":visible")) {
			setupSidebarData();
			$("#sidebar-collapsed").fadeOut(500, function() {
				$("#sidebar").css({
					width: "190px",
					height: "407px"
				});
				$(".sidebar-header").fadeIn(500);
				$("#sidebar-hide").animate({
					right: "0px"
				}, 500, "easeInExpo");
				$("#sidebar-expanded").fadeIn(1000).animate({
					right: "0px"
				}, 1000, "easeOutExpo");
			});
		}
		$("#symbol-firma").clearQueue().finish().animate({
			top: "-10px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-punkty").clearQueue().finish().animate({
			top: "45px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-skrzynka").clearQueue().finish().animate({
			top: "300px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-statbar").clearQueue().finish().animate({
			top: "355px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#sidebar-firma").clearQueue().finish().animate({
			top: "0px"
		}, 500, "easeInCirc");
		$("#sidebar-punkty").clearQueue().finish().animate({
			top: "55px"
		}, 500, "easeInCirc");
		$("#sidebar-skrzynka").clearQueue().finish().animate({
			top: "310px"
		}, 500, "easeInCirc");
		$("#sidebar-statbar").clearQueue().finish().animate({
			top: "360px"
		}, 500, "easeInCirc");
		$("#opis-firma").clearQueue().finish().fadeOut(500);
		$("#opis-punkty").clearQueue().finish().delay(500).fadeIn(500);
		$("#opis-skrzynka").clearQueue().finish().fadeOut(500);
		$("#opis-stat").clearQueue().finish().fadeOut(500);
	});
	$("#symbol-skrzynka").click(function() {
		if ($("#sidebar-collapsed").is(":visible")) {
			setupSidebarData();
			$("#sidebar-collapsed").fadeOut(500, function() {
				$("#sidebar").css({
					width: "190px",
					height: "407px"
				});
				$(".sidebar-header").fadeIn(500);
				$("#sidebar-hide").animate({
					right: "0px"
				}, 500, "easeInExpo");
				$("#sidebar-expanded").fadeIn(1000).animate({
					right: "0px"
				}, 1000, "easeOutExpo");
			});
		}
		$("#symbol-firma").clearQueue().finish().animate({
			top: "-10px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-punkty").clearQueue().finish().animate({
			top: "45px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-skrzynka").clearQueue().finish().animate({
			top: "100px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-statbar").clearQueue().finish().animate({
			top: "355px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#sidebar-firma").clearQueue().finish().animate({
			top: "0px"
		}, 500, "easeInCirc");
		$("#sidebar-punkty").clearQueue().finish().animate({
			top: "55px"
		}, 500, "easeInCirc");
		$("#sidebar-skrzynka").clearQueue().finish().animate({
			top: "110px"
		}, 500, "easeInCirc");
		$("#sidebar-statbar").clearQueue().finish().animate({
			top: "360px"
		}, 500, "easeInCirc");
		$("#opis-firma").clearQueue().finish().fadeOut(500);
		$("#opis-punkty").clearQueue().finish().fadeOut(500);
		$("#opis-skrzynka").clearQueue().finish().delay(500).fadeIn(500);
		$("#opis-stat").clearQueue().finish().fadeOut(500);
	});
	$("#symbol-statbar").click(function() {
		if ($("#sidebar-collapsed").is(":visible")) {
			setupSidebarData();
			$("#sidebar-collapsed").fadeOut(500, function() {
				$("#sidebar").css({
					width: "190px",
					height: "407px"
				});
				$(".sidebar-header").fadeIn(500);
				$("#sidebar-hide").animate({
					right: "0px"
				}, 500, "easeInExpo");
				$("#sidebar-expanded").fadeIn(1000).animate({
					right: "0px"
				}, 1000, "easeOutExpo");
			});
		}
		$("#symbol-firma").clearQueue().finish().animate({
			top: "-10px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-punkty").clearQueue().finish().animate({
			top: "45px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-skrzynka").clearQueue().finish().animate({
			top: "100px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-statbar").clearQueue().finish().animate({
			top: "155px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#sidebar-firma").clearQueue().finish().animate({
			top: "0px"
		}, 500, "easeInCirc");
		$("#sidebar-punkty").clearQueue().finish().animate({
			top: "55px"
		}, 500, "easeInCirc");
		$("#sidebar-skrzynka").clearQueue().finish().animate({
			top: "110px"
		}, 500, "easeInCirc");
		$("#sidebar-statbar").clearQueue().finish().animate({
			top: "165px"
		}, 500, "easeInCirc");
		$("#opis-firma").clearQueue().finish().fadeOut(500);
		$("#opis-punkty").clearQueue().finish().fadeOut(500);
		$("#opis-skrzynka").clearQueue().finish().fadeOut(500);
		$("#opis-stat").clearQueue().finish().delay(500).fadeIn(500);
	});

	// hide sidebar
	$("#sidebar-hide").mouseover(function() {
		$(this).css("cursor", "pointer");
	});
	$("#sidebar-hide").click(function() {
		if (!$("#sidebar-collapsed").is(":visible")) {
			$("#sidebar-expanded").fadeOut(500, function() {
				$("#sidebar").css({
					width: "32px",
					height: "265px"
				});
				$(".sidebar-header").fadeOut(500);
				$("#sidebar-hide").animate({
					right: "-40px"
				}, 500, "easeOutExpo");
				$("#sidebar-collapsed").fadeIn(1000).animate({
					right: "-200px"
				}, 1000, "easeOutExpo");
				$("#symbol-firma").clearQueue().finish().animate({
					top: "50px",
					right: "10px"
				}, 500, "easeInCirc");
				$("#symbol-punkty").clearQueue().finish().animate({
					top: "105px",
					right: "10px"
				}, 500, "easeInCirc");
				$("#symbol-skrzynka").clearQueue().finish().animate({
					top: "160px",
					right: "10px"
				}, 500, "easeInCirc");
				$("#symbol-statbar").clearQueue().finish().animate({
					top: "215px",
					right: "10px"
				}, 500, "easeInCirc");
			});
		}
	});

	$(".barbutton3:not(#symbol-hidemap)").tipsy({
		gravity: 'e'
	}); // show tooltips
	$("#symbol-hidemap").tipsy({
		gravity: 'se'
	}); // show tooltips
}

window.updateSidebarRanking = function(newData) {
	if (newData != null) {
		//console.log('=== updateSidebarRanking');
		//console.log(newData);
		window.userdata['firmy_klasy'] = newData;
	}
	var firmy = "";
	var firmyKlasy = jQuery.parseJSON(window.userdata['firmy_klasy']);
	if (window.userdata['firmy_klasy'] != "") {
		for (i = 0; i < firmyKlasy.length; i++) {
			if (firmyKlasy[i]["nazwa"].length <= 1)
				firmy += '<span style="float:left;">firma bez nazwy</span> <span style="float:right;">' + Math.round(firmyKlasy[i]["punkty"]) + '</span><br/>';
			else
				firmy += '<span style="float:left;">' + firmyKlasy[i]["nazwa"] + '</span> <span style="float:right;">' + Math.round(firmyKlasy[i]["punkty"]) + '</span><br/>';
		}
	}
	$("#opis-stat").html(firmy);
}

window.updateSidebarPoints = function(newData) {
	if (newData != null) {
		//console.log('=== updateSidebarPoints');
		//console.log(newData);
		window.userdata['punkty_chemia'] = (!newData.punkty_chemia) ? "0" : newData.punkty_chemia;
		window.userdata['punkty_matematyka'] = (!newData.punkty_matematyka) ? "0" : newData.punkty_matematyka;
		window.userdata['punkty_biologia'] = (!newData.punkty_biologia) ? "0" : newData.punkty_biologia;
		window.userdata['punkty_fizyka'] = (!newData.punkty_fizyka) ? "0" : newData.punkty_fizyka;
		window.userdata['suma_punktow_firmy'] = (!newData.suma_punktow_firmy) ? "0" : newData.suma_punktow_firmy;
		window.userdata["stan_konta"] = (!newData.stan_konta) ? "0" : newData.stan_konta;
	}

	var tmpsum = parseInt(window.userdata['punkty_chemia']) + parseInt(window.userdata['punkty_matematyka']) + parseInt(window.userdata['punkty_biologia']) + parseInt(window.userdata['punkty_fizyka']);
	var tab1 = [parseInt(window.userdata['punkty_chemia']), parseInt(window.userdata['punkty_matematyka']), parseInt(window.userdata['punkty_biologia']), parseInt(window.userdata['punkty_fizyka'])];
	var max = Math.max.apply(Math, tab1);


	var stankonta = (!window.userdata["stan_konta"]) ? "0" : window.userdata["stan_konta"];
	$("#naglowek-tresc").html('<div id="money-icon"></div> <div id="money-number">' + parseFloat(stankonta).toFixed(2) + ' zł</div>'); //Punkty: "+window.userdata['suma_punktow_firmy']);
	$("#chempoints").html(window.userdata['punkty_chemia']);
	$("#matpoints").html(window.userdata['punkty_matematyka']);
	$("#biolpoints").html(window.userdata['punkty_biologia']);
	$("#fizpoints").html(window.userdata['punkty_fizyka']);

	//	var cheight = (parseInt(window.userdata['punkty_chemia'])/tmpsum)*150;
	//	var mheight = (parseInt(window.userdata['punkty_matematyka'])/tmpsum)*150;
	//	var bheight = (parseInt(window.userdata['punkty_biologia'])/tmpsum)*150;
	//	var fheight = (parseInt(window.userdata['punkty_fizyka'])/tmpsum)*150;

	var cheight = (window.userdata['punkty_chemia'] * 100) / max;
	var mheight = (window.userdata['punkty_matematyka'] * 100) / max;
	var bheight = (window.userdata['punkty_biologia'] * 100) / max;
	var fheight = (window.userdata['punkty_fizyka'] * 100) / max;

	//	$("#chart-chem").clearQueue().finish().animate({top:150-cheight,height:cheight},1000,"easeOutCirc");
	//	$("#chart-mat").clearQueue().finish().animate({top:150-mheight,height:mheight},1000,"easeOutCirc");
	//	$("#chart-biol").clearQueue().finish().animate({top:150-bheight,height:bheight},1000,"easeOutCirc");
	//	$("#chart-fiz").clearQueue().finish().animate({top:150-fheight,height:fheight},1000,"easeOutCirc");

	$("#chart-chem").clearQueue().finish().animate({
		height: cheight + '%'
	}, 1000, "easeOutCirc");
	$("#chart-mat").clearQueue().finish().animate({
		height: mheight + '%'
	}, 1000, "easeOutCirc");
	$("#chart-biol").clearQueue().finish().animate({
		height: bheight + '%'
	}, 1000, "easeOutCirc");
	$("#chart-fiz").clearQueue().finish().animate({
		height: fheight + '%'
	}, 1000, "easeOutCirc");

	$("#naglowek-stat").html("Punkty: " + Math.round(window.userdata['suma_punktow_firmy']));
}

/**
 * Print all data fetched from ajax into gui/sidebar etc.
 */
function setupSidebarData(global) // global - do not show loading animation if false
{
	var ref = typeof global !== 'undefined' ? global : true; // refresh

	function displayData() {
		var grupa = '<table style="width:100%">';

		$('#symbol-firma img').attr('src', window.userdata.logo_firmy);

		if (window.userdata['grupa'] != "") {
			var ludzie = jQuery.parseJSON(window.userdata['grupa']);
			for (var i in ludzie) {
				var user = ludzie[i];
				grupa += '<tr><td style="padding:0;text-align:right"><input data-user-id="' + user.id + '" ' + (window.userdata.tura_aktywna ? '' : 'disabled ') + 'class="studentPresent" type="checkbox" title="Obecny?" ' + (user.obecny ? 'checked' : '') + '/></td><td style="padding:0;text-align:center">' + user.imie + ' ' + user.nazwisko + '</td></tr>';
			}
		}

		grupa += "</table>";

		$("#icon-s-mat").tipsy();
		$("#icon-s-fiz").tipsy();
		$("#icon-s-biol").tipsy();
		$("#icon-s-chem").tipsy();

		var dziedzina = window.userdata['dziedzina_firmy'];
		if (dziedzina.length > 0) {
			if (dziedzina == "Matematyka") {
				$("#icon-s-mat").attr('id', 'icon-s-mat-active');
				$("#icon-s-mat-active").tipsy();
			} else if (dziedzina == "Fizyka") {
				$("#icon-s-fiz").attr('id', 'icon-s-fiz-active');
				$("#icon-s-fiz-active").tipsy();
			} else if (dziedzina == "Biologia") {
				$("#icon-s-biol").attr('id', 'icon-s-biol-active');
				$("#icon-s-biol-active").tipsy();
			} else if (dziedzina == "Chemia") {
				$("#icon-s-chem").attr('id', 'icon-s-chem-active');
				$("#icon-s-chem-active").tipsy();
			}
		}

		$("#naglowek-firma").html((window.userdata['nazwa_firmy'].length > 1) ? window.userdata['nazwa_firmy'] : "nienazwana firma");
		$("#opis-firma").html('zalogowany:<br/><span style="font-weight:bold;">' + window.userdata['imie'] + " " + window.userdata['nazwisko'] + "</span><br/><br/>" + 'klasa: <strong>' + window.userdata['klasa'] + '</strong>, szkoła:<br/><span style="font-weight:bold;">' + window.userdata['szkola'] + "</span><br/><br/>" + 'pozostali członkowie firmy:' + window.userdata["ile_czlonkow"] + '<br/>' + grupa);

		$('.studentPresent').tipsy({
			gravity: 'e'
		});
		$('.studentPresent').off('change');
		$('.studentPresent').on('change', function() {
			var _this = $(this);
			var present = _this.is(':checked') ? 1 : 0;
			var userId = _this.attr('data-user-id');
			$('.studentPresent').prop('disabled', true);
			$.ajax({
				type: 'POST',
				url: window.links.studentAjaxMarkStudentPresence,
				data: {
					studentId: userId,
					present: present
				},
				success: function(data) {
					if (data.error) {
						showMessage('Błąd', data.error);
						_this.prop('checked', !present);
					} else $('.studentPresent[data-user-id="' + userId + '"]')
						.prop('checked', data.present);
				},
				error: function() {
					_this.prop('checked', !present);
				},
				complete: function() {
					$('.studentPresent').prop('disabled', false);
				}
			});
		});

		updateSidebarPoints();

		Mailbox.update(window.userdata['naglowki_wiadomosci']);

		updateSidebarRanking();

		// ekran bankructwa
		if (window.userdata["stan_konta"] < 0) {
			bankrutDialogOpen();
		}
	}

	$.ajax({
		url: window.links.studentAjaxGetUserData,
		global: ref, // show loading animation?
		type: 'GET',
		success: function(result) {
			if (result != 0 && result != null) {
				var res = jQuery.parseJSON(result);

				// ===============================================
				// naprawia szybkie przejscie pomiedzy dwoma lekcjami (zanim dojdzie informacja o zakonczeniu poprzedniej)
				if (!ref &&
					(typeof window.userdata !== 'undefined') && (typeof res !== 'undefined') &&
					(typeof window.userdata['tura'] !== 'undefined') && (typeof res['tura'] !== 'undefined')) {
					if (res['tura'] != window.userdata['tura']) {
						if (res['tura_aktywna'] && !window.userdata['tura_aktywna']) {
							// if new lesson
							if ($("#dialog-info").dialog("isOpen") === true) {
								$("#dialog-info").dialog('close');
							}
							$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
								activateInfo(parseInt(res["tura"]));
							});
						} else if (!res['tura_aktywna'] && window.userdata['tura_aktywna']) {
							// if lesson time has passed, notify and disable some features
							if ($("#dialog-info").dialog("isOpen") === true) {
								$("#dialog-info").dialog('close');
							}
							$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
								if (window.userdata.tura <= 4)
									activateInfo(-1);
								else
									activateInfo(0);
							});
						} else if (res['tura_aktywna'] && window.userdata['tura_aktywna']) {
							// if new lesson has started directly after previous one
							// showing welcome screen of next lesson - TEST IT
							if ($("#dialog-info").dialog("isOpen") === true) {
								$("#dialog-info").dialog('close');
							}
							$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
								activateInfo(parseInt(res["tura"]));
							});
						}
						getAllowedInteriors(); // update available actions for this lesson
					} else if (!res['tura_aktywna'] && window.userdata['tura_aktywna']) {
						// if lesson time has passed, notify and disable some features
						if ($("#dialog-info").dialog("isOpen") === true) {
							$("#dialog-info").dialog('close');
						}
						$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
							if (window.userdata.tura <= 4)
								activateInfo(-1);
							else
								activateInfo(0);
						});
					}
				}
				// ===============================================

				window.userdata = res;
				displayData();
			}
		}
	});
}

/**
 * Machine text writer (letter by letter)
 */
$(function($) {
	$.fn.writeText = function(content, callback, charCallback) {
		if (!content) return;

		var contentArray = content.split(""),
			current = 0,
			elem = this;
		elem.html("");

		if (window.typewriter == undefined)
			window.typewriter = [];

		clearInterval(window.typewriter[$(this).attr('id')]);
		var objectId = $(this).attr('id');

		var timeInterval;
		if (window.DEBUG_MODE)
			timeInterval = 3;
		else
			timeInterval = 50;

		window.typewriter[$(this).attr('id')] = setInterval(function() {
			if (current < contentArray.length) {
				if (contentArray[current] == '<') {
					var tag = "";
					while (contentArray[current] != '>') {
						tag += contentArray[current++];
					}
					tag += contentArray[current++];
					elem.html(elem.html() + tag);
				} else {
					elem.html(elem.html() + contentArray[current++]);
				}
				if (charCallback != undefined)
					charCallback();
			} else {
				if (callback != undefined)
					callback();
				clearInterval(window.typewriter[objectId]);
			}
		}, 40); // timeInterval); // 50 //3 //5 //25 //50
	};
});

/**
 * Sets positions of sticked elements to canvas
 */
function adjustDialoguePosition() {
	if (window.game) {
		if (window.game.currentInterior != -1) {
			var interior = window.game.interiors[window.game.currentInterior];
			$(".sticker").each(function() {
				if (interior != undefined && $(this).position() != undefined && $(this).attr('canvasX') != undefined && $(this).attr('canvasY') != undefined) {
					var p = interior.bitmap.localToGlobal($(this).attr('canvasX'), $(this).attr('canvasY'));

					if ($(this).attr('canvasWidth') != undefined) {
						var p2 = interior.bitmap.localToGlobal(parseInt($(this).attr('canvasX')) + parseInt($(this).attr('canvasWidth')), 0);
						$(this).css({
							width: p2.x - p.x
						});
					}

					if ($(this).attr('canvasHeight') != undefined) {
						var p2 = interior.bitmap.localToGlobal(0, parseInt($(this).attr('canvasY')) + parseInt($(this).attr('canvasHeight')));
						$(this).css({
							height: p2.y - p.y
						});
					}

					$(this).css({
						left: p.x,
						top: p.y,
						position: 'absolute'
					});
				}
			});
		} else // city tooltips stickers
		{
			if (window.game.map) {
				var city = window.game.map.bitmap;
				$(".sticker").each(function() {
					if (city != undefined && $(this).position() != undefined && $(this).attr('canvasX') != undefined && $(this).attr('canvasY') != undefined) {
						var p = city.localToGlobal($(this).attr('canvasX'), $(this).attr('canvasY'));
						$(this).css({
							left: p.x,
							top: p.y,
							position: 'absolute'
						});
					}
				});
			}
		}
	}
}

$(window).resize(function() {
	adjustDialoguePosition();
}).mouseup(function() {
	adjustDialoguePosition();
}).mousedown(function() {
	adjustDialoguePosition();
}).mousemove(function() {
	adjustDialoguePosition();
});

//dialog potwierdzenia
function ask(title, message, callback, cbFalse, xclass) {
	var cancel = true;
	$((xclass ? '<div class="' + xclass + '">' : '<div>') + message + '</div>').dialog({
		title: title,
		modal: true,
		resizeable: false,
		draggable: false,
		dialogClass: 'przedsiebiorcaCommonDialog',
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		buttons: [{
			text: 'Tak',
			click: function() {
				cancel = false;
				$(this).dialog('close');
				callback();
			}
		}, {
			text: 'Nie',
			click: function() {
				$(this).dialog('close');
			}
		}],
		close: function() {
			if (cancel && cbFalse)
				cbFalse();
			$(this).parent().remove();
		},
	});
}

function askEn(title, message, callback, cbFalse, xclass) {
	var cancel = true;
	$((xclass ? '<div class="' + xclass + '">' : '<div>') + message + '</div>').dialog({
		title: title,
		modal: true,
		resizeable: false,
		draggable: false,
		dialogClass: 'przedsiebiorcaCommonDialog',
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		buttons: [{
			text: 'Yes',
			click: function() {
				cancel = false;
				$(this).dialog('close');
				callback();
			}
		}, {
			text: 'No',
			click: function() {
				$(this).dialog('close');
			}
		}],
		close: function() {
			if (cancel && cbFalse)
				cbFalse();
			$(this).parent().remove();
		},
	});
}

//okno dialogowe
function showMessage(title, message, options) {
	$('<div>' + message + '</div>').dialog({
		title: title,
		draggable: false,
		modal: true,
		dialogClass: 'przedsiebiorcaCommonDialog',
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		buttons: [{
			text: 'OK',
			click: function() {
				$(this).dialog('close');
				if (options != null && options.ok != null)
					options.ok();
			}
		}],
		close: function() {
			$(this).parent().remove();
			if (options != null && options.close != null)
				options.close();
		},
	});
}

function showCustomMessage(title, message, options, width) {
	$('<div>' + message + '</div>').dialog({
		title: title,
		draggable: false,
		modal: true,
		dialogClass: 'przedsiebiorcaCommonDialog',
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		buttons: [{
			text: 'OK',
			click: function() {
				$(this).dialog('close');
				if (options != null && options.ok != null)
					options.ok();
			}
		}],
		close: function() {
			$(this).parent().remove();
			if (options != null && options.close != null)
				options.close();
		},
		width: width,
	});
}

function formatInterval(interval) {
	if (interval >= 60 * 60)
		interval = Math.round(interval / 60);
	var minutes = Math.floor(interval / 60);
	var mm = minutes < 10 ? '0' + minutes : minutes;
	var seconds = Math.floor(interval % 60);
	var ss = seconds < 10 ? '0' + seconds : seconds;
	return mm + ':' + ss;
}

// --- MAILBOX ---
Mailbox = {
	getMessage: function(id) {
		var messages = jQuery.parseJSON(window.userdata['naglowki_wiadomosci']);
		for (var i in messages)
			if (messages[i].id === id)
				return messages[i];
		return null;
	},
	update: function(data) {
		$("#naglowek-skrzynka").html("skrzynka odbiorcza");

		var skrzynka = '<div style="height:160px;overflow:hidden">';
		var skrzynkaNaglowki = jQuery.parseJSON(data);
		var notRead = 0;

		for (var i in skrzynkaNaglowki) {
			var msg = skrzynkaNaglowki[i];
			if (msg.przeczytana === '0') notRead++;
			skrzynka += '<div data-messageId="' + msg.id + '" class="mailboxMessage' + (msg.przeczytana === '0' ? ' toRead' : '') + '">' + msg.naglowek.substring(0, 22) + '...</div>';
		}

		$('#mailbox-counter').text(notRead);
		if (notRead)
			$('#mailbox-counter').fadeIn();
		else
			$('#mailbox-counter').fadeOut();
		skrzynka += '</div><div class="mailboxSeeAll">&lt; wszystkie wiadomości &gt;</div>';
		$("#opis-skrzynka").html(skrzynka);

		$('.mailboxMessage').off('click.SideBarMailbox');
		$('.mailboxMessage').on('click.SideBarMailbox', function() {
			if (!$(".ui-dialog-content").is(':visible')) {
				var messageId = $(this).attr('data-messageId');
				var message = Mailbox.getMessage(messageId);
				if (message === null) return;
				var currMsg = $('.mailboxMessagePreview[data-msgdlgid]');
				$('.mailboxMessagePreview').each(function() {
					if ($(this).hasClass('ui-dialog-content'))
						$(this).dialog('close');
				});
				if (currMsg.length > 0 && currMsg.attr('data-msgdlgid') === messageId)
					return;
				if ($(this).hasClass('toRead'))
					Mailbox.markAsRead(messageId);
				var dialog = $('<div data-msgdlgid="' + message.id + '" class="mailboxMessagePreview" title="Wiadomość">' +
					'	<div id="mainblock" style="width: 100%; clear: both; overflow: hidden;">' +
					'		<div class="barbutton2 hover2" style="cursor: default; background: url(\'' + window.links.baseUrl + '/images/gui/info-icon-sm.png\') no-repeat; width:35px; height: 35px; float: left; border:0; padding:0; position: absolute; top:7px; left:2px; z-index: 999;"></div>' +
					'		<div class="row" style="text-align:center;padding-left:40px;padding-right:40px">' + message.naglowek + '</div>' +
					'		<div class="register-form-left" style="float: right;">' +
					'			<div class="row infodiv">' + message.tresc + '</div>' +
					'		</div>' +
					'	</div>' +
					'	<div class="row buttons" style="width: 100%; text-align: center;">' +
					'		<input type="button" value="OK" class="infodialog-button-ok ui-button ui-widget ui-state-default ui-corner-all" role="button" aria-disabled="false" style="display: inline-block;">' +
					'	</div>' +
					'</div>');
				dialog.find('.infodialog-button-ok').click(function() {
					dialog.dialog('close');
					$.ajax({
						url: window.links.studentAjaxGetUserData,
						global: false,
						type: 'GET',
						success: function(result) {
							if (result != 0 && result != null) {
								var res = jQuery.parseJSON(result);
								window.userdata = res;
								Mailbox.update(window.userdata['naglowki_wiadomosci']);
							}
						}
					});
				});
				dialog.dialog({
					autoOpen: true,
					hide: {
						effect: 'clip',
						duration: 500
					},
					show: {
						effect: 'scale',
						duration: 600
					},
					close: function() {
						$(this).remove();
					},
					position: {
						my: "center",
						at: "center",
						of: window
					},
					closeOnEscape: false,
					draggable: true,
					resizable: false,
					width: 500,
				});
			} else {
				$(".ui-dialog-title").effect("pulsate", {}, 700);
			}
		});

		$('.mailboxSeeAll').off('click.SideBarMailbox');
		$('.mailboxSeeAll').on('click.SideBarMailbox', function() {
			if (!$(".ui-dialog-content").is(':visible'))
				window.location.hash = 'skrzynka';
			else
				$(".ui-dialog-title").effect("pulsate", {}, 700);
		});
	},
	markAsRead: function(messageId) {
		$.ajax({
			type: 'POST',
			url: window.links.studentAjaxMessageMarkRead,
			global: false,
			data: {
				messageId: messageId
			},
			success: function(data) {
				if (data.error === undefined) {
					var counter = parseInt($('#mailbox-counter').text());
					counter--;
					if (counter < 0) counter = 0;
					if (counter === 0)
						$('#mailbox-counter').fadeOut();
					$('#mailbox-counter').text(counter);
					$('.toRead[data-messageId="' + messageId + '"]').removeClass('toRead');
					getAllowedInteriors();

					//$.get(window.links.studentAjaxGetChildAction, { "ostatnia_akcja" : data.idakcji , "tura" : window.userdata["tura"] }, function(re) {
					$.ajax({
						url: window.links.studentAjaxGetChildAction,
						global: false,
						type: 'GET',
						data: {
							"ostatnia_akcja": data.idakcji,
							"tura": window.userdata["tura"]
						},
						success: function(re) {
							if (re > 0) {
								//$.get(window.links.studentAjaxInfoSubmit, { "tura" : window.userdata["tura"], "akcja" : re, "przeczytana" : 0 }, function(ret) {});
								$.ajax({
									url: window.links.studentAjaxInfoSubmit,
									global: false,
									type: 'GET',
									data: {
										"tura": window.userdata["tura"],
										"akcja": re,
										"przeczytana": 0
									}
								});
							}
						}
					});
				}
			},
		});

	}
}

$(document).off('click.przedsiebiorcaHandlePayments');
$(document).on('click.przedsiebiorcaHandlePayments', '.payTax', function() {
	window.oplaty = new Array();
	window.oplaty.kontrahentId = $(this).attr('data-kontrahentid');
	window.oplaty.idFirmy = $(this).attr('data-idfirmy');
	window.oplaty.rodzajOplaty = $(this).attr('data-rodzajoplaty');
	window.oplaty.title = $(this).attr('data-title');
	window.oplaty.wartosc = $(this).attr('data-wartosc');
	window.oplaty.updated = true;

	if (window.location.hash == '#internetBankowosc') {
		var delay = (function() {
			var timer = 0;
			return function(callback, ms) {
				clearTimeout(timer);
				timer = setTimeout(callback, ms);
			};
		})();
		window.location.hash = 'internet';
		delay(function() {
			window.location.hash = 'internetBankowosc';
		}, 1000);
	} else
		window.location.hash = 'internetBankowosc';

	return false;
});
$(document).on('click.przedsiebiorcaHandlePayments', '.payVat', function() {
	window.oplaty = new Array();
	window.oplaty.kontrahentId = $(this).attr('data-kontrahentid');
	window.oplaty.idFirmy = $(this).attr('data-idfirmy');
	window.oplaty.rodzajOplaty = $(this).attr('data-rodzajoplaty');
	window.oplaty.title = $(this).attr('data-title');
	window.oplaty.wartosc = $(this).attr('data-wartosc');
	window.oplaty.updated = true;

	if (window.location.hash == '#internetBankowosc') {
		var delay = (function() {
			var timer = 0;
			return function(callback, ms) {
				clearTimeout(timer);
				timer = setTimeout(callback, ms);
			};
		})();
		window.location.hash = 'internet';
		delay(function() {
			window.location.hash = 'internetBankowosc';
		}, 1000);
	} else
		window.location.hash = 'internetBankowosc';

	return false;
});
$(document).on('click.przedsiebiorcaHandlePayments', '.payOffice', function() {
	window.oplaty = new Array();
	window.oplaty.kontrahentId = $(this).attr('data-kontrahentid');
	window.oplaty.idFirmy = $(this).attr('data-idfirmy');
	window.oplaty.rodzajOplaty = $(this).attr('data-rodzajoplaty');
	window.oplaty.title = $(this).attr('data-title');
	window.oplaty.wartosc = $(this).attr('data-wartosc');
	window.oplaty.updated = true;

	if (window.location.hash == '#internetBankowosc') {
		var delay = (function() {
			var timer = 0;
			return function(callback, ms) {
				clearTimeout(timer);
				timer = setTimeout(callback, ms);
			};
		})();
		window.location.hash = 'internet';
		delay(function() {
			window.location.hash = 'internetBankowosc';
		}, 1000);
	} else
		window.location.hash = 'internetBankowosc';


	return false;
});


$(document).off('click.przedsiebiorcaHandleTendersMail');
$(document).on('click.przedsiebiorcaHandleTendersMail', '.gotoTender[data-kontrahentid]', function() {

	function getKontrahentBuildingId(kontrahentId) {
		var kontrahenci = jQuery.parseJSON(window.userdata['kontrahenci']);
		for (var i in kontrahenci) {
			var kontrahent = kontrahenci[i];
			if (kontrahent.id == kontrahentId)
				return i;
		}
		return null;
	}

	var kontrahentId = $(this).attr('data-kontrahentid');

	var buildingId = getKontrahentBuildingId(kontrahentId);

	var building = window.game.map.getBuildingById(buildingId);

	if (building) {
		Building.current = building;
		window.location.hash = 'biuroZlecenia1';
	}

	return false;
});

$(document).on('click.przedsiebiorcaHandleTendersMail', 'a[accept][invitationid]', function() {

	var accept = $(this).attr('accept');
	var invId = $(this).attr('invitationid');

	$('<div><table style="width:100%;height:90%;background:rgba(255,255,255,0.4)">' + '<tr><td class="msg" style="text-align:center">Proszę czekać...</td></tr></table></div>').dialog({
		title: 'Wysyłanie żądania',
		modal: true,
		autoOpen: true,
		closeOnEscape: false,
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		open: function() {
			var _dlg = $(this);
			$.ajax({
				type: 'POST',
				url: window.links.studentAjaxAcceptOrderInvitation,
				data: {
					accept: accept,
					invitationId: invId
				},
				success: function(data) {
					if (data.error)
						_dlg.find('.msg').html(data.error);
					else
						_dlg.dialog('close');
				},
			});
		},
		close: function() {
			$(this).parent().remove();
		},
		position: {
			my: 'center',
			at: 'center',
			of: window
		},
		buttons: [{
			text: 'OK',
			click: function() {
				$(this).dialog('close');
			}
		}],
		draggable: true,
		resizable: false,
		width: 400,
		height: 400
	});

	return false;
});

$(document).on('click.przedsiebiorcaHandleTendersMail', 'a.bonusTasksLink', function() {
	var lang = $(this).attr('data-lang');

	if (window.location.hash.length && window.location.hash != 'city')
		window.location.hash = 'city';

	$(this).parents('.mailboxMessagePreview').dialog('close');

	function enableBts(en) {

	}

	tasksDialogOpen({
		endpointParams: {
			lang: lang
		},
		endpoint: window.links.studentAjaxFetchBonusTasks,
		maxTasks: 0,
		tasks: 0,
		actions: ['Select'],
		vat: 0.23,
		title: 'Bonusowe zlecenia',
		enable: enableBts
	});

	return false;
});


function tasksDialogOpen(options) {
	// if (window.tasksDialog) {
	console.log(options);
	if (parseInt(options.endpointParams.lang) == 1)
		window.tasksDialogEn(options);
	else
		window.tasksDialog(options);
	// } else {
	// 	yepnope([{
	// 		load: window.links.baseUrl + '/js/gui/gui-taskslist.js',
	// 		complete: function() {
	// 			window.tasksDialog(options);
	// 		}
	// 	}]);
	// }
}

function bankrutDialogOpen(force) {
	// if (window.activateBankrut) {
		if (force) {
			window.BankrutDlgLastFired = 0;
			window.BankrutDlgOpened = 0;
		}
		window.activateBankrut(force);
	// } else
	// 	yepnope([{
	// 		load: window.links.studentModuleBankrut,
	// 		complete: function() {
	// 			window.BankrutDlgLastFired = 0;
	// 			window.BankrutDlgOpened = 0;
	// 			window.activateBankrut(force);
	// 		}
	// 	}]);
}

function showMinimap() {

	if (!$(".ui-dialog-content").is(':visible')) {
		if ($("#minimap").not(":visible")) {
			$("#minimap").show();
			checkSize();
			$("#minimap").hide();
			$("#minimap").fadeIn(1000); //, function() { checkSize(); });
			$("#symbol-hidemap").clearQueue().finish().animate({
				"right": "250px"
			}, 1000, "easeOutExpo");
			$("#bottombar").clearQueue().finish().animate({
				right: "0px"
			}, 1000, "easeOutExpo");
			$("#rightbuttons").clearQueue().finish().animate({
				marginRight: "321px"
			}, 1000, "easeOutExpo"); //350
			$("#symbol-hidemap-img").removeClass("showmap");
			$("#symbol-hidemap-img").addClass("hidemap");

		}

		if ($("#rightbuttons").not(":visible"))
			$("#rightbuttons").fadeIn(500, function() {
				if (($("#minimap").is(":visible") && (window.innerWidth < 1216)) || ($("#minimap").not(":visible") && (window.innerWidth < 945))) // 1162  891
					$("#buttons").clearQueue().finish().animate({
					height: "110px"
				}, 500, "easeOutExpo");
			});

		$("#button-back").hide();
		//$(".tipsy-inner").tipsy().hide();

		window.location.hash = "city";
	} else {
		$(".ui-dialog-title").effect("pulsate", {}, 700);
	}
	return this;
}

function browser_close() {
	if (window.userdata['ilosc_biur'] == 0) {
		showMinimap();
	} else {
		window.location.hash = '#biuroGracza';
	}
}

/** GUI minimap **/

$(function() {

        /* radar settings */
        var wratio = 4096 / window.innerWidth;
        var hratio = 2160 / window.innerHeight;
        var mw = $("#minimap").width();
        var mh = $("#minimap").height();
        var mwratio = mw / wratio;
        var mhratio = mh / hratio;
        $("#minimap-radar").width(mwratio);
        $("#minimap-radar").height(mhratio);
        var vpos = mw / 2 - mwratio / 2;
        var hpos = mh / 2 - mhratio / 2;
        $("#minimap-radar").css({
                "left": vpos + "px",
                "top": hpos + "px"
        });

        /**
         * Minimap events
         **/
        var minimapClicked = false;

        var rw = $("#minimap-radar").width();
        var rh = $("#minimap-radar").height();
        $("#minimap").mousedown(function(ev) {
                if (!minimapClicked && $("#minimap-linkback").css("display") == "none") {
                        minimapEvent(ev);
                        minimapClicked = true;
                }
        });
        $("#minimap").mousemove(function(ev) {
                if (minimapClicked) minimapEvent(ev);
        });
        $("#minimap").mouseup(function() {
                minimapClicked = false;
        });
        $("#minimap-radar").mousedown(function(ev) {
                if ($("#minimap-linkback").css("display") == "none") {
                        ev.preventDefault();
                        ev.stopPropagation();
                        minimapClicked = true;
                }
        });
        $("#minimap-radar").mousemove(function(ev) {});
        $("#minimap-radar").mouseup(function() {
                minimapClicked = false;
        });

        function minimapEvent(ev) {
                rw = $("#minimap-radar").width();
                rh = $("#minimap-radar").height();
                moffl = $('#minimap').offset().left;
                mofft = $('#minimap').offset().top;
                ox = ev.pageX - moffl - rw / 2;
                oy = ev.pageY - mofft - rh / 2;

                if (ox < 0 || isNaN(ox)) ox = 0;
                if (oy < 0 || isNaN(oy)) oy = 0;
                if (ox > mw - rw) ox = mw - rw - 5;
                if (oy > mh - rh) oy = mh - rh - 5;

                $("#minimap-radar").css({
                        left: ox + "px",
                        top: oy + "px"
                });
                game.container.x = -1 * (ox / (mw - rw)) * (game.map.image.width - game.canvas.width);
                game.container.y = -1 * (oy / (mh - rh)) * (game.map.image.height - game.canvas.height);
        }
        $("#minimap-linkback").mouseover(function(ev) {
                $("#minimap-linkback").css({
                        "background-color": "rgba(0, 0, 0, 0.3)",
                        "cursor": "pointer"
                });
        });
        $("#minimap-linkback").mouseout(function(ev) {
                $("#minimap-linkback").css({
                        "background-color": "transparent",
                        "cursor": "default"
                });
        });
        $("#minimap-linkback").click(function(ev) {
                if ($("#rightbuttons").not(":visible"))
                        $("#rightbuttons").fadeIn(500, function() {
                                if (($("#minimap").is(":visible") && (window.innerWidth < 1216)) || ($("#minimap").not(":visible") && (window.innerWidth < 945))) // 1162  891
                                        $("#buttons").clearQueue().finish().animate({
                                        height: "110px"
                                }, 500, "easeOutExpo");
                        });

                $("#button-back").show(); //fadeOut(1000);
                window.location.hash = "city";
        });
});

////////////////////////////////////////////////////////////////////////////////

/**
 * options:
 *    X Int kontrahent - id kontrahenta
 *		X Url endpoint - url to fetch data from
 *		Array actions - list of actions
 *		X String title - dialog title
 *		X Callback enable(en) - callback
 *
 *		kontrahent
 *
 */
function tasksDialog(options) {
	var originalData;
	var filteredData;
	var sortedData;
	var vat = options.vat;
	var BROWSER;

	var actionSelect = {
		title: 'Wybierz',
		handler: function(task, link) {
			if (options.tasks >= options.maxTasks)
				showMessage('Informacja', 'Nie możesz podjąć się wiekszej ilości zleceń na tym etapie gry.');
			else {
				var template = '<div>' +
					'<div class="barbutton2 hover2" style="cursor: default; background: url(\'' + window.links.baseUrl + '/images/gui/info-icon-sm.png\') no-repeat; width:35px; height: 35px; float: left; border:0; padding:0; position: absolute; top:7px; left:2px; z-index: 999;"></div>' +
					'<div class="row" style="text-align:center;padding-left:40px;padding-right:40px">UMOWA O ŚWIADCZENIE USŁUG</div>' +
					'<div class="register-form-left" style="float: right;"><div class="row infodiv" style="width: calc(100% - 40px);font-size:small;margin-top: 1px;margin-left: 10px;margin-right: 10px;margin-bottom: 10px;">' +
					'<p style="margin-bottom:1em">Zawarta dnia ' + $.datepicker.formatDate('yy-mm-dd', new Date()) + ' roku, w miejscowości: ' + options.city + ' pomiędzy ' + userdata.nazwa_firmy + ' zwaną dalej „Wykonawcą”, a ' + task.kontrahent.nazwa + ' zwaną dalej „Zamawiającym”, o treści następującej: </p>' +
					'<p style="margin-bottom:1em;text-align:center;font-weight:bold">$1</p>' +
					'<p style="margin-bottom:1em">Wykonawca zobowiązuje się do realizacji zadania ' + task.dziedzina + (task.kategoria ? ' - ' + task.kategoria : '') + ' - ' + task.poziom + ' na rzecz Zamawiającego.</p>' +
					'<p style="margin-bottom:1em;text-align:center;font-weight:bold">$2</p>' +
					'<p style="margin-bottom:1em">Z tytułu wykonania zleceń wchodzących w zakres niniejszej umowy Zamawiający zapłaci Wykonawcy wynagrodzenie w wysokości ' + task.cena + ' zł netto.</p>' +
					'<p style="margin-bottom:1em;text-align:center;font-weight:bold">$3</p><ol>' +
					'<li>Wykonawca zobowiązuje się do wykonania zadania w terminie ' + options.periodDays + ' dni od daty popisania umowy.</li>' +
					'<li>Zamawiający rości sobie prawo do nałożenia na Wykonawcę kary w wysokości ' + task.kara + '% kwoty wartości zlecenia (' + (task.kara / 100 * task.cena) + ' zł).</li>' +
					'</ol></div></div>' +
					'<div style="margin-left:15px">Przydziel do: ' + options.workerList + '</div>' +
					'</div>';
				$(template).dialog({
					title: 'Umowa',
					modal: true,
					autoOpen: true,
					closeOnEscape: false,
					open: function() {
						var dlg = $(this);
						dlg.find('select').change(function() {
							dlg.find('.stats').remove();
							var select = $(this);
							var sel = select.val();
							var workerId = -1;
							if (sel.indexOf('w') === 0)
								workerId = sel.substring(1);
							else return;
							$.ajax({
								type: 'GET',
								url: window.links.studentAjaxSimTaskAssign,
								data: {
									taskId: task.id,
									workerId: workerId
								},
								success: function(data) {
									if (data.stats) {
										var s = data.stats;
										var durationColor;
										if (s.duration < s.taskEnd)
											durationColor = 'green';
										else if (s.duration > s.taskEnd)
											durationColor = 'red';
										else
											durationColor = 'yellow';
										var gradient = [{
											value: 0.00,
											color: [255, 000, 000]
										}, {
											value: 0.60,
											color: [255, 000, 000]
										}, {
											value: 0.75,
											color: [255, 255, 000]
										}, {
											value: 0.95,
											color: [000, 255, 000]
										}, {
											value: 1.00,
											color: [000, 255, 000]
										}];
										var color = [0, 0, 0];
										for (var i = 0; i < gradient.length - 1; i++) {
											var A = gradient[i];
											var B = gradient[i + 1];
											if (s.propability >= A.value && s.propability <= B.value) {
												var sum = (B.value - A.value);
												var a = 1 - (s.propability - A.value) / sum;
												var b = 1 - (B.value - s.propability) / sum;
												color = [
													Math.round(a * A.color[0] + b * B.color[0]),
													Math.round(a * A.color[1] + b * B.color[1]),
													Math.round(a * A.color[2] + b * B.color[2])
												];
												break;
											}
										}
										var html = '<span style="padding-left:5px;font-weight:bold;" class="stats"><span style="color:' + durationColor + '">' + s.duration + ' ' + s.durationUnit + '</span> <span style="text-shadow:1px 1px 2px black;color:rgb(' + color[0] + ', ' + color[1] + ', ' + color[2] + ')">' + Math.round(s.propability * 100) + '%</span></span>';
										select.after(html);
									}
								},
								complete: function() {
									options.enable(true);
								}
							});
						});
					},
					hide: {
						effect: 'clip',
						duration: 500
					},
					show: {
						effect: 'scale',
						duration: 600
					},
					close: function() {
						$(this).parent().remove();
					},
					position: {
						my: 'center',
						at: 'center',
						of: window
					},
					draggable: true,
					resizable: false,
					width: 500,
					height: 580,
					buttons: [{
						text: 'Zgadzam się',
						click: function() {
							var params = {
								taskId: task.id,
								kontrahentId: task.idKontrahenta
							};
							var sel = $(this).find('select').val();
							if (!sel) return;
							if (sel.indexOf('s') === 0)
								params.studentId = sel.substring(1);
							else if (sel.indexOf('w') === 0)
								params.workerId = sel.substring(1);
							var _dlg = $(this);
							options.enable(false);
							$.ajax({
								type: 'POST',
								url: window.links.studentAjaxTakeTask,
								data: params,
								success: function(data) {
									if (data.error)
										showMessage('Błąd', data.error);
									else {
										options.workerList = data.workerList;
										options.city = data.city;
										options.periodDays = data.periodDays;
										_dlg.dialog('close');
										BROWSER.find('.tasksBoxCount').text(++options.tasks);
										link.parent().parent().fadeOut(400, function() {
											$(this).remove();
										});
									}
								},
								complete: function() {
									options.enable(true);
								}
							});
						}
					}, {
						text: 'Anuluj',
						click: function() {
							$(this).dialog('close')
						}
					}, ]
				});
			}
		}
	};

	for (var i in options.actions) {
		var action = options.actions[i];
		if (action == 'Select')
			options.actions[i] = actionSelect;
	}

	var sorter = {
		field: null,
		order: '',
		run: function(display) {
			var _field = this.field;
			if (_field != null) {
				sortedData = filteredData.slice(0);
				var _order = this.order;
				if (_order.length)
					sortedData.sort(function(a, b) {
						return a[_field] == b[_field] ? 0 : (
							a[_field] < b[_field] ? (_order == 'asc' ? -1 : 1) : (_order == 'asc' ? 1 : -1)
						);
					});
			} else sortedData = filteredData;
			if (display == null) display = true;
			if (display) displayData();
		}
	}

	function installControls() {
		BROWSER.find('a.sort').off('click');
		BROWSER.find('a.sort').removeClass('asc').removeClass('desc');
		BROWSER.find('a.sort').on('click', function() {
			var _this = $(this);
			sorter.field = _this.attr('data-field');
			if (_this.hasClass('asc')) {
				_this.removeClass('asc');
				sorter.order = 'desc';
			} else if (_this.hasClass('desc')) {
				sorter.order = '';
				_this.removeClass('desc');
			} else sorter.order = 'asc';
			BROWSER.find('a.sort').removeClass('asc').removeClass('desc');
			_this.addClass(sorter.order);
			sorter.run();
			return false;
		});
		//===============================
		BROWSER.find('.filter').val('');
		BROWSER.find('.filter').off('change');
		BROWSER.find('.filter').on('change', function() {
			var _this = $(this);
			var value = _this.val();

			var filters = BROWSER.find('.filter');
			filteredData = [];
			for (var i in originalData) {
				var data = originalData[i];
				var push = true;
				for (var x = 0; x < filters.length; x++) {
					function filterNumber(operator, a, b) {
						if (operator === '=')
							push = push && a == b;
						else if (operator === '!')
							push = push && a != b;
						else if (operator === '>')
							push = push && a > b;
						else if (operator === '<')
							push = push && a < b;
						else
							push = push && a == b;
					}
					var filter = $(filters[x]);
					var value = filter.val();
					if (value != '') {
						var field = filter.attr('data-field');
						var inValue = data[field];
						if (filter.hasClass('time')) {
							var operator = value.substring(0, 1);
							var a = parseFloat(inValue);
							var b = timeToInt('=!<>'.indexOf(operator) > -1 ? value.substring(1) : value);
							filterNumber(operator, a, b);
						} else if (filter.hasClass('numeric')) {
							var operator = value.substring(0, 1);
							var a = parseFloat(inValue);
							var b = parseFloat('=!<>'.indexOf(operator) > -1 ? value.substring(1) : value);
							filterNumber(operator, a, b);
						} else if (filter.hasClass('text'))
							push = push && inValue !== undefined && inValue.toLowerCase().indexOf(value.toLowerCase()) > -1;
						else
							push = push && inValue == value;
					}
				}
				if (push) filteredData.push(data);
			}
			sorter.run();
		});
	}

	function findTask(id) {
		for (var x in sortedData)
			if (sortedData[x].id == id)
				return sortedData[x];
		return null;
	}

	function timeToInt(tm) {
		var arr = tm.split(':'),
			result = 0;
		for (var i = arr.length - 1, m = 1; i >= 0; i--, m *= 60)
			result += parseInt(arr[i]) * m;
		return result;
	}

	function displayData() {
		var html = '';
		if (sortedData == null || sortedData.length == 0)
			html = '<tr><td colspan="7" style="text-align:center;padding-top:20px;"><i>Brak wyników</i></td></tr>';
		else
			for (var i in sortedData) {
				var item = sortedData[i];
				var actions = '';
				if (item.allowed)
					for (var x in options.actions) {
						var act = options.actions[x];
						actions += '<a data-handler="' + x + '" class="action" taskId="' + item.id + '" href="#">[' + act.title + ']</a> ';
					}
				html += '<tr' + (!item.allowed ? ' class="disabled"' : '') + '>' +
					'<td><img src="' + window.links.baseUrl + '/images/gui/' + item.dziedzina.toLowerCase() + '.png" title="' + item.dziedzina + '" alt="' + item.dziedzina + '" /></td>' +
					'<td>' + (item.kategoria !== undefined ? item.kategoria : 'n/a') + '</td>' +
					'<td>' + item.poziom + '</td>' +
					'<td>' + parseFloat(item.cena * (1.0 + vat)).toFixed(2) + '</td>' +
					'<td>' + item.kara + '</td>' +
					'<td>' + formatInterval(item.czas) + '</td>' +
					'<td>' + actions + '</td>' +
					'</tr>';
			}
		BROWSER.find('.tasksBoxBody').html(html);
		for (var x in options.actions) {
			var objects = BROWSER.find('a.action[data-handler="' + x + '"]');
			objects.click(function() {
				var taskId = $(this).attr('taskId');
				var x = $(this).attr('data-handler');
				options.actions[x].handler(findTask(taskId), $(this), options);
				return false;
			});
		}
	}

	function refresh() {
		options.enable(false);
		BROWSER.find('.tasksBoxWait').find('td').text('Proszę czekać...');
		$.ajax({
			type: 'GET',
			url: options.endpoint,
			data: options.endpointParams,
			success: function(data) {
				if (data.error) {
					BROWSER.find('.tasksBoxWait').find('td').text(data.error);
					return;
				}
				options.maxTasks = data.max;
				options.tasks = data.cnt;
				BROWSER.find('.tasksBoxCount').text(options.tasks);
				BROWSER.find('.tasksBoxMaxCount').text(options.maxTasks);
				options.workerList = data.workerList;
				options.city = data.city;
				options.periodDays = data.periodDays;
				originalData = data.data;
				filteredData = originalData;
				sortedData = filteredData;
				installControls();
				BROWSER.find('.tasksBoxWait').fadeOut(400, function() {
					displayData();
					BROWSER.find('.tasksBoxContainer').fadeIn();
				});
			},
			error: function(xhr, status, error) {
				BROWSER.find('.tasksBoxWait').find('td').text(status + ' ' + error);
			},
			complete: function() {
				options.enable(true);
			}
		});
	}

	var dlgTemplate =
		'<div class="biuroZleceniaXrDialogCls" xid="biuroZleceniaXrDialog">' +
		'	<table class="tasksBoxWait">' +
		'		<tr>' +
		'			<td>Proszę czekać...</td>' +
		'		</tr>' +
		'	</table>' +
		'	<div class="tasksBoxContainer">' +
		'		<table class="tasksBoxContainerOuterTable">' +
		'			<thead>' +
		'				<tr>' +
		'					<th>' +
		'						<a class="sort" data-field="dziedzina" href="#">Dziedzina</a><br>' +
		'						<select class="filter" data-field="dziedzina" name="filter_dziedzina">' +
		'							<option value="" selected="selected"></option>' +
		'							<option value="Matematyka">Mat</option>' +
		'							<option value="Fizyka">Fiz</option>' +
		'							<option value="Biologia">Biol</option>' +
		'							<option value="Chemia">Chem</option>' +
		'						</select>' +
		'					</th>' +
		'					<th>' +
		'						<a class="sort" data-field="kategoria" href="#">Kategoria</a><br>' +
		'						<input size="10" class="filter text" data-field="kategoria" type="text" value="" name="filter_kategoria"></th>' +
		'					<th>' +
		'						<a class="sort" data-field="poziom" href="#">Poziom</a><br>' +
		'						<select class="filter" data-field="poziom" name="filter_poziom">' +
		'							<option value="" selected="selected"></option>' +
		'							<option value="Łatwe">Łatwe</option>' +
		'							<option value="Trudne">Trudne</option>' +
		'							<option value="Bardzo trudne">Bardzo trudne</option>' +
		'						</select></th>' +
		'					<th>' +
		'						<a class="sort" data-field="cena" href="#">Cena [zł]</a><br>' +
		'						<input size="10" class="filter numeric" data-field="cena" type="text" value="" name="filter_cena"></th>' +
		'					<th>' +
		'						<a class="sort" data-field="kara" href="#">Kara [%]</a><br>' +
		'						<input size="10" class="filter numeric" data-field="kara" type="text" value="" name="filter_kara"></th>' +
		'					<th>' +
		'						<a class="sort" data-field="czas" href="#">Czas</a><br>' +
		'						<input size="10" class="filter time" data-field="czas" type="text" value="" name="filter_czas"></th>' +
		'					<th></th>' +
		'				</tr>' +
		'			</thead>' +
		'			<tbody class="tasksBoxBody">' +
		'			</tbody>' +
		'		</table>' +
		'		<div>' +
		'			<span style="float:right"><span class="tasksBoxCount">?</span> / <span class="tasksBoxMaxCount">?</span></span>' +
		'		</div>' +
		'	</div>' +
		'</div>';

	BROWSER = $(dlgTemplate);
	BROWSER.dialog({
		title: options.title,
		modal: true,
		autoOpen: true,
		closeOnEscape: false,
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		open: function() {
			refresh();
		},
		close: function() {
			BROWSER.find('.tasksBoxBody').html('');
			BROWSER.find('.tasksBoxContainer').hide();
			BROWSER.find('.tasksBoxWait').show();
			$(this).parent().remove();
		},
		position: {
			my: "center",
			at: "center",
			of: window
		},
		draggable: true,
		resizable: false,
		width: 950,
		height: 450
	});

	BROWSER.find('.tasksBoxBodyRefresh').click(function() {
		BROWSER.find('.tasksBoxContainer').fadeOut(400, function() {
			BROWSER.find('.tasksBoxWait').fadeIn(400, refresh);
		});
		return false;
	});
}

/* TASKS Dialog EN */

function tasksDialogEn(options) {
	var originalData;
	var filteredData;
	var sortedData;
	var vat = options.vat;
	var BROWSER;

	var actionSelect = {
		title: 'Select',
		handler: function(task, link) {
			if (options.tasks >= options.maxTasks)
				showMessage('Information', 'You cannot select more orders today.');
			else {
				var template = '<div>' +
					'<div class="barbutton2 hover2" style="cursor: default; background: url(\'' + window.links.baseUrl + '/images/gui/info-icon-sm.png\') no-repeat; width:35px; height: 35px; float: left; border:0; padding:0; position: absolute; top:7px; left:2px; z-index: 999;"></div>' +
					'<div class="row" style="text-align:center;padding-left:40px;padding-right:40px">SERVICES DELIVERY AGREEMENT</div>' +
					'<div class="register-form-left" style="float: right;"><div class="row infodiv" style="width: calc(100% - 40px);font-size:small;margin-top: 1px;margin-left: 10px;margin-right: 10px;margin-bottom: 10px;">' +
					'<p style="margin-bottom:1em">Signed on ' + $.datepicker.formatDate('yy-mm-dd', new Date()) + ' year, in the town of: ' + options.city + ' between ' + userdata.nazwa_firmy + ' hereinafter referred to as the „Contractor”, and ' + task.kontrahent.nazwa + ' hereinafter referred to as the „Employer”, which states as follows: </p>' +
					'<p style="margin-bottom:1em;text-align:center;font-weight:bold">$1</p>' +
					'<p style="margin-bottom:1em">The Contractor undertakes to carry out the task ' + task.dziedzina + (task.kategoria ? ' - ' + task.kategoria : '') + ' - ' + task.poziom + ' for the Employer.</p>' +
					'<p style="margin-bottom:1em;text-align:center;font-weight:bold">$2</p>' +
					'<p style="margin-bottom:1em">For the performance of contracts falling within the scope of this Agreement, the Employer will pay the salary of ' + task.cena + ' zł net.</p>' +
					'<p style="margin-bottom:1em;text-align:center;font-weight:bold">$3</p><ol>' +
					'<li>The Contractor agrees to complete the task within ' + options.periodDays + ' 7 days from the date of signing the agreement.</li>' +
					'<li>The Employer reserves the right to require from the Contractor a penalty fee of ' + task.kara + '% of the order value (' + (task.kara / 100 * task.cena) + ' zł).</li>' +
					'</ol></div></div>' +
					'<div style="margin-left:15px">Assign to: ' + options.workerList + '</div>' +
					'</div>';
				$(template).dialog({
					title: 'Agreement',
					modal: true,
					autoOpen: true,
					closeOnEscape: false,
					open: function() {
						var dlg = $(this);
						dlg.find('select').change(function() {
							dlg.find('.stats').remove();
							var select = $(this);
							var sel = select.val();
							var workerId = -1;
							if (sel.indexOf('w') === 0)
								workerId = sel.substring(1);
							else return;
							$.ajax({
								type: 'GET',
								url: window.links.studentAjaxSimTaskAssign,
								data: {
									taskId: task.id,
									workerId: workerId
								},
								success: function(data) {
									if (data.stats) {
										var s = data.stats;
										var durationColor;
										if (s.duration < s.taskEnd)
											durationColor = 'green';
										else if (s.duration > s.taskEnd)
											durationColor = 'red';
										else
											durationColor = 'yellow';
										var gradient = [{
											value: 0.00,
											color: [255, 000, 000]
										}, {
											value: 0.60,
											color: [255, 000, 000]
										}, {
											value: 0.75,
											color: [255, 255, 000]
										}, {
											value: 0.95,
											color: [000, 255, 000]
										}, {
											value: 1.00,
											color: [000, 255, 000]
										}];
										var color = [0, 0, 0];
										for (var i = 0; i < gradient.length - 1; i++) {
											var A = gradient[i];
											var B = gradient[i + 1];
											if (s.propability >= A.value && s.propability <= B.value) {
												var sum = (B.value - A.value);
												var a = 1 - (s.propability - A.value) / sum;
												var b = 1 - (B.value - s.propability) / sum;
												color = [
													Math.round(a * A.color[0] + b * B.color[0]),
													Math.round(a * A.color[1] + b * B.color[1]),
													Math.round(a * A.color[2] + b * B.color[2])
												];
												break;
											}
										}
										var html = '<span style="padding-left:5px;font-weight:bold;" class="stats"><span style="color:' + durationColor + '">' + s.duration + ' ' + s.durationUnit + '</span> <span style="text-shadow:1px 1px 2px black;color:rgb(' + color[0] + ', ' + color[1] + ', ' + color[2] + ')">' + Math.round(s.propability * 100) + '%</span></span>';
										select.after(html);
									}
								},
								complete: function() {
									options.enable(true);
								}
							});
						});
					},
					hide: {
						effect: 'clip',
						duration: 500
					},
					show: {
						effect: 'scale',
						duration: 600
					},
					close: function() {
						$(this).parent().remove();
					},
					position: {
						my: 'center',
						at: 'center',
						of: window
					},
					draggable: true,
					resizable: false,
					width: 500,
					height: 580,
					buttons: [{
						text: 'I agree',
						click: function() {
							var params = {
								taskId: task.id,
								kontrahentId: task.idKontrahenta
							};
							var sel = $(this).find('select').val();
							if (!sel) return;
							if (sel.indexOf('s') === 0)
								params.studentId = sel.substring(1);
							else if (sel.indexOf('w') === 0)
								params.workerId = sel.substring(1);
							var _dlg = $(this);
							options.enable(false);
							$.ajax({
								type: 'POST',
								url: window.links.studentAjaxTakeTask,
								data: params,
								success: function(data) {
									if (data.error)
										showMessage('Błąd', data.error);
									else {
										options.workerList = data.workerList;
										options.city = data.city;
										options.periodDays = data.periodDays;
										_dlg.dialog('close');
										BROWSER.find('.tasksBoxCount').text(++options.tasks);
										link.parent().parent().fadeOut(400, function() {
											$(this).remove();
										});
									}
								},
								complete: function() {
									options.enable(true);
								}
							});
						}
					}, {
						text: 'Cancel',
						click: function() {
							$(this).dialog('close')
						}
					}, ]
				});
			}
		}
	};

	for (var i in options.actions) {
		var action = options.actions[i];
		if (action == 'Select')
			options.actions[i] = actionSelect;
	}

	var sorter = {
		field: null,
		order: '',
		run: function(display) {
			var _field = this.field;
			if (_field != null) {
				sortedData = filteredData.slice(0);
				var _order = this.order;
				if (_order.length)
					sortedData.sort(function(a, b) {
						return a[_field] == b[_field] ? 0 : (
							a[_field] < b[_field] ? (_order == 'asc' ? -1 : 1) : (_order == 'asc' ? 1 : -1)
						);
					});
			} else sortedData = filteredData;
			if (display == null) display = true;
			if (display) displayData();
		}
	}

	function installControls() {
		BROWSER.find('a.sort').off('click');
		BROWSER.find('a.sort').removeClass('asc').removeClass('desc');
		BROWSER.find('a.sort').on('click', function() {
			var _this = $(this);
			sorter.field = _this.attr('data-field');
			if (_this.hasClass('asc')) {
				_this.removeClass('asc');
				sorter.order = 'desc';
			} else if (_this.hasClass('desc')) {
				sorter.order = '';
				_this.removeClass('desc');
			} else sorter.order = 'asc';
			BROWSER.find('a.sort').removeClass('asc').removeClass('desc');
			_this.addClass(sorter.order);
			sorter.run();
			return false;
		});
		//===============================
		BROWSER.find('.filter').val('');
		BROWSER.find('.filter').off('change');
		BROWSER.find('.filter').on('change', function() {
			var _this = $(this);
			var value = _this.val();

			var filters = BROWSER.find('.filter');
			filteredData = [];
			for (var i in originalData) {
				var data = originalData[i];
				var push = true;
				for (var x = 0; x < filters.length; x++) {
					function filterNumber(operator, a, b) {
						if (operator === '=')
							push = push && a == b;
						else if (operator === '!')
							push = push && a != b;
						else if (operator === '>')
							push = push && a > b;
						else if (operator === '<')
							push = push && a < b;
						else
							push = push && a == b;
					}
					var filter = $(filters[x]);
					var value = filter.val();
					if (value != '') {
						var field = filter.attr('data-field');
						var inValue = data[field];
						if (filter.hasClass('time')) {
							var operator = value.substring(0, 1);
							var a = parseFloat(inValue);
							var b = timeToInt('=!<>'.indexOf(operator) > -1 ? value.substring(1) : value);
							filterNumber(operator, a, b);
						} else if (filter.hasClass('numeric')) {
							var operator = value.substring(0, 1);
							var a = parseFloat(inValue);
							var b = parseFloat('=!<>'.indexOf(operator) > -1 ? value.substring(1) : value);
							filterNumber(operator, a, b);
						} else if (filter.hasClass('text'))
							push = push && inValue !== undefined && inValue.toLowerCase().indexOf(value.toLowerCase()) > -1;
						else
							push = push && inValue == value;
					}
				}
				if (push) filteredData.push(data);
			}
			sorter.run();
		});
	}

	function findTask(id) {
		for (var x in sortedData)
			if (sortedData[x].id == id)
				return sortedData[x];
		return null;
	}

	function timeToInt(tm) {
		var arr = tm.split(':'),
			result = 0;
		for (var i = arr.length - 1, m = 1; i >= 0; i--, m *= 60)
			result += parseInt(arr[i]) * m;
		return result;
	}

	function displayData() {
		var html = '';
		if (sortedData == null || sortedData.length == 0)
			html = '<tr><td colspan="7" style="text-align:center;padding-top:20px;"><i>No results</i></td></tr>';
		else
			for (var i in sortedData) {
				var item = sortedData[i];
				var actions = '';
				if (item.allowed)
					for (var x in options.actions) {
						var act = options.actions[x];
						actions += '<a data-handler="' + x + '" class="action" taskId="' + item.id + '" href="#">[' + act.title + ']</a> ';
					}
				html += '<tr' + (!item.allowed ? ' class="disabled"' : '') + '>' +
					'<td><img src="' + window.links.baseUrl + '/images/gui/' + item.dziedzina.toLowerCase() + '.png" title="' + item.dziedzina + '" alt="' + item.dziedzina + '" /></td>' +
					'<td>' + (item.kategoria !== undefined ? item.kategoria : 'n/a') + '</td>' +
					'<td>' + item.poziom + '</td>' +
					'<td>' + parseFloat(item.cena * (1.0 + vat)).toFixed(2) + '</td>' +
					'<td>' + item.kara + '</td>' +
					'<td>' + formatInterval(item.czas) + '</td>' +
					'<td>' + actions + '</td>' +
					'</tr>';
			}
		BROWSER.find('.tasksBoxBody').html(html);
		for (var x in options.actions) {
			var objects = BROWSER.find('a.action[data-handler="' + x + '"]');
			objects.click(function() {
				var taskId = $(this).attr('taskId');
				var x = $(this).attr('data-handler');
				options.actions[x].handler(findTask(taskId), $(this), options);
				return false;
			});
		}
	}

	function refresh() {
		options.enable(false);
		BROWSER.find('.tasksBoxWait').find('td').text('Please wait...');
		$.ajax({
			type: 'GET',
			url: options.endpoint,
			data: options.endpointParams,
			success: function(data) {
				if (data.error) {
					BROWSER.find('.tasksBoxWait').find('td').text(data.error);
					return;
				}
				options.maxTasks = data.max;
				options.tasks = data.cnt;
				BROWSER.find('.tasksBoxCount').text(options.tasks);
				BROWSER.find('.tasksBoxMaxCount').text(options.maxTasks);
				options.workerList = data.workerList;
				options.city = data.city;
				options.periodDays = data.periodDays;
				originalData = data.data;
				filteredData = originalData;
				sortedData = filteredData;
				installControls();
				BROWSER.find('.tasksBoxWait').fadeOut(400, function() {
					displayData();
					BROWSER.find('.tasksBoxContainer').fadeIn();
				});
			},
			error: function(xhr, status, error) {
				BROWSER.find('.tasksBoxWait').find('td').text(status + ' ' + error);
			},
			complete: function() {
				options.enable(true);
			}
		});
	}

	var dlgTemplate =
		'<div class="biuroZleceniaXrDialogCls" xid="biuroZleceniaXrDialog">' +
		'	<table class="tasksBoxWait">' +
		'		<tr>' +
		'			<td>Please wait...</td>' +
		'		</tr>' +
		'	</table>' +
		'	<div class="tasksBoxContainer">' +
		'		<table class="tasksBoxContainerOuterTable">' +
		'			<thead>' +
		'				<tr>' +
		'					<th>' +
		'						<a class="sort" data-field="dziedzina" href="#">Field</a><br>' +
		'						<select class="filter" data-field="dziedzina" name="filter_dziedzina">' +
		'							<option value="" selected="selected"></option>' +
		'							<option value="Mathematics">Math</option>' +
		'							<option value="Physics">Phys</option>' +
		'							<option value="Biology">Biol</option>' +
		'							<option value="Chemistry">Chem</option>' +
		'						</select>' +
		'					</th>' +
		'					<th>' +
		'						<a class="sort" data-field="kategoria" href="#">Category</a><br>' +
		'						<input size="10" class="filter text" data-field="kategoria" type="text" value="" name="filter_kategoria"></th>' +
		'					<th>' +
		'						<a class="sort" data-field="poziom" href="#">Level</a><br>' +
		'						<select class="filter" data-field="poziom" name="filter_poziom">' +
		'							<option value="" selected="selected"></option>' +
		'							<option value="Łatwe">Easy</option>' +
		'							<option value="Trudne">Hard</option>' +
		'							<option value="Bardzo trudne">Very hard</option>' +
		'						</select></th>' +
		'					<th>' +
		'						<a class="sort" data-field="cena" href="#">Price [zł]</a><br>' +
		'						<input size="10" class="filter numeric" data-field="cena" type="text" value="" name="filter_cena"></th>' +
		'					<th>' +
		'						<a class="sort" data-field="kara" href="#">Penalty [%]</a><br>' +
		'						<input size="10" class="filter numeric" data-field="kara" type="text" value="" name="filter_kara"></th>' +
		'					<th>' +
		'						<a class="sort" data-field="czas" href="#">Time</a><br>' +
		'						<input size="10" class="filter time" data-field="czas" type="text" value="" name="filter_czas"></th>' +
		'					<th></th>' +
		'				</tr>' +
		'			</thead>' +
		'			<tbody class="tasksBoxBody">' +
		'			</tbody>' +
		'		</table>' +
		'		<div>' +
		'			<span style="float:right"><span class="tasksBoxCount">?</span> / <span class="tasksBoxMaxCount">?</span></span>' +
		'		</div>' +
		'	</div>' +
		'</div>';

	BROWSER = $(dlgTemplate);
	BROWSER.dialog({
		title: options.title,
		modal: true,
		autoOpen: true,
		closeOnEscape: false,
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		open: function() {
			refresh();
		},
		close: function() {
			BROWSER.find('.tasksBoxBody').html('');
			BROWSER.find('.tasksBoxContainer').hide();
			BROWSER.find('.tasksBoxWait').show();
			$(this).parent().remove();
		},
		position: {
			my: "center",
			at: "center",
			of: window
		},
		draggable: true,
		resizable: false,
		width: 950,
		height: 450
	});

	BROWSER.find('.tasksBoxBodyRefresh').click(function() {
		BROWSER.find('.tasksBoxContainer').fadeOut(400, function() {
			BROWSER.find('.tasksBoxWait').fadeIn(400, refresh);
		});
		return false;
	});
}

/** window events **/

$(function() {

	// disable ajax query caching
	$.ajaxSetup({
		cache: false
	});

	checkSize();

	/**
	 * Manage dialog windows.
	 */
	window.parsed = false;
	$(window).on('hashchange', function() {
		windowParseUrl();
	});
	$(window).resize(function() {
		checkSize();
	});

	/**
	 * Show loading animation next to mouse cursor during any ajax request.
	 */
	$(document).ajaxStart(function() {
		//Spinner
		var opts = {
			segments: 12,
			steps: 3,
			//			opacity: 1.0,
			//			opacity: 0.7,
			opacity: 0.3,
			width: 4,
			space: 0,
			length: 5,
			trail: 50, // ?
			//			color: '#637a61',
			//                      color: '#26a61c',
			//                      color: '#637a61',
			//                      color: '#0e5708',
			//                      color: '#005500',
			//			color: '#637a61',
			color: '#70FF70',
			//                      color: '#fff',
			speed: 1.5
		};

		$('body').append('<div class="blockClicksOverlay" style="background-color: rgba(1, 1, 1, 0.0); bottom: 0; left: 0; position: fixed; right: 0; top: 0; z-index: 999999"></div>');
		$('button, input[type=\"button\"], input[type=\"submit\"], input[type=\"file\"]').attr('disabled', 'disabled');
		$("#ajax-loader").show();
		$("#ajax-loader").activity(opts);
	}).ajaxStop(function() {
		$('button, input[type=\"button\"], input[type=\"submit\"], input[type=\"file\"]').removeAttr('disabled');
		$('.blockClicksOverlay').remove();
		$("#ajax-loader").hide();
		$("#ajax-loader").activity(false);
	});
	$(document).mousemove(function(e) {
		$("#ajax-loader").css({
			left: e.pageX + 30,
			top: e.pageY + 30
		});
	});
});

// tipsy, facebook style tooltips for jquery
// version 1.0.0a
// (c) 2008-2010 jason frame [jason@onehackoranother.com]
// released under the MIT license

(function($) {
    
    function maybeCall(thing, ctx) {
        return (typeof thing == 'function') ? (thing.call(ctx)) : thing;
    };
    
    function isElementInDOM(ele) {
      while (ele = ele.parentNode) {
        if (ele == document) return true;
      }
      return false;
    };
    
    function Tipsy(element, options) {
        this.$element = $(element);
        this.options = options;
        this.enabled = true;
        this.fixTitle();
    };
    
    Tipsy.prototype = {
        show: function() {
            var title = this.getTitle();
            if (title && this.enabled) {
                var $tip = this.tip();
                
                $tip.find('.tipsy-inner')[this.options.html ? 'html' : 'text'](title);
                $tip[0].className = 'tipsy'; // reset classname in case of dynamic gravity
                $tip.remove().css({top: 0, left: 0, visibility: 'hidden', display: 'block'}).prependTo(document.body);
                
                var pos = $.extend({}, this.$element.offset(), {
                    width: this.$element[0].offsetWidth,
                    height: this.$element[0].offsetHeight
                });
                
                var actualWidth = $tip[0].offsetWidth,
                    actualHeight = $tip[0].offsetHeight,
                    gravity = maybeCall(this.options.gravity, this.$element[0]);
                
                var tp;
                switch (gravity.charAt(0)) {
                    case 'n':
                        tp = {top: pos.top + pos.height + this.options.offset, left: pos.left + pos.width / 2 - actualWidth / 2};
                        break;
                    case 's':
                        tp = {top: pos.top - actualHeight - this.options.offset, left: pos.left + pos.width / 2 - actualWidth / 2};
                        break;
                    case 'e':
                        tp = {top: pos.top + pos.height / 2 - actualHeight / 2, left: pos.left - actualWidth - this.options.offset};
                        break;
                    case 'w':
                        tp = {top: pos.top + pos.height / 2 - actualHeight / 2, left: pos.left + pos.width + this.options.offset};
                        break;
                }
                
                if (gravity.length == 2) {
                    if (gravity.charAt(1) == 'w') {
                        tp.left = pos.left + pos.width / 2 - 15;
                    } else {
                        tp.left = pos.left + pos.width / 2 - actualWidth + 15;
                    }
                }
                
                $tip.css(tp).addClass('tipsy-' + gravity);
                $tip.find('.tipsy-arrow')[0].className = 'tipsy-arrow tipsy-arrow-' + gravity.charAt(0);
                if (this.options.className) {
                    $tip.addClass(maybeCall(this.options.className, this.$element[0]));
                }
                
                if (this.options.fade) {
                    $tip.stop().css({opacity: 0, display: 'block', visibility: 'visible'}).animate({opacity: this.options.opacity});
                } else {
                    $tip.css({visibility: 'visible', opacity: this.options.opacity});
                }
            }
        },
        
        hide: function() {
            if (this.options.fade) {
                this.tip().stop().fadeOut(function() { $(this).remove(); });
            } else {
                this.tip().remove();
            }
        },
        
        fixTitle: function() {
            var $e = this.$element;
            if ($e.attr('title') || typeof($e.attr('original-title')) != 'string') {
                $e.attr('original-title', $e.attr('title') || '').removeAttr('title');
            }
        },
        
        getTitle: function() {
            var title, $e = this.$element, o = this.options;
            this.fixTitle();
            var title, o = this.options;
            if (typeof o.title == 'string') {
                title = $e.attr(o.title == 'title' ? 'original-title' : o.title);
            } else if (typeof o.title == 'function') {
                title = o.title.call($e[0]);
            }
            title = ('' + title).replace(/(^\s*|\s*$)/, "");
            return title || o.fallback;
        },
        
        tip: function() {
            if (!this.$tip) {
                this.$tip = $('<div class="tipsy"></div>').html('<div class="tipsy-arrow"></div><div class="tipsy-inner"></div>');
                this.$tip.data('tipsy-pointee', this.$element[0]);
            }
            return this.$tip;
        },
        
        validate: function() {
            if (!this.$element[0].parentNode) {
                this.hide();
                this.$element = null;
                this.options = null;
            }
        },
        
        enable: function() { this.enabled = true; },
        disable: function() { this.enabled = false; },
        toggleEnabled: function() { this.enabled = !this.enabled; }
    };
    
    $.fn.tipsy = function(options) {
        
        if (options === true) {
            return this.data('tipsy');
        } else if (typeof options == 'string') {
            var tipsy = this.data('tipsy');
            if (tipsy) tipsy[options]();
            return this;
        }
        
        options = $.extend({}, $.fn.tipsy.defaults, options);
        
        function get(ele) {
            var tipsy = $.data(ele, 'tipsy');
            if (!tipsy) {
                tipsy = new Tipsy(ele, $.fn.tipsy.elementOptions(ele, options));
                $.data(ele, 'tipsy', tipsy);
            }
            return tipsy;
        }
        
        function enter() {
            var tipsy = get(this);
            tipsy.hoverState = 'in';
            if (options.delayIn == 0) {
                tipsy.show();
            } else {
                tipsy.fixTitle();
                setTimeout(function() { if (tipsy.hoverState == 'in') tipsy.show(); }, options.delayIn);
            }
        };
        
        function leave() {
            var tipsy = get(this);
            tipsy.hoverState = 'out';
            if (options.delayOut == 0) {
                tipsy.hide();
            } else {
                setTimeout(function() { if (tipsy.hoverState == 'out') tipsy.hide(); }, options.delayOut);
            }
        };
        
        if (!options.live) this.each(function() { get(this); });
        
        if (options.trigger != 'manual') {
            var binder   = options.live ? 'live' : 'bind',
                eventIn  = options.trigger == 'hover' ? 'mouseenter' : 'focus',
                eventOut = options.trigger == 'hover' ? 'mouseleave' : 'blur';
            this[binder](eventIn, enter)[binder](eventOut, leave);
        }
        
        return this;
        
    };
    
    $.fn.tipsy.defaults = {
        className: null,
        delayIn: 0,
        delayOut: 0,
        fade: false,
        fallback: '',
        gravity: 'n',
        html: false,
        live: false,
        offset: 0,
        opacity: 0.8,
        title: 'title',
        trigger: 'hover'
    };
    
    $.fn.tipsy.revalidate = function() {
      $('.tipsy').each(function() {
        var pointee = $.data(this, 'tipsy-pointee');
        if (!pointee || !isElementInDOM(pointee)) {
          $(this).remove();
        }
      });
    };
    
    // Overwrite this method to provide options on a per-element basis.
    // For example, you could store the gravity in a 'tipsy-gravity' attribute:
    // return $.extend({}, options, {gravity: $(ele).attr('tipsy-gravity') || 'n' });
    // (remember - do not modify 'options' in place!)
    $.fn.tipsy.elementOptions = function(ele, options) {
        return $.metadata ? $.extend({}, options, $(ele).metadata()) : options;
    };
    
    $.fn.tipsy.autoNS = function() {
        return $(this).offset().top > ($(document).scrollTop() + $(window).height() / 2) ? 's' : 'n';
    };
    
    $.fn.tipsy.autoWE = function() {
        return $(this).offset().left > ($(document).scrollLeft() + $(window).width() / 2) ? 'e' : 'w';
    };
    
    /**
     * yields a closure of the supplied parameters, producing a function that takes
     * no arguments and is suitable for use as an autogravity function like so:
     *
     * @param margin (int) - distance from the viewable region edge that an
     *        element should be before setting its tooltip's gravity to be away
     *        from that edge.
     * @param prefer (string, e.g. 'n', 'sw', 'w') - the direction to prefer
     *        if there are no viewable region edges effecting the tooltip's
     *        gravity. It will try to vary from this minimally, for example,
     *        if 'sw' is preferred and an element is near the right viewable 
     *        region edge, but not the top edge, it will set the gravity for
     *        that element's tooltip to be 'se', preserving the southern
     *        component.
     */
     $.fn.tipsy.autoBounds = function(margin, prefer) {
		return function() {
			var dir = {ns: prefer[0], ew: (prefer.length > 1 ? prefer[1] : false)},
			    boundTop = $(document).scrollTop() + margin,
			    boundLeft = $(document).scrollLeft() + margin,
			    $this = $(this);

			if ($this.offset().top < boundTop) dir.ns = 'n';
			if ($this.offset().left < boundLeft) dir.ew = 'w';
			if ($(window).width() + $(document).scrollLeft() - $this.offset().left < margin) dir.ew = 'e';
			if ($(window).height() + $(document).scrollTop() - $this.offset().top < margin) dir.ns = 's';

			return dir.ns + (dir.ew ? dir.ew : '');
		}
	};
    
})(jQuery);

(function(e){var f=(function(){var k=document.createElement("p").style,j=["ms","O","Moz","Webkit"];if(k.transition==""){return true}while(j.length){if(j.pop()+"Transition" in k){return true}}return false})();function b(k,j){var m=k.data("settings");if(typeof j==="undefined"){j=false}if(j){a(k)}var l=h(k);k.animate(l.css,l.time,"linear",function(){k.css(m.direction,"0");b(k,true)})}function h(j){var m=j.data("settings");var n=j.children().first();var o=Math.abs(-j.css(m.direction).replace("px","").replace("auto","0")-n.outerWidth(true));var m=j.data("settings");var k=o*1000/m.speed;var l={};l[m.direction]=j.css(m.direction).replace("px","").replace("auto","0")-o;return{css:l,time:k}}function a(j){var k=j.data("settings");j.css("transition-duration","0s").css(k.direction,"0");var l=j.children().first();if(l.hasClass("webticker-init")){l.remove()}else{j.children().last().after(l)}}function d(k,j){if(typeof j==="undefined"){j=false}if(j){a(k)}var l=h(k);var m=l.time/1000;m+="s";k.css(l.css).css("transition-duration",m)}function i(l,k,j){var m;e.get(l,function(o){var n=e(o);n.find("item").each(function(){var q=e(this),p={title:q.find("title").text(),link:q.find("link").text()};listItem="<li><a href='"+p.link+"'>"+p.title+"</a></li>";m+=listItem});j.webTicker("update",m,k)})}function g(l){var n=l.data("settings");l.width("auto");var m=0;l.children("li").each(function(){m+=e(this).outerWidth(true)});if(m<l.parent().width()||l.children().length==1){if(n.duplicate){itemWidth=Math.max.apply(Math,l.children().map(function(){return e(this).width()}).get());while(m-itemWidth<l.parent().width()||l.children().length==1){var o=l.children().clone();l.append(o);m=0;l.children("li").each(function(){m+=e(this).outerWidth(true)});itemWidth=Math.max.apply(Math,l.children().map(function(){return e(this).width()}).get())}}else{var k=l.parent().width()-m;k+=l.find("li:first").width();var j=l.find("li:first").height();l.append('<li class="ticker-spacer" style="width:'+k+"px;height:"+j+'px;"></li>')}}if(n.startEmpty){var j=l.find("li:first").height();l.prepend('<li class="webticker-init" style="width:'+l.parent().width()+"px;height:"+j+'px;"></li>')}m=0;l.children("li").each(function(){m+=e(this).outerWidth(true)});l.width(m+200);widthCompare=0;l.children("li").each(function(){widthCompare+=e(this).outerWidth(true)});while(widthCompare>=l.width()){l.width(l.width()+200);widthCompare=0;l.children("li").each(function(){widthCompare+=e(this).outerWidth(true)})}}var c={init:function(j){j=jQuery.extend({speed:50,direction:"left",moving:true,startEmpty:true,duplicate:false,rssurl:false,hoverpause:true,rssfrequency:0,updatetype:"reset"},j);return this.each(function(){jQuery(this).data("settings",j);var k=jQuery(this);k.addClass("newsticker");var m=k.wrap("<div class='mask'></div>");m.after("<span class='tickeroverlay-left'>&nbsp;</span><span class='tickeroverlay-right'>&nbsp;</span>");var l=k.parent().wrap("<div class='tickercontainer'></div>");g(k);if(j.rssurl){i(j.rssurl,j.type,k);if(j.rssfrequency>0){window.setInterval(function(){i(j.rssurl,j.type,k)},j.rssfrequency*1000*60)}}if(f){k.css("transition-duration","0s").css(j.direction,"0");d(k,false);k.on("transitionend webkitTransitionEnd oTransitionEnd otransitionend",function(n){if(!k.is(n.target)){return false}d(e(this),true)})}else{b(e(this))}if(j.hoverpause){k.hover(function(){if(f){var n=e(this).css(j.direction);e(this).css("transition-duration","0s").css(j.direction,n)}else{jQuery(this).stop()}},function(){if(jQuery(this).data("settings").moving){if(f){d(e(this),false)}else{b(k)}}})}})},stop:function(){var j=e(this).data("settings");if(j.moving){j.moving=false;return this.each(function(){if(f){var k=e(this).css(j.direction);e(this).css("transition-duration","0s").css(j.direction,k)}else{e(this).stop()}})}},cont:function(){var j=e(this).data("settings");if(!j.moving){j.moving=true;return this.each(function(){if(f){d(e(this),false)}else{b(e(this))}})}},update:function(p,n,o,j){n=n||"reset";if(typeof o==="undefined"){o=true}if(typeof j==="undefined"){j=false}if(typeof p==="string"){p=e(p)}var k=e(this);k.webTicker("stop");var m=e(this).data("settings");if(n=="reset"){k.html(p);k.css(m.direction,"0");g(k)}else{if(n=="swap"){k.children("li").addClass("old");for(var l=0;l<p.length;l++){id=e(p[l]).data("update");match=k.find('[data-update="'+id+'"]');if(match.length<1){if(o){if(k.find(".ticker-spacer:first-child").length==0&&k.find(".ticker-spacer").length>0){k.children("li.ticker-spacer").before(p[l])}else{k.append(p[l])}}}else{k.find('[data-update="'+id+'"]').replaceWith(p[l])}}k.children("li.webticker-init, li.ticker-spacer").removeClass("old");if(j){k.children("li").remove(".old")}stripWidth=0;k.children("li").each(function(){stripWidth+=e(this).outerWidth(true)});k.width(stripWidth+200)}}k.webTicker("cont")}};e.fn.webTicker=function(j){if(c[j]){return c[j].apply(this,Array.prototype.slice.call(arguments,1))}else{if(typeof j==="object"||!j){return c.init.apply(this,arguments)}else{e.error("Method "+j+" does not exist on jQuery.webTicker")}}}})(jQuery);
/** GUI about **/

$(function() {
	/**
	 * Dialog definitions
	 **/
	$("#dialog-about").dialog({
		autoOpen: false,
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		close: function(event, ui) {},
		position: {
			my: "center",
			at: "center",
			of: window
		},
		closeOnEscape: false,
		draggable: true,
		/* false */
		resizable: false,
		width: 745,
		height: 500
	});

	/**
	 * Events
	 **/
	$("#dialog-about").on("dialogclose", function(event, ui) {
		$("#dialog-about").dialog('close');
	});

	$("#dialog-about").on("dialogopen", function(event, ui) {
		$("#about-container").scrollTop(0);
	});

});

/** GUI biuro **/

function activateBankrut(force) {
	/**
	 * Dialog definitions
	 **/
	function showDlg() {
		if (window.BankrutDlgOpened) return;
		window.BankrutDlgLastFired = new Date();

		var template = '<div id="dialog-bankrut" title="Informacja">' +
			'	<div id="mainblock" style="width: 100%; clear: both; overflow: hidden;">' +
			'		<div class="barbutton2 hover2" style="cursor: default; background: url(\'images/gui/info-icon-sm.png\') no-repeat; width:35px; height: 35px; float: left; border:0; padding:0; position: absolute; top:7px; left:2px; z-index: 999;"></div>' +
			'		<div class="row" style="text-align:center" id="info-naglowek">Bankructwo!</div>' +
			'		<div class="register-form-left" style="float: right;">' +
			'			<div class="row infodiv" id="info-tresc">Środki na twoim koncie uległy wyczerpaniu. Firma zbankrutowała!</div>' +
			'		</div>' +
			'	</div>' +
			'	<div class="row buttons" style="width: 100%; text-align: center;">' +
			'		<input type="button" id="bankructwo-ok" name="submit" value="OK" class="infodialog-button-ok ui-button ui-widget ui-state-default ui-corner-all" role="button" aria-disabled="false" />' +
			'	</div>' +
			'</div>';

		$(template).dialog({
			autoOpen: true,
			hide: {
				effect: 'clip',
				duration: 500
			},
			show: {
				effect: 'scale',
				duration: 600
			},
			position: {
				my: "center",
				at: "center",
				of: window
			},
			close: function() {
				window.BankrutDlgOpened = false;
				$(this).parent().remove();
				var back = $('#button-back');
				if (back.is(':visible') && force)
					back.click();
			},
			open: function() {
				window.BankrutDlgOpened = true;
				var _dlg = $(this);
				_dlg.find('#bankructwo-ok').click(function() {
					_dlg.dialog('close');
				});
			},
			closeOnEscape: false,
			draggable: true,
			resizable: false,
			width: 500,
			modal: true
		});
	}

	if (window.BankrutDlgLastFired) {
		var startTime = window.BankrutDlgLastFired;
		var startMsec = startTime.getTime();
		var now = new Date();
		var elapsed = (now.getTime() - startMsec) / 1000;
		if (elapsed > 5 * 60)
			showDlg();
	} else showDlg();
}

/** GUI biuro **/

function activateBiuro(idBiura, param, finishedCb) {
    /**
     * Dialog definitions
     **/
    var idb = idBiura;
    var istr = window.biuroString; //infoString;
    $("#dialog-biuro").dialog({
        autoOpen: true,
        show: {
            effect: 'scale',
            duration: 600,
            complete: function() {
                $("#info-naglowek").html("<b>" + istr[0] + "</b>");
                $("#info-tresc").html(istr[1]);
            }
        },
        hide: {
            effect: 'clip',
            duration: 500
        },
        position: {
            my: "center",
            at: "center",
            of: window
        },
        closeOnEscape: false,
        draggable: true,
        resizable: false,
        width: 500,
    });

    $(".biuro-button").button();

    if ($("#biuro-ok").length)
        $("#biuro-ok").button().click(function() {
            $("#dialog-biuro").dialog('close');

            $.get(window.links.studentAjaxGetBusinessInfo, function(resoff) {
                var res = jQuery.parseJSON(resoff);
                window.userdata["ilosc_biur"] = res['ilosc_biur'];
                if (window.userdata["ilosc_biur"] > 0) {
                    if (window.userdata["tura"] == 4) {
                        $("#dialog-info").load(window.links.studentAjaxInfoDialog, {}, function() {
                            activateInfo(parseInt(window.userdata["tura"]), 17);
                            window.userdata['ilosc_biur'] = 1;
                        });
                    } else {
                        $("#dialog-info").load(window.links.studentAjaxInfoDialog, {}, function() {
                            activateInfo(parseInt(window.userdata["tura"]), 172);
                            window.userdata['ilosc_biur'] = 1;
                            //activateInfo(parseInt(window.userdata["tura"]), 166,undefined,"Biuro będące pierwszą siedzibą waszej firmy zostało wynajęte.","Biuro wynajęte!");
                        });
                    }
                }
            });
        });

    if ($("#biuro-cancel").length)
        $("#biuro-cancel").button().click(function() {
            $("#dialog-biuro").dialog('close');
        });

    if ($("#biuro-submit").length)
        $("#biuro-submit").button().click(function() {
            $("#dialog-biuro").dialog('close');

            var params = {
                budynekId: idb,
                buyBiuro: 1
            };
            if (param == null) param = 'buyBiuro';
            params[param] = 1;
            $("#dialog-biuro").load(window.links.studentAjaxBiuroDialog, params, function(b) {
                $("#info-naglowek").html("<b>" + istr[0] + "</b>");
                $("#info-tresc").html(istr[1]);
                if (finishedCb) finishedCb();
                activateBiuro(idb);
            });
        });
}

/** GUI files **/

$(function() {
	/**
	 * Dialog definitions
	 **/
	$("#dialog-files").dialog({
		autoOpen: false,
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		close: function(event, ui) {},
		position: {
			my: "center",
			at: "center",
			of: window
		},
		closeOnEscape: false,
		draggable: true,
		/* false */
		resizable: false,
		width: 745,
		height: 500
	});

	/**
	 * Events
	 **/
	$("#dialog-files").on("dialogopen", function(event, ui) {
		$('#dialog-files').load(window.links.studentAjaxFiles, function() {});
	});
	$("#dialog-files").on("dialogclose", function(event, ui) {
		event.preventDefault();
		//window.location.hash = "";
		$("#dialog-files").dialog('close');
	});
	$(window).on('resize', function() {
		if ($("#dialog-files").dialog("isOpen")) $("#dialog-files").dialog({
			position: {
				my: "center",
				at: "center",
				of: window
			}
		});
	});
});

/** GUI form **/

//$(function()

function activateForm(id) {
	/**
	 * Dialog definitions
	 **/
	$("#dialog-form").dialog({
		autoOpen: false,
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		close: function(event, ui) {},
		position: {
			my: "center",
			at: "center",
			of: window
		},
		closeOnEscape: false,
		draggable: false,
		resizable: false,
		width: 745,
		height: 500
	});

	/**
	 * Events
	 **/

	var link;
	switch (id) {
		default: //
			case 1:
			$("#dialog-form").dialog({
			width: 745
		});
		link = window.links.studentAjaxForm1;
		break;
		case 2:
				$("#dialog-form").dialog({
				width: 945
			});
			link = window.links.studentAjaxForm2;
			break;
		case 3:
				$("#dialog-form").dialog({
				width: 945
			});
			link = window.links.studentAjaxForm3;
			break;
		case 4:
				$("#dialog-form").dialog({
				width: 945
			});
			link = window.links.studentAjaxForm4;
			break;
		case 5:
				$("#dialog-form").dialog({
				width: 945
			});
			link = window.links.studentAjaxForm5;
			break;
		case 6:
				$("#dialog-form").dialog({
				width: 945
			});
			link = window.links.studentAjaxForm6;
			break;
		case 7:
				$("#dialog-form").dialog({
				width: 945
			});
			link = window.links.studentAjaxForm7;
			break;
		case 8:
				$("#dialog-form").dialog({
				width: 945
			});
			link = window.links.studentAjaxForm8;
			break;
		case 9:
				$("#dialog-form").dialog({
				width: 945
			});
			link = window.links.studentAjaxForm9;
			break;
		case 10:
				$("#dialog-form").dialog({
				width: 945
			});
			link = window.links.studentAjaxForm10;
			break;
		case 11:
				$("#dialog-form").dialog({
				width: 945
			});
			link = window.links.studentAjaxForm11;
			break;
	}

	$("#dialog-form").dialog("open");
	//$("#dialog-form").on( "dialogopen", function( event, ui ) {
	$('#dialog-form').load(link, function() {
		$('button[value="saveDraft"]').click(function() {
			$.post(link, $("#dialog-form-element").serialize() + "&submitType=saveDraft", function(result) {
				//console.log(result);

			});
			return false;
		});
		$('button[value="confirm"]').click(function() {
			$.post(link, $("#dialog-form-element").serialize() + "&submitType=confirm", function(result) {
				//console.log(result);

			});
			return false;
		});
		/*$("#dialog-form-element").submit(function(){
			$.post(window.links.studentAjaxForm1, $("#dialog-form-element").serialize(), function(result)
			{
				console.log(result);
			});
			return false;
		});*/
	});
	//} );
	$("#dialog-form").on("dialogclose", function(event, ui) {
		event.preventDefault();
		window.location.hash = "";
		$("#dialog-form").dialog('close');
	});
	$(window).on('resize', function() {
		if ($("#dialog-form").dialog("isOpen")) $("#dialog-form").dialog({
			position: {
				my: "center",
				at: "center",
				of: window
			}
		});
	});
}

//});

/** GUI info **/

function submitInfo() {
	var action = typeof window.infoActionId !== 'undefined' ? window.infoActionId : window.userdata["ostatnia_akcja"];
	getAllowedInteriors();
	// kiedy jestesmy w domu nie ma potrzeby zapisywac przeczytanych automatycznych wiadomosci
	if (window.userdata['tura_aktywna']) {
		// ustaw AkcjaUzytkownika w bazie jako wykonana
		$.get(window.links.studentAjaxInfoSubmit, {
			"tura": window.userdata["tura"],
			"akcja": action,
			"przeczytana": 1
		}, function(ret) {

			$.ajax({
				url: window.links.studentAjaxIsBlockedAction,
				global: false, // do not show cursor loading animation for this ajax request
				type: 'GET',
				success: function(result) {
					if (action != 163 // odrzuconyFormularz
						&& action != 164 // zalegleFormularze
						&& action != 167 // zaleglyBank
						&& action != 168 // zaleglaDotacja
						&& action != 169 // zalegleBiuro
						&& action != 176 // zalegleFormularzePoDotacji
						&& action != 177 // zaleglePlatnosci
					) // niezaakceptowane niech sie powtarzaja && action != 165) // odrzucone, zaległe, niezaakceptowane
					{
						if (result > 0) {
							if (result == 2) // zaległe formularze
							{
								$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
									activateInfo(parseInt(window.userdata["tura"]), 164); // zalegleFormularze z poprzednich lekcji
									$("#info-submit").val("Wypełnij dokumenty");
								});
							} else if (result == 1) // formularz odrzucony do poprawki
							{
								$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
									activateInfo(parseInt(window.userdata["tura"]), 163); // odrzuconyFormularz, blokujemy gre
									$("#info-submit").val("Wypełnij dokumenty");
								});
							} else if (result == 3) // nie wszystkie formularze zaakceptowane
							{
								$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
									activateInfo(parseInt(window.userdata["tura"]), 165); // nie wszystko zaakceptowane, blokujemy gre
								});
							} else if (result == 4) // brak banku
							{
								$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
									activateInfo(parseInt(window.userdata["tura"]), 167); // blokujemy gre bo brak banku
								});
							} else if (result == 5) // brak dotacji
							{
								$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
									activateInfo(parseInt(window.userdata["tura"]), 168); // blokujemy gre bo brak dotacji
								});
							} else if (result == 6) // brak biura
							{
								$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
									activateInfo(parseInt(window.userdata["tura"]), 169); // blokujemy gre bo brak biura
								});
							} else if (result == 7) // zalegle formularze po dotacji
							{
								$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
									activateInfo(parseInt(window.userdata["tura"]), 176); // blokujemy gre bo brak biura
									$("#info-submit").val("Wypełnij dokumenty");
								});
							} else if (result == 8) // zalegle oplety (komornik)
							{
								$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
									activateInfo(parseInt(window.userdata["tura"]), 177);
								});
							}
						} else
						//if(result <= 0)
						{
							$.ajax({ // wymuszenie sprawdzania wnetrz
								url: window.links.studentAjaxGetAllowedInteriors,
								type: 'GET',
								success: function(result) {
									var res = jQuery.parseJSON(result);
									if (res && window.userdata) window.userdata['allowedInteriors'] = res['allowedInteriors'];
									window.game.enableAllowedBuildings();

									// zapisana albo nie zapisana, nie wazne, bo i tak dalej szukamy akcji potomnych
									//if(ret>0)
									///{
									window.userdata["ostatnia_akcja"] = action; // ret

									// załaduj kolejną akcję jeśli występuje jakaś z idRodzica = ostatnia_akcja i ma ustawione pole czyAutomatyczna!=0
									$.get(window.links.studentAjaxGetChildAction, {
										"ostatnia_akcja": action,
										"tura": window.userdata["tura"]
									}, function(re) {
										if (re > 0) {
											$("#dialog-info").load(window.links.studentAjaxInfoDialog, {}, function() {
												activateInfo(parseInt(window.userdata["tura"]), re);
												specificActions(re);
											});
										}
									});
									///}
								}
							});
						}
					}
				}
			});
		});
	}

	// zamknij okno dialogowe
	$("#dialog-info").dialog('close');
}

function specificActions(idAkcji) {
	switch (idAkcji) {
		case "101":
			$("#info-submit").val("Dalej >");
			break;
		case "102":
			$("#info-submit").val("Dalej >");
			break;
		case "103":
			$("#info-submit").val("Dalej >");
			$("#symbol-komputer").clearQueue().finish().delay(2000).fadeIn(500).addClass("hover2");
			$("#symbol-komputer").tipsy({
				gravity: 's',
				trigger: 'manual'
			});
			$("#symbol-komputer").tipsy('show');
			break;
		case "125":
			$("#symbol-komputer").tipsy('hide');
			$("#symbol-komputer").removeClass("hover2");
			$("#symbol-komputer").tipsy({
				gravity: 's',
				trigger: 'hover'
			});
			$("#info-submit").val("Dalej >");
			$("#symbol-finanse").clearQueue().finish().delay(2000).fadeIn(500).addClass("hover2");
			$("#symbol-finanse").tipsy({
				gravity: 's',
				trigger: 'manual'
			});
			$("#symbol-finanse").tipsy('show');
			break;
		case "126":
			$("#symbol-finanse").tipsy('hide');
			$("#symbol-finanse").removeClass("hover2");
			$("#symbol-finanse").tipsy({
				gravity: 's',
				trigger: 'hover'
			});
			$("#info-submit").val("Dalej >");
			$("#symbol-statystyki").clearQueue().finish().delay(2000).fadeIn(500).addClass("hover2");
			$("#symbol-statystyki").tipsy({
				gravity: 's',
				trigger: 'manual'
			});
			$("#symbol-statystyki").tipsy('show');
			break;
		case "141":
			$("#symbol-statystyki").tipsy('hide');
			$("#symbol-statystyki").removeClass("hover2");
			$("#symbol-statystyki").tipsy({
				gravity: 's',
				trigger: 'hover'
			});
			$("#info-submit").val("Dalej >");
			$("#symbol-pliki").clearQueue().finish().delay(2000).fadeIn(500).addClass("hover2");
			$("#symbol-pliki").tipsy({
				gravity: 's',
				trigger: 'manual'
			});
			$("#symbol-pliki").tipsy('show');
			break;
		case "142":
			$("#symbol-pliki").tipsy('hide');
			$("#symbol-pliki").removeClass("hover2");
			$("#symbol-pliki").tipsy({
				gravity: 's',
				trigger: 'hover'
			});
			$("#info-submit").val("Dalej >");
			$("#symbol-pracownicy").clearQueue().finish().delay(2000).fadeIn(500).addClass("hover2");
			$("#symbol-pracownicy").tipsy({
				gravity: 's',
				trigger: 'manual'
			});
			$("#symbol-pracownicy").tipsy('show');
			break;
		case "143":
			$("#symbol-pracownicy").tipsy('hide');
			$("#symbol-pracownicy").removeClass("hover2");
			$("#symbol-pracownicy").tipsy({
				gravity: 's',
				trigger: 'hover'
			});
			$("#info-submit").val("Dalej >");
			$("#symbol-zlecenia").clearQueue().finish().delay(2000).fadeIn(500).addClass("hover2");
			$("#symbol-zlecenia").tipsy({
				gravity: 's',
				trigger: 'manual'
			});
			$("#symbol-zlecenia").tipsy('show');
			break;
		case "144":
			$("#symbol-zlecenia").tipsy('hide');
			$("#symbol-zlecenia").removeClass("hover2");
			$("#symbol-zlecenia").tipsy({
				gravity: 's',
				trigger: 'hover'
			});
			$("#info-submit").val("Dalej >");
			$("#symbol-urzadpracy").clearQueue().finish().delay(2000).fadeIn(500).addClass("hover2");
			$("#symbol-urzadpracy").tipsy({
				gravity: 's',
				trigger: 'manual'
			});
			$("#symbol-urzadpracy").tipsy('show');
			break;
		case "145":
			$("#symbol-urzadpracy").tipsy('hide');
			$("#symbol-urzadpracy").removeClass("hover2");
			$("#symbol-urzadpracy").tipsy({
				gravity: 's',
				trigger: 'hover'
			});
			$("#info-submit").val("Dalej >");
			$("#symbol-firma").clearQueue().finish().delay(2000).fadeIn(500).addClass("hover2");
			$("#symbol-firma").tipsy({
				gravity: 's',
				trigger: 'manual'
			});
			$("#symbol-firma").tipsy('show');
			break;
		case "146":
			$("#symbol-firma").tipsy('hide');
			$("#symbol-firma").removeClass("hover2");
			$("#symbol-firma").tipsy({
				gravity: 's',
				trigger: 'hover'
			});
			$("#info-submit").val("OK");
			break;
		case "163":
			$("#info-submit").val("Wypełnij dokumenty");
			break;
		case "164":
			$("#info-submit").val("Wypełnij dokumenty");
			break;
		case "176":
			$("#info-submit").val("Wypełnij dokumenty");
			break;
			// akcje w których zamieniamy napis na przycisku na "dalej"
		case "2":
		case "147":
			$("#info-submit").val("Dalej >");
			break;
			// domyślne zachowanie dla okien informacyjnych
		default:
			$("#info-submit").val("OK");
			break;
	}
}

function activateInfo(idTury, idAkcji, textWrittenCallBack, forceString, forceTopic) {
	var tura = idTury;
	var action = typeof idAkcji !== 'undefined' ? idAkcji : 0;
	var textCallBack = typeof textWrittenCallBack !== 'undefined' ? textWrittenCallBack : null;
	var forcedString = typeof forceString !== 'undefined' ? forceString : null;
	var forcedTopic = typeof forceTopic !== 'undefined' ? forceTopic : null;

	var istr = "";
	var itop = "";

	if (action > 0 || tura == 0 || tura == -1) {
		if (tura == 0 || tura == -1) idAkcji = tura;

		istr = window.infoString[idAkcji];
		itop = window.infoTopic[idAkcji];

		window.infoActionId = idAkcji;

		$("#dialog-info").dialog({
			autoOpen: true,
			show: {
				effect: "scale", // fold
				duration: 600, // 1000
				open: function() {
					var currentAction = typeof window.infoActionId !== 'undefined' ? window.infoActionId : window.userdata["ostatnia_akcja"];
					$.get(window.links.studentAjaxInfoSubmit, {
						"tura": window.userdata["tura"],
						"akcja": currentAction,
						"przeczytana": 0
					}, function(ret) {});
				},
				complete: function() {
					if (forcedTopic) {
						$("#info-bold-header").text(forcedTopic);
					} else {
						$("#info-bold-header").text(window.infoTopic[idAkcji]);
					}

					if (forcedString) {
						$("#info-txt").writeText(forcedString, function() {
							$("#info-submit").fadeIn(500);
							clearInterval(window.typewriter);
							if (textCallBack != null)
								textCallBack();
						});
					} else {
						if (idAkcji == 165 || idAkcji == 164) {
							$("#info-txt").html(window.infoString[idAkcji]);
							$("#info-submit").fadeIn(500);
						} else if (idAkcji == 81 || idAkcji == 82 || idAkcji == 83 || idAkcji == 84 || idAkcji == 85 || idAkcji == 86 || idAkcji == 87 || idAkcji == 161 || idAkcji == 162 || idAkcji == 173 || idAkcji == 174 || idAkcji == 175 || idAkcji == 177) {
							$("#info-txt").html("pobieranie informacji...");
							$.ajax({
								url: window.links.studentAjaxInfoSubmit,
								type: 'GET',
								data: {
									"tura": window.userdata["tura"],
									"akcja": idAkcji,
									"przeczytana": 1
								},
								success: function(ret) {
									if (ret != 0 && ret != null) {
										var res = jQuery.parseJSON(ret);
										//window.infoString[idAkcji] = res['tresc'];
										//window.infoTopic[idAkcji] = res['naglowek'];

										$("#info-txt").html(res['tresc']);
										$("#info-submit").fadeIn(500);
									}
								}
							});
						} else {
							$("#info-txt").writeText(window.infoString[idAkcji], function() { //istr, function() {
								$("#info-submit").fadeIn(500);
								clearInterval(window.typewriter);
								if (textCallBack != null)
									textCallBack();
							});
						}
					}
				}
			},
			hide: {
				effect: "clip", // explode
				duration: 500 // 1000
			},
			position: {
				my: "top", //"center",
				at: "top+20%", //+20%", //"center",
				of: window
			},
			closeOnEscape: false,
			draggable: true,
			resizable: false,
			width: 500,
		});
		$("#dialog-info").parent().children(".ui-widget-header").children(
			".ui-dialog-titlebar-close").css("display", "none");
		$("#info-submit").button().click(function() {
			submitInfo();
			if (action == 164 || action == 163 || action == 165 || action == 166 || action == 170 || action == 171 || action == 172 || action == 176 || action == 177) /// || action == 167 || action == 168 || action == 169)
			{
				$.ajax({
					url: window.links.studentAjaxPullMissedForms,
					data: {
						"lessonNo": window.userdata["tura"]
					},
					global: false, // do not show cursor loading animation for this ajax request
					type: 'GET',
					success: function(result) {
						if (action == 164 || action == 163 || action == 166 || action == 176) // || action == 165) bez niezaakceptowanych
						{
							$("#info-submit").val("OK");
							window.location.hash = "dokumenty";
						} else if (action == 177) {
							$.ajax({
								url: window.links.studentAjaxRemoveZalegleOplaty,
								global: false, // do not show cursor loading animation for this ajax request
								type: 'GET'
							});
							$("#info-submit").val("OK");
						} else //if(action == 165 || action == 166)
						{
							$("#info-submit").val("OK");
							window.location.hash = "city";
						}
					}
				});
			} else if (action == 14 || action == 50 || action == 16 || action == 52) {
				window.location.hash = 'city';
			}
		});
	} else {
		// get id of first action in this turn
		$.get(window.links.studentAjaxGetFirstAction, {
			"tura": tura
		}, function(re) {
			var akcja = re;
			if (akcja > 0) {
				istr = window.infoString[akcja];
				itop = window.infoTopic[akcja];

				window.infoActionId = akcja;

				$("#dialog-info").dialog({
					autoOpen: true,
					open: function() {
						var currentAction = typeof window.infoActionId !== 'undefined' ? window.infoActionId : window.userdata["ostatnia_akcja"];
						$.get(window.links.studentAjaxInfoSubmit, {
							"tura": window.userdata["tura"],
							"akcja": currentAction,
							"przeczytana": 0
						}, function(ret) {});
					},
					show: {
						effect: "scale",
						duration: 600,
						complete: function() {
							$("#info-bold-header").text(itop);
							$("#info-txt").writeText(istr, function() {
								$("#info-submit").fadeIn(500);
								clearInterval(window.typewriter);
								if (textCallBack != null)
									textCallBack();
							});
						}
					},
					hide: {
						effect: "clip", // explode
						duration: 500 // 1000
					},
					position: {
						my: "top", //"center",
						at: "top+20%", //+20%", //"center",
						of: window
					},
					closeOnEscape: false,
					draggable: true,
					resizable: false,
					width: 500,
				});
				$("#dialog-info").parent().children(".ui-widget-header").children(
					".ui-dialog-titlebar-close").css("display", "none");
				$("#info-submit").button().click(function() {
					$.ajax({
						url: window.links.studentAjaxPullMissedForms,
						data: {
							"lessonNo": window.userdata["tura"]
						},
						global: true, // tutaj pokazemy loader
						type: 'GET',
						success: function(result) {
							submitInfo();
						}
					});
				});
				specificActions(akcja);
			}
		});
	}

}

function fillText(string) {
	clearInterval(window.typewriter);
	$("#info-txt").writeText(string, function() {
		$("#info-submit").fadeIn(500);
		clearInterval(window.typewriter);
	});
}

/** GUI login **/

function activateLogin() {
	/**
	 * Dialog definitions
	 **/
	$("#dialog-login").dialog({
		autoOpen: false,
		hide: {
			effect: 'fold',
			duration: 500
		},
		show: {
			effect: 'fold',
			duration: 600
		},
		position: {
			my: "center",
			at: "center",
			of: window
		},
		closeOnEscape: false,
		draggable: false,
		resizable: false,
		width: 360
	});

	$("#dialog-login").parent().children(".ui-widget-header").children(".ui-dialog-titlebar-close").css("display", "none");
	$("#register-button").button().click(function() {
		window.location.hash = "#register";
	});
	$("#password-button").button().click(function() {
		window.location.hash = "#password";
	});
	$("#login-button").button();
	$("#UserStudentLoginForm_login, #UserStudentLoginForm_password").focus(function() {
		$(this).css("background-color", "#EBEBEB");
	});
}

function submitLogin() {
	Moodle.login();
	$.post(window.links.studentAjaxLogin, $("#login-form").serialize(), function(result) {
		$('#UserStudentLoginForm_login').tipsy('hide');
		var result = jQuery.parseJSON(result);
		if (result['error'] == undefined) {
			$(".hiddenMenu a").text("Wyloguj (" + result['imie'] + ")");
			window.userdata = result;
			$("#mainmenu a").each(function() { // menudiv
				if (this.text == "Panel administratora")
					$(this).parent().hide(1000);
				if (this.text == "Panel nauczyciela")
					$(this).parent().hide(1000);
				if ($(this).parent().attr('class') == "hiddenMenu")
					$(this).parent().css("display", "inline");
			});
			$(".ui-dialog-content").dialog("close");
			window.location.hash = "#city";

			//refresh info strings
			$.get(window.links.studentAjaxGetInfoStrings, function(result) {
				if (result != 0 && result != null) {
					result = jQuery.parseJSON(result);

					window.infoString = result.infoString;
					window.infoTopic = result.infoTopic;
				}
			});
		} else {
			$('#UserStudentLoginForm_login').attr('title', result['login']);
			$('#UserStudentLoginForm_login').tipsy({
				trigger: 'manual',
				gravity: 'e',
				fade: true
			});
			$('#UserStudentLoginForm_login').tipsy('show');
			$('.tipsy-inner').css('background-color', '#C00');
			$('.tipsy-arrow').css('border-right-color', '#C00');
			$('.tipsy-arrow').css('border-left-color', '#C00');

			$('#UserStudentLoginForm_login').focus(function() {
				$('#UserStudentLoginForm_login').tipsy('hide');
			});

			$('#UserStudentLoginForm_login').parents('.ui-dialog:first').click(function() {
				$('#UserStudentLoginForm_login').tipsy('hide');
			});

			$("#UserStudentLoginForm_login, #UserStudentLoginForm_password").css("background-color", "#FF5555");
			$("#dialog-login").parent().effect("shake", {}, 500);
		}
	});
	return false;
}

/** GUI password **/

function activatePassword() {
    /**
     * Dialog definitions
     **/
    $("#dialog-password").dialog({
        autoOpen: false,
        hide: {
            effect: 'fold',
            duration: 500
        },
        show: {
            effect: 'fold',
            duration: 600
        },
        position: {
            my: "center",
            at: "center",
            of: window
        },
        closeOnEscape: false,
        draggable: false,
        resizable: false,
        width: 400
    });
    $("#dialog-password").parent().children(".ui-widget-header").children(".ui-dialog-titlebar-close").css("display", "none");
    $("#password-send-button").button();

    /**
     * Events
     **/
    /*
	$("#dialog-password input[type=submit]").button().click(function()
        {
                        $("#dialog-password input").css("background-color", "#CC2222");
                        $("#dialog-password").parent().effect("shake", {}, 500);
                        return false;
        });
	$("#dialog-password input").on("focus", function() {$("#dialog-password input").css("background-color", "#FFFFFF"); });
	*/
    $(".back-button-password").button().click(function() {
        $('.tipsy').remove();
        window.location.hash = "";
    });
}

function submitPassword() {
    $.post(window.ajaxPasswordUrl, $('#password-form').serialize())
        .done(function(data) {
            //	console.log(data);
            //console.log(jQuery.parseJSON(data));
            errors = jQuery.parseJSON(data);
            if (errors['emailOrPesel']) {
                $('#UserStudentPasswordForm_emailOrPesel_em_').remove();
                //	$('#UserStudentPasswordForm_emailOrPesel').parent().append('<div id="UserStudentPasswordForm_emailOrPesel_em_" class="errorMessage">'+errors['emailOrPesel']+'</div>');
                $("#UserStudentPasswordForm_emailOrPesel").tipsy({
                    gravity: 'e',
                    trigger: 'manual',
                    title: function() {
                        return errors['emailOrPesel'];
                    }
                }).tipsy("show");
                $("#UserStudentPasswordForm_emailOrPesel").css("background-color", "#FF5555");
                $('#UserStudentPasswordForm_emailOrPesel').focus(function() {
                    $(this).tipsy('hide');
                });
                $("#dialog-password").parent().effect("shake", {}, 500);
            } else //showing info message
            {
                $('.tipsy').remove();
                $('#dialog-password-1').hide();
                $('#dialog-password-2').show();
            }
        });
}

/** GUI register **/

function showRegisterWindow(windowId, from) {
	console.log("showRegisterWindow: " + windowId);
	switch (windowId) {
		case "dialog-register-1":
			$('div[id^="dialog-register-"]').hide();
			$("#dialog-register-1").show();
			$("#dialog-register").dialog("widget").animate({
				width: '300px'
			}, {
				duration: 500,
				step: function() {
					$("#dialog-register").dialog('option', 'position', 'center')
				}
			});
			$("#dialog-register").dialog('option', 'title', $("#dialog-register-1").attr("title"));
			clearInterval(window.typewriter);
			break;
		case "dialog-register-2":
			$('div[id^="dialog-register-"]').hide();
			$("#dialog-register-2").fadeIn(1500); //show();
			$("#dialog-register").dialog("widget").animate({
				width: '480px'
			}, {
				duration: 500,
				step: function() {
					$("#dialog-register").dialog('option', 'position', 'top+15%')
				}
			}); // center')}});
			$("#info1").writeText(window.registerString.info1, function() {
				$("#register-submit-2").fadeIn(500);
				clearInterval(window.typewriter);
			});
			$("#dialog-register").dialog('option', 'title', $("#dialog-register-2").attr("title"));
			break;
		case "dialog-register-3":
			$('div[id^="dialog-register-"]').hide();
			$("#dialog-register-3").show();
			$("#dialog-register").dialog("widget").animate({
				width: '480px'
			}, {
				duration: 500,
				step: function() {
					$("#dialog-register").dialog('option', 'position', 'center')
				}
			});
			$("#dialog-register").dialog('option', 'title', $("#dialog-register-3").attr("title"));
			break;
		case "dialog-register-4":
		case "dialog-register-4-1":
			$('div[id^="dialog-register-"]').hide();
			$("#dialog-register-4").show();
			$("#dialog-register").dialog("widget").animate({
				width: '430px'
			}, {
				duration: 500,
				step: function() {
					$("#dialog-register").dialog('option', 'position', 'center')
				}
			});
			$("#dialog-register").dialog('option', 'title', $("#dialog-register-4").attr("title"));
			break;
		case "dialog-register-5":
			$('div[id^="dialog-register-"]').hide();
			$("#dialog-register-5").show();
			$("#dialog-register").dialog("widget").animate({
				width: '640px'
			}, {
				duration: 500,
				step: function() {
					$("#dialog-register").dialog('option', 'position', 'center')
				}
			}); // 590
			$("#dialog-register").dialog('option', 'title', $("#dialog-register-5").attr("title"));
			$("#dialog-register-5 .users-summary").html(getUsersSummary());
			break;
		case "dialog-register-6":
			$('div[id^="dialog-register-"]').hide();
			$("#dialog-register-6").show();
			$("#dialog-register").dialog("widget").animate({
				width: '480px'
			}, {
				duration: 500,
				step: function() {
					$("#dialog-register").dialog('option', 'position', 'top+15%')
				}
			}); // center
			$("#infoEnd").writeText(window.registerString.infoEnd, function() {
				$("#register-submit-6").fadeIn(500);
				clearInterval(window.typewriter);
			});
			$("#dialog-register").dialog('option', 'title', $("#dialog-register-6").attr("title"));
			break;
		case "dialog-register-7":
			$('div[id^="dialog-register-"]').hide();
			$("#dialog-register-7").show();
			$("#dialog-register").dialog("widget").animate({
				width: '500px'
			}, {
				duration: 500,
				step: function() {
					$("#dialog-register").dialog('option', 'position', 'center')
				}
			});
			//$("#infoEnd").writeText(window.registerString.infoEnd, function() { $("#register-submit-7").fadeIn(500); clearInterval(window.typewriter); });
			$("#dialog-register").dialog('option', 'title', $("#dialog-register-7").attr("title"));
			break;
		default: //showing user add step
			if (windowId != undefined && windowId.substr(0, 17) != "dialog-register-4" && windowId.substr(0, 25) != "dialog-register-summary-4")
				break;

			var userWindowId = $("#" + windowId).attr('userWindowId');

			//showing summary window
			if ($("#" + windowId).attr('isSummaryWindow') != undefined) {
				console.log($("#" + windowId));
				$('div[id^="dialog-register-"]').hide();
				var summaryHtml = '<div class="row" style="text-align:center"><b>Informacja</b></div>\n\
							<div class="row" class="users-summary" style="padding: 10px; margin: 5px; background-color: #FFFFFF; border: 1px solid #333333; text-align: justify;">' + getUsersSummary(userWindowId) + '\
							</div>';
				$("#dialog-register-summary-4-" + userWindowId + " .register-form-left").html(summaryHtml);
				$("#dialog-register-summary-4-" + userWindowId).show();
				$("#dialog-register").dialog("widget").animate({
					width: '540px'
				}, {
					duration: 500,
					step: function() {
						$("#dialog-register").dialog('option', 'position', 'center')
					}
				});
				$("#dialog-register").dialog('option', 'title', $("#dialog-register-4-" + (userWindowId)).attr("title"));
			} else //showing form window
			{
				$('div[id^="dialog-register-"]').hide();
				$("#register-submit-summary-4-" + (userWindowId - 1)).hide();
				$("#register-submit-summary-4-" + (userWindowId - 1) + "-b").show();
				$("#dialog-register-4-" + userWindowId).show();
				$("#dialog-register").dialog("widget").animate({
					width: '500px'
				}, {
					duration: 500,
					step: function() {
						$("#dialog-register").dialog('option', 'position', 'center')
					}
				});
				$("#dialog-register").dialog('option', 'title', $("#dialog-register-4-" + (userWindowId)).attr("title"));
			}
			break;
	}
}

function activateRegister() {
	/**
	 * Dialog definitions
	 **/
	$("#dialog-register").dialog({
		autoOpen: false,
		hide: {
			effect: 'fold',
			duration: 500
		}, // clip
		show: {
			effect: 'fold',
			duration: 600
		}, // scale
		position: {
			my: "center",
			at: "center",
			of: window
		},
		closeOnEscape: false,
		draggable: false,
		resizable: false,
		width: 300
	});
	$("#dialog-register").parent().children(".ui-widget-header").children(".ui-dialog-titlebar-close").css("display", "none");
	$("#dialog-register").dialog('option', 'title', $("#dialog-register-1").attr("title"));
	$('[id^="dialog-register"][id!="dialog-register-1"]').css("display", "none");
	//$("#dialog-register-2, #dialog-register-3, #dialog-register-4, #dialog-register-4-2, #dialog-register-4-3, #dialog-register-4-4, #dialog-register-4-5, #dialog-register-4-6, #dialog-register-5, #dialog-register-6, #dialog-register-7").css("display", "none");
	//dialog-register-summary
	$("#register-submit-2, #register-submit-6").css("display", "none");

	/**
	 * Events
	 **/
	$("#dialog-register input").on("focus", function() {
		$("#dialog-register input").css("background-color", "#FFFFFF");
	});

	//next button handler
	$('[id^="register-submit"]').button().click(function() {
		if ($(this).is('[id^="register-submit-4"],[id^="register-submit-summary-4"]') || $(this).is('[id^="register-submit-5"]')) //we handle 4-* dialogs after ajax validation
			return false;
		if ($(this).attr('id') == 'register-submit')
			showRegisterWindow($(this).attr("target"), 'dialog-register-1');
		else
			showRegisterWindow($(this).attr("target"));
	});

	$("#register-submit-6").button().click(function() {
		console.log("#register-submit-6 click");
		$("#dialog-register-6").hide();
		window.location.hash = "";
	});

	//back button handler
	$('form').on('click', '[id^="register-back"][id!="register-back-5"]', function() {
		$('.tipsy').remove();
		showRegisterWindow($(this).attr("target"));
	});

	$('[id^="register-back"]').button();

	$('#register-back-1,#register-submit-7').button().click(function() {
		$('.tipsy').remove();
		window.location.hash = "";
	});

	$('#register-back-5').button().click(function() {
		showRegisterWindow('dialog-register-4-' + getLastUserView());
	});

	$("#UserRegistrationForm_city").change(function() {
		loadSchools($(this).val());
	});

	$("document").ready(function() {
		loadSchools($("#UserRegistrationForm_city").val());
	});

	$('#UserRegistrationForm_school').change(function() {
		loadClasses($(this).val());
	});

	$('[id^="register-submit-4"],[id^="register-submit-summary-4"],#register-submit-5,.register-submit-4').button().click(function() {
		var target = $(this).attr("target");
		var address = $('form#register-form').serialize();
		var validateFormId = $('[id^="dialog-register-4"]:visible').attr("userWindowId");

		//hide error messages
		$(".tipsy").fadeOut(400, function() {
			$(".tipsy").remove();
		});

		//validating single user form
		if (validateFormId > 0)
			address += '&validateFormId=' + validateFormId;

		if ($(this).hasClass('registerFinishButton') && !$('[name="users-check"]').is(':checked'))
			return false;
		if ($(this).hasClass('registerFinishButton'))
			address += '&register=true';

		$.post(window.ajaxRegisterFormUrl, address,
			function(data) {
				var resultErrors = jQuery.parseJSON(data);

				if (hasErrors(resultErrors)) {
					console.log(resultErrors);
					//has errors with class - time is out =
					if (!(resultErrors[0] instanceof Array)) {
						showRegisterWindow('dialog-register-7');
					} else {
						$('#dialog-register').find('.errorMessage').remove();
						displayErrors(resultErrors);
					}
				} else {
					console.log(resultErrors);
					showRegisterWindow(target);
				}
			});
	});
}

function getCurrentUserFormId() {
	var userFormId = $('[id^="dialog-register-4"]:visible').attr("id");
	if (!userFormId)
		return 0;
	userFormId = userFormId.length == 0 ? '1' : userFormId;
	return userFormId;
}

function hasErrors(errors) {
	for (var i = 0; i < errors.length - 1; i++)
		if (errors[i].length != 0)
			return true;
	return false;
}

function displayErrors(errors) {
	var firstUserError = 0;
	for (var i = 0; i <= window.numberOfMaxUsers; i++) {
		if (errors[i].length === 0)
			continue;
		else if (firstUserError == 0)
			firstUserError = i;

		for (var attribute in errors[i]) {
			var currentInput = $('[name="Uzytkownik[' + i + '][' + attribute + ']"]:last');
			/**************************/
			if (currentInput.next('.errorMessage').length == 0) //error message div not exists
			{
				//	currentInput.parent().append('<div id="Uzytkownik_'+i+'_'+attribute+'_em_" class="errorMessage"></div>');
			}

			var tipsyGravity = 'w';

			if ($('#Uzytkownik_' + i + '_' + attribute).attr('type') == 'radio' || $('#Uzytkownik_' + i + '_' + attribute).attr('type') == 'checkbox')
				tipsyGravity = 'e';

			$('#Uzytkownik_' + i + '_' + attribute).attr('title', errors[i][attribute][0]);
			$('#Uzytkownik_' + i + '_' + attribute).tipsy({
				trigger: 'manual',
				gravity: tipsyGravity,
				fade: true
			});
			$('#Uzytkownik_' + i + '_' + attribute).tipsy("show");

			//$('#Uzytkownik_'+i+'_'+attribute).addClass('error');
			$('.tipsy-inner').css('background-color', '#C00');
			$('.tipsy-arrow').css('border-right-color', '#C00');
			$('.tipsy-arrow').css('border-left-color', '#C00');

			$('[name="Uzytkownik[' + i + '][' + attribute + ']"]').change(function() {
				$('[name="' + $(this).attr("name") + '"]').tipsy('hide');
				/*$(this).removeClass('error');
				$(this).animate({
					borderColor: '#FFF'
				},
				{
					finish: function() {
							$(this).removeClass('error');
						}
				});*/
			});

			//currentInput.parent().find('.errorMessage').text(errors[i][attribute]);
			/**************************/
			// TODO wstawić tipsy zamiast powyższych  /***/ tak jak poniżej:
			// currentInput.tipsy({gravity: 'w', trigger: 'manual', title: function() { return errors[i][attribute]; } }).tipsy("show");
		}
	}

	showRegisterWindow('dialog-register-4-' + firstUserError);
}

function getUsersSummary(userWindowId) {
	var summaryHtml = '';
	var userId = 1;
	var selector = '[id^="dialog-register-4"]';

	if (userWindowId != undefined) {
		selector = '[id^="dialog-register-4"][userWindowId="' + userWindowId + '"]';
		userId = userWindowId;
	}

	$(selector).each(function() {
		var formEmpty = true;
		$(this).find('input[type="text"],input[type="password"]').each(function() {
			if ($(this).val().length > 0)
				formEmpty = false;
		});
		if (!formEmpty) {
			//console.log($(this).find('input[name^="Uzytkownik"]').val());
			summaryHtml += '<table>';
			summaryHtml += '<tr><td colspan="2"><b>Użytkownik nr ' + userId + ':</b></td></tr>';
			console.log('<tr><td colspan="2" style="text-align: right;">\n\
								<input type="button" style="background: url("' + window.baseUrl + '/images/gui/update.png") no-repeat; cursor: pointer; width: 20px; height: 22px;" id="register-back-summary-4-' + userId + '" target="dialog-register-4-' + userId + '" name="back" value="  " />\n\
							</td></tr>');
			if (userWindowId == undefined)
				summaryHtml += '<tr><td colspan="2" style="text-align: right;">\n\
								<input type="button" class="register-edit-user" id="register-back-summary-4-' + userId + '" target="dialog-register-4-' + userId + '" name="back" value="  " />\n\
							</td></tr>';
			summaryHtml += '<tr><td>Imię: </td><td>' + $('input[name="Uzytkownik[' + userId + '][imie]"]').val() + '</td></tr>';
			summaryHtml += '<tr><td>Nazwisko: </td><td>' + $('input[name="Uzytkownik[' + userId + '][nazwisko]"]').val() + '</td></tr>';
			summaryHtml += '<tr><td>E-mail: </td><td>' + $('input[name="Uzytkownik[' + userId + '][email]"]').val() + '</td></tr>';
			summaryHtml += '</table>';
		}
		userId++;
	});
	return summaryHtml;
}

//searchs for last user form window with at least one field not empty, used while going back from last page
function getLastUserView() {
	var lastUserId = 0;
	$('[id^="dialog-register-4"]').each(function() {
		var formEmpty = true;
		$(this).find('input[type="text"],input[type="password"]').each(function() {
			if ($(this).val().length > 0)
				formEmpty = false;
		});
		if (!formEmpty)
			lastUserId++;
		else
			return false;
	});

	return lastUserId;
}

function loadSchools(cityName) {
	console.log(cityName);
	$('.schoolsSelectContainer option').hide();
	$('[data-user-reg-form-school="' + cityName + '"]').show();
	$('.schoolsSelectContainer select').val($('[data-user-reg-form-school="' + cityName + '"]:first').val());
	loadClasses($('.schoolsSelectContainer select').val());
}

function loadClasses(schoolId) {
	$('.classesSelectContainer option').hide();
	$('.UserRegistrationForm_class_' + schoolId).show();
	$('.classesSelectContainer select').val($('.UserRegistrationForm_class_' + schoolId + ':first').val());
}
